(******************************************************************************
tBmAssist v2.0

Derived from
    tComponent

Properties
    AnimPlaying     : True when an animation is playing
    AssHeader       : Header for assistant tips dialog
    AssTipHelp      : Help caption for assistant tips dialog
    AssTitle        : Title for assistant tips dialog
    LibraryName     : File containing animations
    TipsAtStart     : If true, assistant display tips at starts
    Tips            : List of tips to display
    TipsCount       : Number of tips in the list
    UseSound        : Use sounds with animations ?
    MoveStep        : Step when moving assistant

Inherited properties
    all properties from tComponent.

procedures
    Show            : Show assistant (fully animated, or quickly)
    Hide            : Hide assistant (fully animated, or quickly)
    Dialog          : Replace standard dialog function
    ShowTips        : Display tips windows
    MoveTo          : Move (animated) assistant to any position
    SetPosition     : Set position of assistant
    SetCustom       : Select animation for custom dialog
    AnimPlay        : Play a custom animation (without opening dialog box)
    AnimBack        : Play reverse last animation
    StartProcessing : Start processing animation (start looping animatation)
    StopProcessing  : Stop processing animation (stop looping animation)
    Transparent     : Display assistant transparently
    AboutAssist     : Display about assistant dialog-box
    AboutAnims      : Display about animations dialog-box
    GetAnimList     : List of available animations
    GetAnimsVersion : Return animations version
    GetWidth        : Width of assistant (read-only)
    GetHeight       : Height of assistant (read-only)
    GetLeft         : Left of assistant
    GetTop          : Top of assistant
    SetLeft         : Left of assistant
    SetTop          : Top of assistant

Events
    all events from tComponent.

********************************************************************************)

{If you have problems with these lines, remove them and mail me
 which compiler you have. I will correct it for future versions}
{$IFDEF WIN32} {Only for 32 bits compilers}
  {$IFNDEF VER90} {Doesn't works with Delphi 2}
    {$IFNDEF VER100} {Doesn't works with Delphi 3}
      {$ObjExportAll On} {export all objects (for C++Builder 3.0)}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

unit BmAssist;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, DsgnIntf,
  Forms, Dialogs, BmAssMsc, BmFAss, BmFDlg;

type
  tBmAssist = class(TComponent)
  private
    FAbout : TAboutMeProperty;
    FAssistDlg : tFormAssist;
    FLibName : string;
    FEnableIdle : boolean;
    function GetAnimPlaying : boolean;
    function GetAssHeader : String;
    procedure SetAssHeader (value : String);
    function GetAssTipHelp : String;
    procedure SetAssTipHelp (value : String);
    function GetAssTitle : String;
    procedure SetAssTitle (value : String);
    function GetEnableIdle : boolean;
    procedure SetEnableIdle (value : boolean);
    function GetLibName : String;
    procedure SetLibName (value : String);
    function GetMoveStep : integer;
    procedure SetMoveStep (value : Integer);
    function GetTips : tStringList;
    procedure SetTips(Value:TStringList);
    function GetTipsAtStart : boolean;
    procedure SetTipsAtStart (value : boolean);
    function GetTipsCount: word;
{$IFDEF WIN32}
    procedure SetTransparent (value : boolean);
    function GetTransparent : boolean;
{$ENDIF}    
    function GetUseSound : Boolean;
    procedure SetUseSound (value : Boolean);
    Function GetVisible : Boolean;
  protected
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    Procedure Show(Fast : boolean);
    Procedure Hide(Fast : boolean);
    function Dialog (const Msg: string; AType: TMsgDlgType;
                     AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
    Function ShowTips : word;
    procedure MoveTo (x, y : integer);
    procedure SetPosition (x, y : integer);
    procedure SetCustom (AnimName : pChar);
    procedure AnimPlay (AnimName : pChar; isReverse : boolean);
    procedure AnimBack;
    procedure StartProcessing;
    procedure StopProcessing;
    procedure AboutAssist;
    procedure AboutAnims;
    function GetAnimList : pChar;
    function GetAnimsVersion : tVersion;
    Function GetWidth : integer;
    Function GetHeight : integer;
    Function GetLeft : integer;
    procedure SetLeft (value : integer);
    Function GetTop : integer;
    procedure SetTop (value : integer);
  published
    property About: TAboutMeProperty read FAbout write FAbout;
    property AnimPlaying : boolean read GetAnimPlaying;
    Property AssHeader : string read GetAssHeader write SetAssHeader;
    Property AssTipHelp  : string read GetAssTipHelp write SetAssTipHelp;
    Property AssTitle  : string read GetAssTitle write SetAssTitle;
    Property EnableIdle : boolean read GetEnableIdle write SetEnableIdle default true;
    Property LibraryName : string read GetLibName write SetLibName;
    Property MoveStep : integer read GetMoveStep write SetMoveStep default 8;
    Property TipsAtStart : boolean read GetTipsAtStart write SetTipsAtStart default true;
    Property Tips : TStringList read GetTips write SetTips;
    Property TipsCount : word read GetTipsCount;
{$IFDEF WIN32}
    property Transparent : boolean read GetTransparent write SetTransparent default true;
{$ENDIF}
    Property UseSound : boolean read GetUseSound write SetUseSound default true;
    Property visible : boolean read GetVisible;
end;

procedure Register;

implementation

{$IFNDEF WIN32}
  {$R *.D16}
{$ELSE}
  {$R *.D32}
{$ENDIF}

procedure Register;
begin
  RegisterComponents('BmSuite',[tBmAssist]);
  RegisterPropertyEditor (TypeInfo(TAboutMeProperty), tBmAssist,
                          'ABOUT', TAboutMeProperty);
end;

{************************* tBmAssist component *************************}
constructor tBmAssist.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  FLibName := '';
  FEnableIdle := True;
  fAssistDlg := tFormAssist.Create(Application);
  fAssistDlg.Visible := False;
  TipsAtStart := true;
{$IFDEF WIN32}
  Transparent := true;
{$ENDIF}
end;

destructor tBmAssist.Destroy;
begin
{  fAssistDlg.Free;} {Done automatically by application}
  inherited Destroy;
end;

procedure tBmAssist.Show(Fast : boolean);
begin
  fAssistDlg.ShowAssist(Fast);
end;

procedure tBmAssist.Hide(Fast : boolean);
begin
  fAssistDlg.HideAssist(Fast);
end;

function tBmAssist.GetAnimPlaying : boolean;
begin
  Result := fAssistDlg.Animated.Play;
end;

function tBmAssist.GetAssHeader : String;
begin
  Result := fAssistDlg.AssHeader;
end;

procedure tBmAssist.SetAssHeader (value : String);
begin
  if fAssistDlg.AssHeader<>value
    then fAssistDlg.AssHeader := Value;
end;

function tBmAssist.GetAssTipHelp : String;
begin
  Result := fAssistDlg.AssTipHelp;
end;

procedure tBmAssist.SetAssTipHelp (value : String);
begin
  if fAssistDlg.AssTipHelp<>value
    then fAssistDlg.AssTipHelp := Value;
end;

function tBmAssist.GetAssTitle : String;
begin
  Result := fAssistDlg.AssTitle;
end;

procedure tBmAssist.SetAssTitle (value : String);
begin
  if fAssistDlg.AssTitle<>value
    then fAssistDlg.AssTitle := Value;
end;

function tBmAssist.GetEnableIdle : boolean;
begin
  Result := FEnableIdle;
end;

procedure tBmAssist.SetEnableIdle (value : boolean);
begin
  if FEnableIdle<>value
  then begin
    FEnableIdle := value;
    if not (csDesigning in ComponentState)
      then fAssistDlg.SetEnableIdle (value);
  end;
end;

function tBmAssist.GetLibName : String;
begin
  Result := FLibName;
end;

procedure tBmAssist.SetLibName (value : String);
begin
  FLibName:=value;
  fAssistDlg.AssistDLL.LibraryName := FLibName;
end;

function tBmAssist.GetMoveStep : integer;
begin
  Result := fAssistDlg.MoveStep;
end;

procedure tBmAssist.SetMoveStep (value : Integer);
begin
  fAssistDlg.MoveStep := value;
end;


function tBmAssist.GetTipsAtStart : boolean;
begin
  Result := fAssistDlg.TipsAtStart;
end;

procedure tBmAssist.SetTipsAtStart (value : boolean);
begin
  If fAssistDlg.TipsAtStart <> Value
    then fAssistDlg.TipsAtStart := Value;
end;

function tBmAssist.GetTips : TStringList;
begin
  Result := fAssistDlg.Tips;
end;

procedure tBmAssist.SetTips(Value:TStringList);
begin
  If fAssistDlg.Tips <> Value
    then fAssistDlg.Tips.Assign(Value);
end;

function tBmAssist.GetTipsCount:Word;
begin
  Result := fAssistDlg.Tips.Count;
end;

procedure tBmAssist.SetTransparent (value : boolean);
begin
  fAssistDlg.SetTransparent (value);
end;

function tBmAssist.GetTransparent : boolean;
begin
  Result := fAssistDlg.GetTransparent;
end;

function tBmAssist.GetUseSound : Boolean;
begin
  Result := fAssistDlg.UseSound;
end;

procedure tBmAssist.SetUseSound (value : Boolean);
begin
  If fAssistDlg.UseSound <> Value
    then fAssistDlg.UseSound := Value;
end;

function tBmAssist.Dialog (const Msg: string; AType: TMsgDlgType;
                         AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
begin
  Result := fAssistDlg.Dialog (Msg, aType, aButtons, HelpCtx);
end;

function tBmAssist.ShowTips: word;
begin
  Result := fAssistDlg.ShowTips;
end;

procedure tBmAssist.MoveTo (X, Y : integer);
begin
  fAssistDLG.MoveTo(X, Y);
end;

procedure tBmAssist.SetPosition (X, Y : integer);
begin
  fAssistDLG.SetPosition(X, Y);
end;

function tBmAssist.GetAnimList : pChar;
begin
  result := fAssistDLG.GetAnimList;
end;

function tBmAssist.GetAnimsVersion : tVersion;
begin
  result := fAssistDLG.GetAnimsVersion;
end;

Function tBmAssist.GetWidth : integer;
begin
  Result := fAssistDLG.Width;
end;

Function tBmAssist.GetHeight : integer;
begin
  Result := fAssistDLG.Height;
end;

Function tBmAssist.GetLeft : integer;
begin
  Result := fAssistDLG.Left;
end;

procedure tBmAssist.SetLeft (value : integer);
begin
  fAssistDLG.Left := value;
end;

Function tBmAssist.GetTop : integer;
begin
  Result := fAssistDLG.Top;
end;

procedure tBmAssist.SetTop (value : integer);
begin
  fAssistDLG.Top := value;
end;

Function tBmAssist.GetVisible : Boolean;
begin
  Result := fAssistDLG.Visible;
end;

procedure tBmAssist.SetCustom (AnimName : pChar);
begin
  fAssistDLG.SetCustom (AnimName);
end;

procedure tBmAssist.AnimPlay (AnimName : pChar; isReverse : boolean);
begin
  fAssistDLG.AnimPlay (AnimName, isReverse);
end;

procedure tBmAssist.AnimBack;
begin
  fAssistDLG.AnimBack;
end;

procedure tBmAssist.StartProcessing;
begin
  fAssistDLG.StartProcessing;
end;

procedure tBmAssist.StopProcessing;
begin
  fAssistDLG.StopProcessing;
end;

procedure tBmAssist.AboutAssist;
begin
  fAssistDLG.AboutComp(Self);
end;

procedure tBmAssist.AboutAnims;
begin
  fAssistDLG.AboutAnims(Self);
end;

end.
