unit BmAssMsc;

interface

uses
  WinProcs, WinTypes, Messages,
  Classes, Controls, Dialogs, DsgnIntf, Forms, SysUtils;

const
  AboutStr      = 'tBmAssist component v2.01.'
                  +#13#10'This component is freeware.'
                  +#13#10' 1998 BOURMAD Mehdi'
                  +#13#10'http://www.multimania.com/bourmad'
                  +#13#10'mailto:bourmad@multimania.com';
  IdsPopupName  = 'About...';
  IdsAboutComp  = 'Assistant';
  IdsAboutAnims = 'Animations';

  IdsNoTips        = 'Il n''y a pas d''astuces...';
  LoadError        = 'Erreur au chargement de la librairie de l''assistant.';
  ButtonNextTips   = '&Suite';

  DialogType    : array[tMsgDlgType] of String
                = ('Attention', 'Erreur', 'Information', 'Confirmation', 'Assistant');
  ButtonCaption : array[tMsgDlgBtn] of string
                = ('&Oui', '&Non', 'O&K', '&Annuler', 'A&bandonner',
                   '&Reessayer', 'I&gnorer', '&Tout',
                   {$IFDEF WIN32}'Non  to&ut', 'Ou&i  tout',{$ENDIF} 'Ai&de');

(* {English resources}
  IdsNoTips        = 'No tips available...';
  LoadError        = 'Error loading assistant library. Error n';
  ButtonNextTips   = '&Next';

  DialogType    : array[tMsgDlgType] of String
                = ('Warning', 'Error', 'Information', 'Confirmation', 'Custom');
  ButtonCaption : array[tMsgDlgBtn] of string
                = ('Yes', 'No', 'OK', 'Cancel', 'Abort',
                   'Retry', 'Ignore', 'All',
                   {$IFDEF WIN32}'No to all', 'Yes to all',{$ENDIF} 'Help');

*)



{$IFNDEF WIN32}
{strings extracted from WinApi help}
  ErrorStr : Array[0..21] of string
           = ('System was out of memory, executable file was corrupt,'
                +' or relocations were invalid.',
              'Error n1',
              'File was not found.',
              'Path was not found.',
              'Error n4',
              'Attempt was made to dynamically link to a task'
                +' or there was a sharing or network-protection error.',
              'Library required separate data segments for each task.',
              'Error n7',
              'There was insufficient memory to start the application.',
              'Error n9',
              'Windows version was incorrect.',
              'Executable file was invalid. Either it was not a Windows'
                +' application or there was an error in the .EXE image.',
              'Application was designed for a different operating system.',
              'Application was designed for MS-DOS 4.0.',
              'Type of executable file was unknown.',
              'Attempt was made to load a real-mode application'
                +' (developed for an earlier version of Windows).',
              'Attempt was made to load a second instance of an executable file'
                +' containing multiple data segments that were not marked read-only.',
              'Error n17',
              'Error n18',
              'Attempt was made to load a compressed executable file.'
                +' The file must be decompressed before it can be loaded.',
              'Dynamic-link library (DLL) file was invalid.'
                +' One of the DLLs required to run this application was corrupt.',
              'Application requires 32-bit extensions.');
{$ENDIF}

  ButtonResult : array[tMsgDlgBtn] of tModalResult
               = (mrYes, mrNo, mrOk, mrCancel, mrAbort, mrRetry, mrIgnore, mrAll,
                  {$IFDEF WIN32}mrNoToAll, mrYesToAll,{$ENDIF} mrNone);

type
  tVersion = record
               Major,
               Minor,
               Release,
               Build : integer;
             end;  

  DialogMode  = (dmMessage, dmTips);
{oriented animations}
  tOriNames   = (onGesture, onGlance, onLook, onMove);
{orientation types}
  tOriTypes   = (toLeft, toUp, toRight, toDown);

  tLoadAnimFct = function (AnimName : pChar) : hBitmap; stdcall;
  tLoadSoundFct = function (SoundName : pChar) : tMemoryStream; stdcall;
  tGetBoundsFct = function : tPoint; stdcall;
  tGetPCharFct = function : pChar; stdcall;
  tGetIntParmFct = function (aString : pChar) : Integer; stdcall;
  tGetStrParmFct = function (aString : pChar) : pChar; stdcall;
  tGetOrientedFct = function (Animation : tOriNames; Orientation : tOriTypes) : pChar; stdcall;

  {*********** tAboutMeProperty ************}
  TAboutMeProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

implementation

{************************* tAboutMeProperty component *************************}
procedure TAboutMeProperty.Edit;
begin
  Application.MessageBox (AboutStr, 'About', MB_OK+ MB_ICONINFORMATION);
end;

function TAboutMeProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutMeProperty.GetValue: string;
begin
  Result := '(about)';
end;

end.