unit BmAssDLL;

interface

uses
  WinProcs, WinTypes, Messages,
  Classes, Controls, Dialogs, DsgnIntf, Forms, SysUtils,
  BmAssMsc;

type
  {*********** tAssistDLL ************}
  TAssistDll = class(tComponent)
  private
    FAssistInstance : tHandle;
    FLibraryName : String;
    procedure SetLibraryName (value : string);
    procedure DisplayInstanceError (anInstance : tHandle);
    procedure LoadFunctions;
  public
    LoadAnim            : tLoadAnimFct;
    LoadSound           : tLoadSoundFct;
    GetAnimList         : tGetPCharFct;
    GetCopyright        : tGetPCharFct;
    GetBounds           : tGetBoundsFct;
    GetAnimHDR          : tGetPCharFct;
    GetSoundHDR         : tGetPCharFct;
    GetAnimSpeed        : tgetIntParmFct;
    GetSoundFrame       : tgetIntParmFct;
    GetConfirmationName : tGetPCharFct;
    GetErrorName        : tGetPCharFct;
    GetHideName         : tGetPCharFct;
    GetIdleName         : tGetPCharFct;
    GetInformationName  : tGetPCharFct;
    GetOrientedName     : tGetOrientedFct;
    GetProcessingName   : tGetPCharFct;
    GetRestName         : tGetPCharFct;
    GetReturnName       : tGetStrParmFct;
    GetShowName         : tGetPcharFct;
    GetStartName        : tGetStrParmFct;
    GetTipsName         : tGetPCharFct;
    GetWarningName      : tGetPCharFct;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function InstanceLoaded : boolean;
    procedure LoadDLL;
  published
    property AssistInstance : tHandle read FAssistInstance;
    property LibraryName : string read FLibraryName write SetLibraryName;
  end;

implementation

constructor tAssistDLL.Create(AOwner: TComponent);
begin
  inherited Create (aOwner);
  FAssistInstance := 0;
  LoadAnim := nil;
  LoadSound := nil;
  GetAnimList := nil;
  GetCopyright := nil;
  GetBounds := nil;
  GetAnimHDR := nil;
  GetSoundHDR := nil;
  GetAnimSpeed := nil;
  GetSoundFrame := nil;
  GetConfirmationName := nil;
  GetErrorName := nil;
  GetHideName := nil;
  GetIdleName := nil;
  GetInformationName := nil;
  GetOrientedName := nil;
  GetProcessingName := nil;
  GetRestName := nil;
  GetReturnName := nil;
  GetShowName := nil;
  GetStartName := nil;
  GetTipsName := nil;
  GetWarningName := nil;
end;

destructor tAssistDLL.Destroy;
begin
  if InstanceLoaded
    then FreeLibrary (AssistInstance);
  inherited Destroy;
end;

procedure tAssistDLL.SetLibraryName (value : string);
begin
  if FLibraryName <> value
  then begin
    if InstanceLoaded
    then begin
      FreeLibrary (AssistInstance);
      FAssistInstance := 0;
    end;
    FLibraryName := value;
  end;
end;

procedure tAssistDLL.DisplayInstanceError (anInstance : tHandle);
var
  Buf : array[0..255] of Char;
  Err : integer;
begin
{$IFNDEF WIN32}
    if anInstance <= HINSTANCE_ERROR
    then
      ShowMessage (LoadError + #13#10 + ErrorStr[anInstance]);
{$ELSE}
    if anInstance = 0
    then begin
      Buf := #0;
      Err := GetLastError;
      FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM, nil, Err, 0, Buf, 255, nil);
      ShowMessage (LoadError + #13#10 + StrPas(Buf));
    end;
{$ENDIF}
end;

procedure tAssistDLL.LoadFunctions;
begin
  @LoadAnim := GetProcAddress(AssistInstance, 'LoadAnim');
  if @LoadAnim = nil
    then ShowMessage (LoadError + #13#10 + 'LoadAnim');
  @LoadSound := GetProcAddress(AssistInstance, 'LoadSound');
  if @LoadSound = nil
    then ShowMessage (LoadError + #13#10 + 'LoadSound');

  @GetAnimList := GetProcAddress(AssistInstance, 'GetAnimList');
  if @GetAnimList = nil
    then ShowMessage (LoadError + #13#10 + 'GetAnimList');

  @GetCopyright := GetProcAddress(AssistInstance, 'GetCopyright');
  if @GetCopyright = nil
    then ShowMessage (LoadError + #13#10 + 'GetCopyright');

  @GetBounds := GetProcAddress(AssistInstance, 'GetBounds');
  if @GetBounds = nil
    then ShowMessage (LoadError + #13#10 + 'GetBounds');

  @GetAnimHDR := GetProcAddress(AssistInstance, 'GetAnimHDR');
  if @GetAnimHDR = nil
    then ShowMessage (LoadError + #13#10 + 'GetAnimHDR');
  @GetSoundHDR := GetProcAddress(AssistInstance, 'GetSoundHDR');
  if @GetSoundHDR = nil
    then ShowMessage (LoadError + #13#10 + 'GetSoundHDR');

  @GetAnimSpeed := GetProcAddress(AssistInstance, 'GetAnimSpeed');
  if @GetAnimSpeed = nil
    then ShowMessage (LoadError + #13#10 + 'GetSoundFrame');
  @GetSoundFrame := GetProcAddress(AssistInstance, 'GetSoundFrame');
  if @GetSoundFrame = nil
    then ShowMessage (LoadError + #13#10 + 'GetSoundFrame');

  @GetConfirmationName := GetProcAddress(AssistInstance, 'GetConfirmationName');
  if @GetConfirmationName = nil
    then ShowMessage (LoadError + #13#10 + 'GetConfirmationName');
  @GetErrorName := GetProcAddress(AssistInstance, 'GetErrorName');
  if @GetErrorName = nil
    then ShowMessage (LoadError + #13#10 + 'GetErrorName');
  @GetHideName := GetProcAddress(AssistInstance, 'GetHideName');
  if @GetHideName = nil
    then ShowMessage (LoadError + #13#10 + 'GetHideName');
  @GetIdleName := GetProcAddress(AssistInstance, 'GetIdleName');
  if @GetIdleName = nil
    then ShowMessage (LoadError + #13#10 + 'GetIdleName');
  @GetInformationName := GetProcAddress(AssistInstance, 'GetInformationName');
  if @GetInformationName = nil
    then ShowMessage (LoadError + #13#10 + 'GetInformationName');
  @GetOrientedName := GetProcAddress(AssistInstance, 'GetOrientedName');
  if @GetOrientedName = nil
    then ShowMessage (LoadError + #13#10 + 'GetOrientedName');
  @GetProcessingName := GetProcAddress(AssistInstance, 'GetProcessingName');
  if @GetProcessingName = nil
    then ShowMessage (LoadError + #13#10 + 'GetProcessingName');
  @GetRestName := GetProcAddress(AssistInstance, 'GetRestName');
  if @GetRestName = nil
    then ShowMessage (LoadError + #13#10 + 'GetRestName');
  @GetReturnName := GetProcAddress(AssistInstance, 'GetReturnName');
  if @GetReturnName = nil
    then ShowMessage (LoadError + #13#10 + 'GetReturnName');
  @GetShowName := GetProcAddress(AssistInstance, 'GetShowName');
  if @GetShowName = nil
    then ShowMessage (LoadError + #13#10 + 'GetShowName');
  @GetStartName := GetProcAddress(AssistInstance, 'GetStartName');
  if @GetStartName = nil
    then ShowMessage (LoadError + #13#10 + 'GetStartName');
  @GetTipsName := GetProcAddress(AssistInstance, 'GetTipsName');
  if @GetTipsName = nil
    then ShowMessage (LoadError + #13#10 + 'GetTipsName');
  @GetWarningName := GetProcAddress(AssistInstance, 'GetWarningName');
  if @GetWarningName = nil
    then ShowMessage (LoadError + #13#10 + 'GetWarningName');
end;

function tAssistDLL.InstanceLoaded : boolean;
begin
{$IFNDEF WIN32}
  Result := AssistInstance>HINSTANCE_ERROR;
{$ELSE}
  Result := AssistInstance <> 0;
{$ENDIF}
end;

procedure tAssistDLL.LoadDLL;
var
  Buf : array[0..255] of Char;
begin
  if not InstanceLoaded
  then begin
    StrPCopy (Buf, FLibraryName);
    FAssistInstance := LoadLibrary (Buf);
    if not InstanceLoaded
    then
      DisplayInstanceError (AssistInstance)
    else begin
      LoadFunctions;
    end;
  end;
end;

end.
