unit sysinfo;

interface

uses
   SysUtils, WinTypes, WinProcs, Classes;

type
   TSysInfo = class(TComponent)
   private
      FCompany : string;
      FUser : string;
      FCPU : string;
      FCoProcessor : string;
      FDosVersion : string;
      FWinVersion : string;
      FWinMode : string;
      procedure SetCompany(Value : string);
      procedure SetUser(Value : string);
      procedure SetCPU(Value : string);
      procedure SetCoProcessor(Value : string);
      procedure SetDosVersion(Value : string);
      procedure SetWinVersion(Value : string);
      procedure SetWinMode(Value : string);
   protected
   public
      constructor Create(AOwner:TComponent);override;
      destructor Destroy;override;
   published
      Property Company : string read FCompany write SetCompany;
      Property User : string read FUser write SetUser;
      Property CPU : string read FCPU write SetCPU;
      Property CoProcessor : string read FCoProcessor write SetCoProcessor;
      Property DosVersion : string read FDosVersion write SetDosVersion;
      Property WinVersion : string read FWinVersion write SetWinVersion;
      Property WinMode : string read FWinMode write SetWinMode;
      Property Name;
      Property Tag;
end;

procedure Register;

implementation

function DelSpaces(DelString : string): string;
begin
   while DelString[length(DelString)] = ' ' do
      DelString := copy(DelString, 1, (length(DelString)-1));
   DelSpaces := DelString;
end;

procedure Register;
begin
   RegisterComponents('Samples',[TSysInfo]);
end;

constructor TSysInfo.Create(AOwner:TComponent);
var
   DosVer, WinVer, WinFlags : longint;
   hInstUser : word;
   Buffer : array[0..30] of char;
begin
   inherited Create(AOwner);
   hInstUser := LoadLibrary('USER');
   FreeLibrary(hInstUser);
   LoadString(hInstUser, 514, Buffer, 30);
   FUser := DelSpaces(StrPas(Buffer));
   LoadString(hInstUser, 515, Buffer, 30);
   FCompany := DelSpaces(StrPas(Buffer));
   WinVer := LoWord(GetVersion);
   DosVer := HiWord(GetVersion);
   FWinVersion := IntToStr(LO(WinVer)) + '.' + IntToStr(HI(WinVer));
   FDosVersion := IntToStr(HI(DosVer)) + '.' + IntToStr(LO(DosVer));
   WinFlags := GetWinFlags;
   if WinFlags and WF_ENHANCED > 0 then
      FWinMode := '386 Enhanced'
   else
      if WinFlags and WF_PMODE > 0 then
         FWinMode := 'Standard Mode'
      else
         FWinMode := 'Real Mode';
   if WinFlags and WF_80x87 > 0 then
      FCoProcessor := 'Present'
   else
      FCoProcessor := 'Absent';
   if WinFlags and WF_CPU486 > 0 Then
      FCPU := '486 or Pentium'
   else
      if WinFlags and WF_CPU386 > 0 Then
         FCPU := '386'
      else
         if WinFlags and WF_CPU286 > 0 Then
            FCPU := '286';
end;

destructor TSysInfo.Destroy;
begin
   inherited Destroy;
end;

procedure TSysInfo.SetCompany(Value : string);
begin
   FCompany := FCompany;
end;

procedure TSysInfo.SetUser(Value : string);
begin
   FUser := FUser;
end;

procedure TSysInfo.SetCPU(Value : string);
begin
   FCPU := FCPU;
end;

procedure TSysInfo.SetCoProcessor(Value : string);
begin
   FCoProcessor := FCoProcessor;
end;

procedure TSysInfo.SetDosVersion(Value : string);
begin
   FDosVersion := FDosVersion;
end;

procedure TSysInfo.SetWinVersion(Value : string);
begin
   FWinVersion := FWinVersion;
end;

procedure TSysInfo.SetWinMode(Value : string);
begin
   FWinMode := FWinMode;
end;

end.
