unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Barcode, StdCtrls, ExtCtrls, Buttons, Printers;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    ChooseBarType: TRadioGroup;
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    Image1: TImage;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Button1: TButton;
    PrintDialog1: TPrintDialog;
    Button2: TButton;
    BarCode1: TBarCode;
    procedure BitBtn3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  PrintDialog1.Execute;
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
  dpi : Word;
  st  : String;
begin
  DPI:=GetDeviceCaps(Printer.Handle,LOGPIXELSX);
  Str(DPI,st);
  Edit2.text:=st;
  Edit2.Refresh;
end;

procedure TForm1.Button2Click(Sender: TObject);
Var
  dpi : Word;
  st  : String;
begin
  DPI:=Screen.PixelsPerInch;
  Str(DPI,st);
  Edit2.text:=st;
  Edit2.Refresh;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Button2Click(Self);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
Var
  tmp,idx : Integer;
  pic     : TBitmap;
  st      : String;
  error   : Boolean;
begin
  Image1.Picture.Bitmap.Canvas.Pen.Color:=clWhite;
  Image1.Picture.Bitmap.Canvas.Pen.Width :=1;
  Image1.Picture.Bitmap.Canvas.Rectangle(0,0,Image1.Width,Image1.Height);
  With barcode1 Do
  Begin
    barcode:=Edit1.Text;
    Val(Edit2.Text,tmp,idx);
    DPI:=tmp;
    Case ChooseBarType.ItemIndex Of
      0 : Bartype:=EAN_13;
      1 : Bartype:=CODE_39;
      2 : Bartype:=XCODE_39;
      {3 : Bartype:=INTERLEAVE_2_of_5;}
    End;
  End;
  error:=False;
  Try
    barcode1.TestBarcode;
  except
    On EWrongNumber Do begin st:='Wrong number of digits'; error:=True; end;
    On EOnlyNumeric DO begin st:='Only numbers allowed!'; error:=True; end;
    On ECheckDigitFail Do begin st:='Check digit NOT correct'; error:=True; end;
    On ECharacterInValid Do Begin st:='Illegal character';error:=True; end;
  End;
  if error Then MessageDlg(st, mtError, [mbOk], 0)
  Else Image1.Picture.Bitmap:=barcode1.getBarcode;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Printer.BeginDoc;
  Printer.Canvas.Draw(1,1,Image1.Picture.Bitmap);
  Printer.EndDoc;
end;

end.
