{

  =========
  Ball Jump
  =========
  This is a quick example of how to make an
  object 'jump' or 'bounce'.

  JumpDist: The height the ball will jump. For
  a pixel distance, use this formula: Keep
  increasing the number of pixels it will jump
  by the JumpDist minus 1, until JumpDist is 0.
  For example, if Jumpdist is 6 then,
  6 + 5 + 4 + 3 + 2 + 1 = 21. Therefore, the
  ball will go up 21 pixels.

}

unit Bj1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Ball: TShape;
    Shape1: TShape;
    Button1: TButton;
    Button2: TButton;
    Timer1: TTimer;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  CurrentVal: Integer;

const
  JumpDist: Integer = 21;

implementation

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
if not Timer1.enabled then
begin
CurrentVal := 0 - JumpDist;
timer1.enabled := true;
end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
if CurrentVal = JumpDist then
Timer1.enabled := false;
Ball.top := Ball.top + CurrentVal;
inc(CurrentVal);
end;

end.
