{

  ===========
  Ball Bounce
  ===========
  Here, this file shows an example of how to
  make an object bounce on the screen at any
  angle, similar to a screen saver.

  MaxSpeed: Determines the maximum speed of
  the ball in pixels.

}

unit Bb1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Timer1: TTimer;
    Ball: TShape;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  XSpeed, YSpeed: Integer;

const
  MaxSpeed: Integer = 50;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
randomize;
ball.left := random(width) - ball.width;
ball.top := random(height) - ball.height;
XSpeed := (MaxSpeed div 2) - random(maxspeed);
YSpeed := (MaxSpeed div 2) - random(maxspeed);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
ball.top := ball.top + YSpeed;
ball.left := ball.left + XSpeed;
if Ball.top <= 0 then
YSpeed := 0 - YSpeed;
if Ball.left <= 0 then
XSpeed := 0 - XSpeed;
if Ball.top >= height - ball.height then
YSpeed := 0 - YSpeed;
if Ball.left >= width - ball.width then
XSpeed := 0 - XSpeed;
end;

end.
