unit Backdrop;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
   TDirection = (bdUp, bdDown, bdLeft, bdRight, bdHorzIn, bdHorzOut, bdVertIn, bdVertOut);
   TBackClrs = (clRed, clLime, clYellow, clBlue, clFuchsia, clAqua, clWhite);
   TOneWayType = (Up, Down, DLeft, DRight);
   TTwoWayType = (DIn, DOut);
   TTwoWayDir = (Horz, Vert);

type
  TBackDrop = class(TGraphicControl)
   constructor Create(AComponent: TComponent); override;
   procedure Loaded; override;
  private
    { Private declarations }
   BgnClr: TBackClrs;
   FDir: TDirection;
   FClr: TBackClrs;
   procedure HorzOneWay(Clr1, Clr2: TColor);
   procedure HorzTwoWay(Clr1, Clr2: TColor);
   procedure VertOneWay(Clr1, Clr2: TColor);
   procedure VertTwoWay(Clr1, Clr2: TColor);
   {***}
   procedure SetDir(Dir: TDirection);
   procedure SetColor(Clr: TBackClrs);
   {***}
   procedure FillOneWay(WType: TOneWayType; Clr: TColor);
   procedure FillTwoWay(WType: TTwoWayType; WDir: TTwoWayDir; Clr: TColor);
  protected
    { Protected declarations }
   procedure Paint; override;
  public
    { Public declarations }
  published
   { Published declarations }
   property Direction: TDirection read FDir write SetDir default bdUp;
   property Color: TBackClrs read FClr write SetColor default clBlue;
  end;

procedure Register;

implementation

constructor TBackDrop.Create(AComponent: TComponent);
begin
   FDir := bdUp;
   FClr := clBlue;
   Align := alClient;
   BgnClr := clBlue;
   inherited Create(AComponent);
end;

procedure TBackDrop.Loaded;
begin
   inherited Loaded;
end;

procedure TBackDrop.SetDir(Dir: TDirection);
begin
   FDir := Dir;
   Repaint;
end;

procedure TBackDrop.SetColor(Clr: TBackClrs);
begin
   FClr := Clr;
   BgnClr := Clr;
   Repaint;
end;

procedure TBackDrop.HorzOneWay(Clr1, Clr2: TColor);
var
  RGBFrom   : array[0..2] of Byte;    { from RGB values                     }
  RGBDiff   : array[0..2] of integer; { difference of from/to RGB values    }
  ColorBand : TRect;                  { color band rectangular coordinates  }
  I         : Integer;                { color band index                    }
  R         : Byte;                   { a color band's R value              }
  G         : Byte;                   { a color band's G value              }
  B         : Byte;                   { a color band's B value              }
begin
   { extract from RGB values}
   RGBFrom[0] := GetRValue (ColorToRGB (Clr1));
   RGBFrom[1] := GetGValue (ColorToRGB (Clr1));
   RGBFrom[2] := GetBValue (ColorToRGB (Clr1));
   { calculate difference of from and to RGB values}
   RGBDiff[0] := GetRValue (ColorToRGB (Clr2)) - RGBFrom[0];
   RGBDiff[1] := GetGValue (ColorToRGB (Clr2)) - RGBFrom[1];
   RGBDiff[2] := GetBValue (ColorToRGB (Clr2)) - RGBFrom[2];
   { set pen sytle and mode}
   Canvas.Pen.Style := psSolid;
   Canvas.Pen.Mode := pmCopy;
   { set color band's left and right coordinates}
   ColorBand.Left := 0;
   ColorBand.Right := Width;
   for I := 0 to $ff do
   begin
       { calculate color band's top and bottom coordinates}
       ColorBand.Top    := MulDiv (I    , Height, $100);
       ColorBand.Bottom := MulDiv (I + 1, Height, $100);
       { calculate color band color}
       R := RGBFrom[0] + MulDiv (I, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (I, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (I, RGBDiff[2], $ff);
       { select brush and paint color band}
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
   end;
end;

procedure TBackDrop.VertOneWay(Clr1, Clr2: TColor);
var
  RGBFrom   : array[0..2] of Byte;    { from RGB values                     }
  RGBDiff   : array[0..2] of integer; { difference of from/to RGB values    }
  ColorBand : TRect;                  { color band rectangular coordinates  }
  I         : Integer;                { color band index                    }
  R         : Byte;                   { a color band's R value              }
  G         : Byte;                   { a color band's G value              }
  B         : Byte;                   { a color band's B value              }
begin
   { extract from RGB values}
   RGBFrom[0] := GetRValue (ColorToRGB (Clr1));
   RGBFrom[1] := GetGValue (ColorToRGB (Clr1));
   RGBFrom[2] := GetBValue (ColorToRGB (Clr1));
   { calculate difference of from and to RGB values}
   RGBDiff[0] := GetRValue (ColorToRGB (Clr2)) - RGBFrom[0];
   RGBDiff[1] := GetGValue (ColorToRGB (Clr2)) - RGBFrom[1];
   RGBDiff[2] := GetBValue (ColorToRGB (Clr2)) - RGBFrom[2];
   { set pen sytle and mode}
   Canvas.Pen.Style := psSolid;
   Canvas.Pen.Mode := pmCopy;
   { set color band's left and right coordinates}
   ColorBand.Top := 0;
   ColorBand.Bottom := Height;
   for I := 0 to $ff do
   begin
       { calculate color band's top and bottom coordinates}
       ColorBand.Left    := MulDiv (I    , Width, $100);
       ColorBand.Right := MulDiv (I + 1, Width, $100);
       { calculate color band color}
       R := RGBFrom[0] + MulDiv (I, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (I, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (I, RGBDiff[2], $ff);
       { select brush and paint color band}
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
   end;
end;

procedure TBackDrop.HorzTwoWay(Clr1, Clr2: TColor);
var
  RGBFrom   : array[0..2] of Byte;    { from RGB values                     }
  RGBDiff   : array[0..2] of integer; { difference of from/to RGB values    }
  ColorBand : TRect;                  { color band rectangular coordinates  }
  j, I      : Integer;                { color band index                    }
  R         : Byte;                   { a color band's R value              }
  G         : Byte;                   { a color band's G value              }
  B         : Byte;                   { a color band's B value              }
begin
   { extract from RGB values}
   RGBFrom[0] := GetRValue (ColorToRGB (Clr1));
   RGBFrom[1] := GetGValue (ColorToRGB (Clr1));
   RGBFrom[2] := GetBValue (ColorToRGB (Clr1));
   { calculate difference of from and to RGB values}
   RGBDiff[0] := GetRValue (ColorToRGB (Clr2)) - RGBFrom[0];
   RGBDiff[1] := GetGValue (ColorToRGB (Clr2)) - RGBFrom[1];
   RGBDiff[2] := GetBValue (ColorToRGB (Clr2)) - RGBFrom[2];
   { set pen sytle and mode}
   Canvas.Pen.Style := psSolid;
   Canvas.Pen.Mode := pmCopy;
   { set color band's left and right coordinates}
   ColorBand.Left := 0;
   ColorBand.Right := Width;
   for I := 0 to ($ff div 2) do
   begin
       { calculate color band's top and bottom coordinates}
       ColorBand.Top    := MulDiv (I    , Height, $100);
       ColorBand.Bottom := MulDiv (I + 1, Height, $100);
       { calculate color band color}
       R := RGBFrom[0] + MulDiv (I * 2, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (I * 2, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (I * 2, RGBDiff[2], $ff);
       { select brush and paint color band}
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
   end;
   if FDir = bdHorzIn then
       Canvas.Brush.Color := Clr2;
   ColorBand.Top := MulDiv(I + 1,Height,$100);
   ColorBand.Bottom := MulDiv(I + 2,Height,$100);
   Canvas.FillRect(ColorBand);
   j := I;
   for I := $ff downto ($ff div 2) do
   begin
       ColorBand.Top    := MulDiv (I    , Height, $100);
       ColorBand.Bottom := MulDiv (I + 1, Height, $100);
       R := RGBFrom[0] + MulDiv (j * 2, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (j * 2, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (j * 2, RGBDiff[2], $ff);
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
       Inc(j);
   end;
end;

procedure TBackDrop.VertTwoWay(Clr1, Clr2: TColor);
var
  RGBFrom   : array[0..2] of Byte;    { from RGB values                     }
  RGBDiff   : array[0..2] of integer; { difference of from/to RGB values    }
  ColorBand : TRect;                  { color band rectangular coordinates  }
  j, I      : Integer;                { color band index                    }
  R         : Byte;                   { a color band's R value              }
  G         : Byte;                   { a color band's G value              }
  B         : Byte;                   { a color band's B value              }
begin
   { extract from RGB values}
   RGBFrom[0] := GetRValue (ColorToRGB (Clr1));
   RGBFrom[1] := GetGValue (ColorToRGB (Clr1));
   RGBFrom[2] := GetBValue (ColorToRGB (Clr1));
   { calculate difference of from and to RGB values}
   RGBDiff[0] := GetRValue (ColorToRGB (Clr2)) - RGBFrom[0];
   RGBDiff[1] := GetGValue (ColorToRGB (Clr2)) - RGBFrom[1];
   RGBDiff[2] := GetBValue (ColorToRGB (Clr2)) - RGBFrom[2];
   { set pen sytle and mode}
   Canvas.Pen.Style := psSolid;
   Canvas.Pen.Mode := pmCopy;
   { set color band's left and right coordinates}
   ColorBand.Top := 0;
   ColorBand.Bottom := Height;
   for I := 0 to ($ff div 2) do
   begin
       { calculate color band's top and bottom coordinates}
       ColorBand.Left    := MulDiv (I    , Width, $100);
       ColorBand.Right := MulDiv (I + 1, Width, $100);
       { calculate color band color}
       R := RGBFrom[0] + MulDiv (I * 2, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (I * 2, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (I * 2, RGBDiff[2], $ff);
       { select brush and paint color band}
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
   end;
   if FDir = bdVertIn then
       Canvas.Brush.Color := Clr2;
   ColorBand.Left := MulDiv(I + 1,Width,$100);
   ColorBand.Right := MulDiv(I + 2,Width,$100);
   Canvas.FillRect(ColorBand);
   j := I;
   for I := $ff downto ($ff div 2) do
   begin
       ColorBand.Left    := MulDiv (I    , Width, $100);
       ColorBand.Right := MulDiv (I + 1, Width, $100);
       R := RGBFrom[0] + MulDiv (j * 2, RGBDiff[0], $ff);
       G := RGBFrom[1] + MulDiv (j * 2, RGBDiff[1], $ff);
       B := RGBFrom[2] + MulDiv (j * 2, RGBDiff[2], $ff);
       Canvas.Brush.Color := RGB (R, G, B);
       Canvas.FillRect (ColorBand);
       Inc(j);
   end;
end;

procedure TBackDrop.FillOneWay(WType: TOneWayType; Clr: TColor);
begin
   if WType = Up then HorzOneWay(Clr,clBlack);
   if WType = Down then HorzOneWay(clBlack,Clr);
   if WType = DLeft then VertOneWay(Clr,clBlack);
   if WType = DRight then VertOneWay(clBlack,Clr);
end;

procedure TBackDrop.FillTwoWay(WType: TTwoWayType; WDir: TTwoWayDir; Clr: TColor);
begin
   if WDir = Horz then
   begin
       if WType = DIn then HorzTwoWay(clBlack,Clr);
       if WType = DOut then HorzTwoWay(Clr,clBlack);
   end
   else
   begin
       if WType = DIn then VertTwoWay(clBlack,Clr);
       if WType = DOut then VertTwoWay(Clr,clBlack);
   end;
end;

procedure TBackDrop.Paint;
var
   UseClr: TColor;
begin
   if BgnClr = clRed then UseClr := $000000FF;
   if BgnClr = clLime then UseClr := $0000FF00;
   if BgnClr = clYellow then UseClr := $0000FFFF;
   if BgnClr = clBlue then UseClr := $00FF0000;
   if BgnClr = clFuchsia then UseClr := $00FF00FF;
   if BgnClr = clAqua then UseClr := $00FFFF00;
   if BgnClr = clWhite then UseClr := $00FFFFFF;
   if FDir = bdUp then
      FillOneWay(Up, UseClr);
   if FDir = bdDown then
       FillOneWay(Down, UseClr);
   if FDir = bdLeft then
       FillOneWay(DLeft, UseClr);
   if FDir = bdRight then
       FillOneWay(DRight, UseClr);
   if FDir = bdHorzOut then
       FillTwoWay(DOut, Horz, UseClr);
   if FDir = bdHorzIn then
       FillTwoWay(DIn, Horz, UseClr);
   if FDir = bdVertIn then
       FillTwoWay(DIn, Vert, UseClr);
   if FDir = bdVertOut then
       FillTwoWay(DOut, Vert, UseClr);
end;

procedure Register;
begin
  RegisterComponents('Custom', [TBackDrop]);
end;

end.
