unit XLS2TxtMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  XLSRead, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    edXLSFile: TEdit;
    edTXTFile: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    dlgOpen: TOpenDialog;
    dlgSave: TSaveDialog;
    XLSRead: TXLSRead;
    Label3: TLabel;
    edSep: TEdit;
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure XLSReadStringCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value: String; IsFormulaValue: Boolean);
    procedure XLSReadBoolCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value, IsFormulaValue: Boolean);
    procedure XLSReadDateTimeCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value: TDateTime; IsFormulaValue: Boolean);
    procedure XLSReadNumberCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value: Double; IsFormulaValue: Boolean);
  private
    Stream: TFileStream;
    Line: string;
    CurrRow: integer;
    Separator: char;

    procedure WriteLine;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.WriteLine;
var
  CRLF: string;
begin
  if Line <> '' then begin
    if Line[Length(Line)] = Separator then
      Line := Copy(Line,1,Length(Line) - 1);
    Stream.Write(Pointer(Line)^,Length(Line));
    CRLF := #13#10;
    Stream.Write(Pointer(CRLF)^,2);
  end;
  Line := '';
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  dlgOpen.Filename := edXLSFile.Text;
  if dlgOpen.Execute then
    edXLSFile.Text := dlgOpen.Filename;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  dlgSave.Filename := edTxtFile.Text;
  if dlgSave.Execute then
    edTxtFile.Text := dlgSave.Filename;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if Length(edSep.Text) < 1 then
    raise Exception.Create('Separator missing');
  Separator := edSep.Text[1];
  XLSRead.Filename := edXLSFile.Text;
  Stream := TFileStream.Create(edTxtFile.Text,fmCreate);
  try
    XLSRead.Read;
    WriteLine;
  finally
    Stream.Free;
    Stream := Nil;
  end;
end;

procedure TForm1.XLSReadStringCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value: String; IsFormulaValue: Boolean);
begin
  if Row <> CurrRow then begin
    WriteLine;
    CurrRow := Row;
  end;
  Line := Line + Value + Separator;
end;

procedure TForm1.XLSReadBoolCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value, IsFormulaValue: Boolean);
begin
  if Row <> CurrRow then begin
    WriteLine;
    CurrRow := Row;
  end;
  if Value then
    Line := Line + XLSRead.StrTRUE + Separator
  else
    Line := Line + XLSRead.StrFalse + Separator;
end;

procedure TForm1.XLSReadDateTimeCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value: TDateTime; IsFormulaValue: Boolean);
begin
  if Row <> CurrRow then begin
    WriteLine;
    CurrRow := Row;
  end;
  Line := Line + DateTimeToStr(Value) + Separator;
end;

procedure TForm1.XLSReadNumberCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value: Double; IsFormulaValue: Boolean);
begin
  if Row <> CurrRow then begin
    WriteLine;
    CurrRow := Row;
  end;
  Line := Line + FloatToStr(Value) + Separator;
end;

end.
