unit WriteMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, XLSWrite;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    XLSWrite: TXLSWrite;
    Label1: TLabel;
    edFilename: TEdit;
    Button3: TButton;
    SaveDialog: TSaveDialog;
    Grid: TStringGrid;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
begin
  Grid.ColWidths[0] := 20;
  for i := 1 to Grid.ColCount - 1 do
    Grid.Cells[i,0] := Char(Ord('A') + i - 1);
  for i := 1 to Grid.RowCount - 1 do
    Grid.Cells[0,i] := IntToStr(i);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  SaveDialog.Filename := edFilename.Text;
  if SaveDialog.Execute then
    edFilename.Text := SaveDialog.Filename;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Row,Col: integer;
  V: double;
begin
  XLSWrite.Filename := edFilename.Text;
  XLSWrite.OpenFile;
  // Scan trough the cells
  for Row := 1 to Grid.RowCount - 1 do begin
    for Col := 1 to Grid.ColCount - 1 do begin
      // If not empty...
      if Grid.Cells[Col,Row] <> '' then begin
        // Cells that begins with '=' is assumed to be formulas.
        if Grid.Cells[Col,Row][1] = '=' then
          // Write the formula, but remove the leading '='.
          XLSWrite.WriteFormula(Col - 1,Row - 1,-1,0,Copy(Grid.Cells[Col,Row],2,1024))
        else begin
          try
            // Test if the cell is a number
            V := StrToFloat(Grid.Cells[Col,Row]);
            XLSWrite.WriteNumber(Col - 1,Row - 1,-1,V)
          except
            // If not, write a string value.
            XLSWrite.WriteString(Col - 1,Row - 1,-1,Grid.Cells[Col,Row])
          end;
        end;
      end;
    end;
  end;
  XLSWrite.CloseFile;
end;

end.
