unit ReadMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  XLSRead, Grids, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    edFilename: TEdit;
    Grid: TStringGrid;
    Button3: TButton;
    OpenDialog: TOpenDialog;
    XLSRead: TXLSRead;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure XLSReadBoolCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value, IsFormulaValue: Boolean);
    procedure XLSReadFormulaCell(Sender: TObject; Col, Row: Integer;
      Formula: String);
    procedure XLSReadNumberCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value: Double; IsFormulaValue: Boolean);
    procedure XLSReadStringCell(Sender: TObject; Col, Row,
      FormatIndex: Integer; Value: String; IsFormulaValue: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
begin
  Grid.ColWidths[0] := 20;
  for i := 1 to Grid.ColCount - 1 do
    Grid.Cells[i,0] := Char(Ord('A') + i - 1);
  for i := 1 to Grid.RowCount - 1 do
    Grid.Cells[0,i] := IntToStr(i);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  XLSRead.Filename := edFilename.Text;
  XLSRead.Read;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OpenDialog.Filename := edFilename.Text;
  if OpenDialog.Execute then
    edFilename.Text := OpenDialog.Filename;
end;

procedure TForm1.XLSReadBoolCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value, IsFormulaValue: Boolean);
begin
  if not IsFormulaValue then begin
    if Value then
      Grid.Cells[Col + 1,Row + 1] := 'True'
    else
      Grid.Cells[Col + 1,Row + 1] := 'False';
  end;
end;

procedure TForm1.XLSReadFormulaCell(Sender: TObject; Col, Row: Integer;
  Formula: String);
begin
  Grid.Cells[Col + 1,Row + 1] := Formula;
end;

procedure TForm1.XLSReadNumberCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value: Double; IsFormulaValue: Boolean);
begin
  if not IsFormulaValue then
    Grid.Cells[Col + 1,Row + 1] := FloatToStr(Value);
end;

procedure TForm1.XLSReadStringCell(Sender: TObject; Col, Row,
  FormatIndex: Integer; Value: String; IsFormulaValue: Boolean);
begin
  if not IsFormulaValue then
    Grid.Cells[Col + 1,Row + 1] := Value;
end;

end.
