unit MergeMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, XLSWrite;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    edFilename: TEdit;
    Button1: TButton;
    OpenDialog: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    XLSWrite: TXLSWrite;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenDialog.Filename := edFilename.Text;
  if OpenDialog.Execute then
    edFilename.Text := OpenDialog.Filename;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Close;
end;

//   This shows how the formats are used to create
//   a border around the merged cells.
//
//      3      4      5      6      7      8
//   +------+------+------+------+------+------+
// 3 |  0   |  1   |  1   |  1   |  1   |  2   |
//   +------+------+------+------+------+------+
// 4 |  7   |      |      |      |      |  3   |
//   +------+------+------+------+------+------+
// 5 |  7   |      |Hello, World!|      |  3   |
//   +------+------+------+------+------+------+
// 6 |  7   |      |      |      |      |  3   |
//   +------+------+------+------+------+------+
// 7 |  6   |  5   |  5   |  5   |  5   |  4   |
//   +------+------+------+------+------+------+
//
procedure TForm1.Button2Click(Sender: TObject);
begin
  XLSWrite.Filename := edFilename.Text;
  XLSWrite.OpenFile;
  XLSWrite.WriteNumber(1,1,-1,125.75);
  XLSWrite.WriteNumber(1,2,-1,0.75);
  // The text of the merged cells is written in the cell
  // in the upper left corner. The color of the merged
  // cells is also taken from this cell.
  XLSWrite.WriteString(3,3,0,'Hello, World!');
  XLSWrite.WriteString(3,9,8,'Hello, Again!');

  // To create a border around the merged cells, you have
  // to write blank cells.
  XLSWrite.WriteBlank(4,3,1);
  XLSWrite.WriteBlank(5,3,1);
  XLSWrite.WriteBlank(6,3,1);
  XLSWrite.WriteBlank(7,3,1);

  XLSWrite.WriteBlank(8,3,2);

  XLSWrite.WriteBlank(8,4,3);
  XLSWrite.WriteBlank(8,5,3);
  XLSWrite.WriteBlank(8,6,3);

  XLSWrite.WriteBlank(8,7,4);

  XLSWrite.WriteBlank(7,7,5);
  XLSWrite.WriteBlank(6,7,5);
  XLSWrite.WriteBlank(5,7,5);
  XLSWrite.WriteBlank(4,7,5);

  XLSWrite.WriteBlank(3,7,6);

  XLSWrite.WriteBlank(3,6,7);
  XLSWrite.WriteBlank(3,5,7);
  XLSWrite.WriteBlank(3,4,7);

  // Merged cells with border.
  XLSWrite.MergeCells(3,3,8,7);
  // Merged cells without border.
  XLSWrite.MergeCells(3,9,8,12);
  XLSWrite.CloseFile;
end;

end.
