unit FormatMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, XLSWrite;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    edFilename: TEdit;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    XLSWrite1: TXLSWrite;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  OpenDialog1.Filename := edFilename.Text;
  if OpenDialog1.Execute then
    edFilename.Text := OpenDialog1.Filename;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  // Format properties is set with the Object Inspector, examine the Format
  // property in XLSWrite1.
  // NOTE: Formats can not be changed after OpenFile is called.
  with XLSWrite1 do begin
    Filename := edFilename.Text;
    OpenFile;
    WriteBlank(2,2,Formats.IndexByName('fmtLeftTop'));
    WriteBlank(3,2,Formats.IndexByName('fmtTop'));
    WriteBlank(4,2,Formats.IndexByName('fmtRightTop'));
    WriteBlank(4,3,Formats.IndexByName('fmtRight'));
    WriteBlank(4,4,Formats.IndexByName('fmtRightBottom'));
    WriteBlank(3,4,Formats.IndexByName('fmtBottom'));
    WriteBlank(2,4,Formats.IndexByName('fmtLeftBottom'));
    WriteBlank(2,3,Formats.IndexByName('fmtLeft'));
    WriteString(3,3,Formats.IndexByName('fmtCenter'),'Hello, world');
    CloseFile;
  end;
end;

end.
