program ConsoleDemo;
{$APPTYPE CONSOLE}
uses SysUtils, XLSRead;

type TXLSFileReader = class(TObject)
private
     XLS: TXLSRead;
     S: string;

     procedure XLSOnString(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: string; IsFormulaValue: boolean);
     procedure XLSOnNumber(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: double; IsFormulaValue: boolean);
     procedure XLSOnDateTime(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: TDateTime; IsFormulaValue: boolean);
     procedure XLSOnBool(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: boolean; IsFormulaValue: boolean);
public
     constructor Create;
     destructor Destroy;
     end;

var
  XLSFile: TXLSFileReader;

constructor TXLSFileReader.Create;
begin
  XLS := TXLSRead.Create(Nil);
  XLS.OnStringCell := XLSOnString;
  XLS.OnNumberCell := XLSOnNumber;
  XLS.OnDateTimeCell := XLSOnDateTime;
  XLS.OnBoolCell := XLSOnBool;
  Write('Filename: ');
  ReadLn(S);
  XLS.Filename := S;
  try
    if S <> '' then
      XLS.Read;
  except
    WriteLn('Error reading "' + S + '"');
  end;
  Write('Press Enter to continue');
  ReadLn(S);
end;

procedure TXLSFileReader.XLSOnString(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: string; IsFormulaValue: boolean);
begin
  WriteLn('Cell [' + IntToStr(Col + 1) + ',' + IntToStr(Row + 1) + '] : ' + Value);
end;

procedure TXLSFileReader.XLSOnNumber(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: double; IsFormulaValue: boolean);
begin
  WriteLn('Cell [' + IntToStr(Col + 1) + ',' + IntToStr(Row + 1) + '] : ' + FloatToStr(Value));
end;

procedure TXLSFileReader.XLSOnDateTime(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: TDateTime; IsFormulaValue: boolean);
begin
  WriteLn('Cell [' + IntToStr(Col + 1) + ',' + IntToStr(Row + 1) + '] : ' + DateTimeToStr(Value));
end;

procedure TXLSFileReader.XLSOnBool(Sender: TObject; Col,Row: integer; FormatIndex: integer; Value: boolean; IsFormulaValue: boolean);
begin
  if Value then
    WriteLn('Cell [' + IntToStr(Col + 1) + ',' + IntToStr(Row + 1) + '] : TRUE')
  else
    WriteLn('Cell [' + IntToStr(Col + 1) + ',' + IntToStr(Row + 1) + '] : FALSE');
end;

destructor TXLSFileReader.Destroy;
begin
  XLS.Free;
end;

begin
  XLSFile := TXLSFileReader.Create;
end.
