{-------------------------------------------------------------------}
{ BORBTNS - BWCC Style CheckBoxes & Radio Buttons for Delphi v 1.01 }
{-------------------------------------------------------------------}
{ v. 1.00 April, 8 1995                                             }
{ v. 1.01  July, 6 1995  Controls refreshed when caption changes    }
{-------------------------------------------------------------------}
{ Copyright Enrico Lodolo                                           }
{ via F.Bolognese 27/3 - 440129 Bologna - Italy                     }
{ CIS 100275,1255 - Internet ldlc18k1@bo.nettuno.it                 }
{-------------------------------------------------------------------}
{-------------------------------------------------------------------}
{ BORHEBROWBTNS - BWCC Hebrew Style CheckBoxes & Radio Buttons for  }
{ Delphi v 1.01                                                     }
{-------------------------------------------------------------------}
{ v. 1.00 January, 4 1995                                           }
{ v. 1.01 January, 4 1995  Controls refreshed when caption changes  }
{-------------------------------------------------------------------}
{ Copyright Alex Zanis (Averjin Netware ltd.)                       }
{ Noah-Mozes st. 13 Tel-Aviv Israel.                                }
{ Internet alex_zanis@averjin.com  phone 972-50-406-880             }
{-------------------------------------------------------------------}

{--------------------------------------------------------------------
 31.03.1997 published property Color;
            published property ParentColor, standard true
            added property Alignment
            added property AllowGrayed
            changed GetCaption.  string[0] doesn't work in Win32
--------------------------------------------------------------------}


unit Myhebchk;

interface

uses
  SysUtils, WinProcs, WinTypes, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

type
  THebBorCheck = class(TCustomControl)
  private
    FAlignment: TLeftRight;
    FAllowGrayed: Boolean;
    FDown: Boolean;
    FState: TCheckBoxState;
    FFocused: Boolean;
    FCheckColor: TColor;
    procedure SetAlignment(Value: TLeftRight);
  protected
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;X, Y: Integer); override;
    procedure KeyDown(var Key:Word;Shift:TShiftSTate); override;
    procedure KeyUp(var Key:Word;Shift:TShiftSTate); override;
    procedure SetDown(Value:Boolean);
    procedure SetState(Value:TCheckBoxState);
    procedure SetChecked(Value:Boolean);
    function  GetChecked:Boolean;
    procedure SetCheckColor(Value:TColor);
    function  GetCaption: TCaption;
    procedure SetCaption(const Value:TCaption);
    procedure DoEnter; override;
    procedure DoExit; override;
  public
  published
    property Alignment: TLeftRight read FAlignment write SetAlignment;
    property AllowGrayed: Boolean read FAllowGrayed write FAllowGrayed;
    property Caption:TCaption read GetCaption write SetCaption;
    property CheckColor:TColor read FCheckColor write SetCheckColor default clBlack;
    property Checked:Boolean read GetChecked write SetChecked default False;
    property Color;
    property Down:Boolean read FDown write SetDown default False;
    property DragCursor;
    property DragMode;
    property Font;
    property ParentColor;
    property ParentFont;
    property PopupMenu;
    property ShowHint;
    property State:TCheckBoxState read FState write SetState default cbUnchecked;
    property TabOrder;
    property TabStop;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

type
  THebBorRadio = class(TCustomControl)
  private
    FAlignment: TLeftRight;
    FDown: Boolean;
    FChecked: Boolean;
    FFocused: Boolean;
    FCheckColor: TColor;
    FGroupIndex: Byte;
    procedure TurnSiblingsOff;
    procedure SetAlignment(Value: TLeftRight);
  protected
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;X, Y: Integer); override;
    procedure KeyDown(var Key:Word;Shift:TShiftSTate); override;
    procedure KeyUp(var Key:Word;Shift:TShiftSTate); override;
    function  GetCaption: TCaption;
    procedure SetCaption(const Value:TCaption);
    procedure SetDown(Value:Boolean);
    procedure SetChecked(Value:Boolean);
    procedure SetCheckColor(Value:TColor);
    procedure DoEnter; override;
    procedure DoExit; override;
  public
  published
    property Alignment: TLeftRight read FAlignment write SetAlignment;
    property Caption:TCaption read GetCaption write SetCaption;
    property CheckColor:TColor read FCheckColor write SetCheckColor default clBlack;
    property Checked:Boolean read FChecked write SetChecked default False;
    property Color;
    property Down:Boolean read FDown write SetDown default False;
    property DragCursor;
    property DragMode;
    property Font;
    property GroupIndex:Byte read FGroupIndex write FGroupIndex default 0;
    property ParentColor;
    property ParentFont;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{-------------------------------------------------------------------}
{                          Borland Style CheckBox                   }
{-------------------------------------------------------------------}

constructor THebBorCheck.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Height := 20;
  Width := 98;
  FAlignment := taRightJustify;
  ParentColor := True;
  TabStop := True;
end;

const
  BW=12;
  Buty_Shift = 4;

procedure THebBorCheck.SetAlignment(Value: TLeftRight);
begin
  if Value <> FAlignment then begin
    FAlignment := Value;
    Invalidate;
  end;
end;

procedure THebBorCheck.Paint;
var
  BL,BT,BR,BB:Integer;
  TX,TY,TW,TH:Integer;
  Rect:TRect;
begin
  Canvas.Font:=Font;

  with Canvas do begin
    BT:=(Height div 2)-(BW div 2);
    BB:=BT+BW;
    if FAlignment = taLeftJustify then begin
      BL := Buty_Shift;
      BR := Buty_Shift + BW;
    end else begin
      BL:= Width - BW - Buty_Shift;
      BR:= Width - Buty_Shift;
    end;
    Brush.Color := clBtnFace;
    if FDown then begin
      Pen.Color:=clBlack;
      Pen.Width:=2;
      Rectangle(BL+1,BT+1,BR+1,BB+1);
      Pen.Width:=1;
    end else begin
      Pen.Color:=clBtnFace;
      Rectangle(BL,BT,BR,BB);
      Pen.Color:=clBtnHighLight;
      MoveTo(BL,BB);
      LineTo(BL,BT);
      LineTo(BR,BT);
      Pen.Color:=clBtnShadow;
      LineTo(BR,BB);
      LineTo(BL,BB);
    end;

    case State of
      cbChecked:   begin
                     Pen.Color:=FCheckColor;
                     Dec(BT);Dec(BB);
                     MoveTo(BL+2,BT+BW div 2+1);
                     LineTo(BL+2,BB-1);
                     MoveTo(BL+3,BT+BW div 2);
                     LineTo(BL+3,BB-2);
                     MoveTo(BL+2,BB-1);
                     LineTo(BR-2,BT+3);
                     MoveTo(BL+3,BB-1);
                     LineTo(BR-1,BT+3);
                   end;
      cbGrayed:    begin
                     Brush.Color:=clBtnShadow;
                     Rectangle(BL+2,BT+2,BR-1,BB-1);
                   end;
    end;

    TY:=(Height div 2)+(Font.Height div 2)-1;
    TW:=TextWidth(Caption);
    TH:=TextHeight(Caption);
    Rect.Top := TY;
    Rect.Bottom := TY + Height;
    if FAlignment = taLeftJustify then begin
      Rect.Left := BR + Buty_Shift;
      Rect.Right := Width;
      TX:= Rect.Left;
    end else begin
      Rect.Left := 1;
      Rect.Right := BL - Buty_Shift;
      TX:= Rect.Right - TW;
    end;
    Brush.Color := Color;
    TextRect(Rect, TX, TY, Caption);

    Brush.Color:=clBtnFace;
    Rect:=Bounds(TX-1,TY,TW+3,TH+1);
    {FrameRect(Rect);}
    if FFocused then DrawFocusRect(Rect);
  end;
end;

function THebBorCheck.GetCaption: TCaption;
var
  buf    : array[0..256] of char;
begin
  GetTextBuf(buf, 256);
  result := StrPas(buf);
end;

procedure THebBorCheck.SetCaption(const Value:TCaption);
var
  Buffer: array[0..255] of Char;
begin
  if GetCaption <> Value then SetTextBuf(StrPCopy(Buffer,Value));
  Invalidate;
end;

procedure THebBorCheck.SetDown(Value:Boolean);
begin
     if FDown<>Value then
       begin
         FDown:=Value;
         Paint;
       end;
end;

procedure THebBorCheck.SetState(Value:TCheckBoxState);
begin
     if FState<>Value then
       begin
         FState:=Value;
         Paint;
         Click;
       end;
end;

function THebBorCheck.GetChecked: Boolean;
begin
     Result:=State=cbChecked;
end;

procedure THebBorCheck.SetChecked(Value:Boolean);
begin
     if Value then State := cbChecked
              else State := cbUnchecked;
end;

procedure THebBorCheck.SetCheckColor(Value:TColor);
begin
     FCheckColor:=Value;
     Paint;
end;

procedure THebBorCheck.DoEnter;
begin
     inherited DoEnter;
     FFocused:=True;
     Paint;
end;

procedure THebBorCheck.DoExit;
begin
     inherited DoExit;
     FFocused:=False;
     Paint;
end;

procedure THebBorCheck.MouseDown(Button: TMouseButton; Shift: TShiftState;  X, Y: Integer);
begin
     SetFocus;
     FFocused:=True;
     inherited MouseDown(Button, Shift, X, Y);
     MouseCapture:=True;
     {Down:=True;}
end;

procedure THebBorCheck.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     MouseCapture:=False;
     Down:=False;
     if (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height) then begin
       if FAllowGrayed then begin
         case State of
           cbChecked:   State := cbGrayed;
           cbGrayed:    State := cbUnchecked;
           cbUnchecked: State := cbChecked
         end;
       end else begin
         Checked:=not Checked;
       end;
     end;
     inherited MouseUp(Button, Shift, X, Y);
end;

procedure THebBorCheck.MouseMove(Shift: TShiftState;X, Y: Integer);
begin
     if MouseCapture then
       Down:=(X>=0) and (X<=Width) and (Y>=0) and (Y<=Height);
     inherited MouseMove(Shift,X,Y);
end;

procedure THebBorCheck.KeyDown(var Key:Word;Shift:TShiftSTate);
begin
     {if Key=vk_Space then Down:=True;}
     inherited KeyDown(Key,Shift);
end;

procedure THebBorCheck.KeyUp(var Key:Word;Shift:TShiftSTate);
begin
     if Key=vk_Space then
       begin
         Down:=False;
         Checked:=not Checked;
       end;
end;

{-------------------------------------------------------------------}
{                           Borland Radio Button                    }
{-------------------------------------------------------------------}

constructor THebBorRadio.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 98;
  Height := 20;
  FAlignment := taRightJustify;
  ParentColor := True;
end;

procedure THebBorRadio.SetAlignment(Value: TLeftRight);
begin
  if Value <> FAlignment then begin
    FAlignment := Value;
    Invalidate;
  end;
end;

procedure THebBorRadio.Paint;
var
  BL,BT,BR,BB,BM:Integer;
  TX,TY,TW,TH:Integer;
  CX,CY:Integer;
  Rect:TRect;
begin
  Canvas.Font:=Font;
  with Canvas do begin
    BM:= BW div 2;
    BT:= (Height div 2)-BM;
    BB:= BT+BW;
    if FAlignment = taLeftJustify then begin
      BL := Buty_Shift;
      BR := Buty_Shift + BW;
    end else begin
      BL:= Width - BW - Buty_Shift;
      BR:= Width - Buty_Shift;
    end;

    Pen.Color := clBlack;
    Brush.Color := clBtnFace;
    Polygon([Point(BL+BM,BT), Point(BL,BT+BM), Point(BL+BM,BB), Point(BR,BT+BM)]);
    if Down then begin
      MoveTo(BL+BM,BT+1);
      LineTo(BL+1,BT+BM);
      LineTo(BL+BM,BB-1);
      LineTo(BR-1,BT+BM);
      LineTo(BL+BM,BT+1);
    end else begin
      if Checked then Pen.Color:=clBtnShadow
                 else Pen.Color:=clBtnHighLight;
      MoveTo(BL+BM,BT);
      LineTo(BL,BT+BM);
      LineTo(BL+BM,BB);
      if Checked then Pen.Color:=clBtnHighLight
                 else Pen.Color:=clBtnShadow;
      LineTo(BR,BT+BM);
      LineTo(BL+BM,BT);
    end;

    if Checked then begin
      Pen.Color:=CheckColor;
      CX:=BL+BM;CY:=BT+BM;
      MoveTo(CX-1,CY-1);
      LineTo(CX+2,CY-1);
      MoveTo(CX-2,CY);
      LineTo(CX+3,CY);
      MoveTo(CX-1,CY+1);
      LineTo(CX+2,CY+1);
      MoveTo(CX,CY-2);
      LineTo(CX,CY+3);
    end;

    TY:=(Height div 2)+(Font.Height div 2)-1;
    TW:=TextWidth(Caption);
    TH:=TextHeight(Caption);
    Rect.Top := TY;
    Rect.Bottom := TY + Height;
    Brush.Style := bsClear;
    if FAlignment = taLeftJustify then begin
      Rect.Left := BR + Buty_Shift;
      Rect.Right := Width;
      TX:= Rect.Left;
    end else begin
      Rect.Left := 1;
      Rect.Right := BL - Buty_Shift;
      TX:= Rect.Right - TW;
    end;
    TextRect(Rect, TX, TY, Caption);

    Brush.Color:=clBtnFace;
    Rect:=Bounds(TX-1,TY,TW+3,TH+1);
    {FrameRect(Rect);}
    if FFocused then DrawFocusRect(Rect);
  end;
end;

function THebBorRadio.GetCaption:TCaption;
var
  buf    : array[0..256] of char;
begin
  GetTextBuf(buf, 256);
  result := StrPas(buf);
end;

procedure THebBorRadio.SetCaption(const Value:TCaption);
var
  Buffer: array[0..255] of Char;
begin
  if GetCaption <> Value then SetTextBuf(StrPCopy(Buffer,Value));
  Invalidate;
end;

procedure THebBorRadio.SetDown(Value:Boolean);
begin
     if FDown<>Value then
       begin
         FDown:=Value;
         Paint;
       end;
end;

procedure THebBorRadio.TurnSiblingsOff;
var
  i:Integer;
  Sibling: THebBorRadio;
begin
     if Parent <> nil then
       for i:=0 to Parent.ControlCount-1 do
         if Parent.Controls[i] is THebBorRadio then
           begin
             Sibling:=THebBorRadio(Parent.Controls[i]);
             if (Sibling<>Self) and
                (Sibling.GroupIndex=GroupIndex) then
                  Sibling.SetChecked(False);
           end;
end;

procedure THebBorRadio.SetChecked(Value: Boolean);
begin
     if FChecked <> Value then
       begin
         TabStop:=Value;
         FChecked :=Value;
         FFocused := Value;
         if Value then
           begin
             TurnSiblingsOff;
             Click;
           end;
         Paint;
       end;
end;

procedure THebBorRadio.SetCheckColor(Value:TColor);
begin
     FCheckColor:=Value;
     Paint;
end;

procedure THebBorRadio.DoEnter;
begin
     inherited DoEnter;
     FFocused:=True;
     Checked:=True;
     Paint;
end;

procedure THebBorRadio.DoExit;
begin
     inherited DoExit;
     FFocused:=False;
     Paint;
end;

procedure THebBorRadio.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     SetFocus;
     FFocused:=True;
     inherited MouseDown(Button, Shift, X, Y);
     MouseCapture:=True;
     Down:=True;
end;

procedure THebBorRadio.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     MouseCapture:=False;
     Down:=False;
     if (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height)
       and not Checked then Checked:=True;
     inherited MouseUp(Button, Shift, X, Y);
end;

procedure THebBorRadio.MouseMove(Shift: TShiftState;X, Y: Integer);
begin
     if MouseCapture then
       Down:=(X>=0) and (X<=Width) and (Y>=0) and (Y<=Height);
     inherited MouseMove(Shift,X,Y);
end;

procedure THebBorRadio.KeyDown(var Key:Word;Shift:TShiftSTate);
begin
     if Key=vk_Space then Down:=True;
     inherited KeyDown(Key,Shift);
end;

procedure THebBorRadio.KeyUp(var Key:Word;Shift:TShiftSTate);
begin
     if Key=vk_Space then
       begin
         Down:=False;
         if not Checked then Checked:=True;
       end;
end;

procedure Register;
begin
     RegisterComponents('Freeware',[THebBorCheck,THebBorRadio]);
end;

end.
