{$INCLUDE Options.Inc}
unit UrlLabel;
{
*************** Freeware Freeware Freeware ********************************
*	Name:					UrlLabel.PAS																							*
*	Description:	URL support																								*
*	Platform:			Delphi 2.0																								*
*	Files:				UrlLabel.dcu	# component (compiled)											*
*	UrlLabel.dcr	# component resource file										*
*							UrlLabel.res	# component resource file										*
*							UrlLabel.pas	- component source 													*
*							 Options.Inc		# Compiler's directives											*
*	Author:				Anatoly Podgoretsky																				*
*	Vahe 4-31, Johvi, Estonia, EE2045*
*       kvk@estpak.ee																							*
*	Main authors:	Ahto Tanner and Per-Eric Larsson													*
*	Installation:	Copy files marked with <#> in your prefered component			*
*								directory or create new one. Then install on palette			*
*								<Component|Install>. Component installed on ADD tab.			*
*								If this tab not fine for you may change it.								*
*								look comment in Register procedure												*
*	Editor:				Tabs step = 2, Courier New																*
*	Started:			05.04.96 - Initial release																*
*	Changed:			dd.mm.yy - 																								*
*	Copyright:		Ahto Tanner, Moon Software	(UrlLabel)										*
*											http://www.estpak.ee/~ahto/													*
*											moon@kagi.com																				*
*	Copyright:		Per-Eric Larsson (MailToLabel)														*
*											per-eric.larsson@boras.mail.telia.com								*
*	Copyright:		() NPS, 1997																							*
***************************************************************************
*	This programm fully free and may use and distribute as you want, except	*
* Copyright notice, this must stay unchanged. Of couse if you modify			*
* programm you may add yours Portion Copyright statement below us. Also		*
* state our names in a credits section of your program and use it as you	*
* like.																																		*
***************************************************************************
}
interface

uses
  Windows,
  Classes,
  Forms,
  StdCtrls,
  ShellAPI,
  Graphics,
  Controls;
const
  crHand = 5;
type
  TProtocol = (ptNONE,ptMAIL,ptWWW,ptFTP,ptFILE);
  TUrlLabel = class(TLabel)
    private
       FUrl          : string;
       FProtocol     : TProtocol;
       FActiveColor  : TColor;
       FPassiveColor : TColor;
    public
    	constructor Create(AOwner:TComponent);	override;
    	destructor  Destroy;										override;
        procedure   Click; 											override;
        procedure   MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);override;
    	procedure   MouseUp(Button:TMouseButton; Shift : TShiftState; X,Y:Integer); override;
    published
    	property Protocol: TProtocol read FProtocol write FProtocol default ptMAIL;
    	property Url : string read FUrl	write FUrl;
        property ActiveColor : TColor read FActiveColor	write FActiveColor default clPurple;
    end; // TUrlLabel

procedure Register;

implementation

CONST
  Protocol_Strings : ARRAY [TProtocol] OF STRING = ('', 'mailto:', 'http://', 'ftp://', 'file:');

{$R UrlLabel.res}

{************************************
 * Create component, setup defaults	*
 ************************************}
constructor TUrlLabel.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  Screen.Cursors[crHand] := LoadCursor(HInstance,PChar('HAND'));
  Cursor:= crHand;
  FActiveColor:= clPurple;
  FProtocol:= ptMAIL;
  FUrl	:= 'kvk@estpak.ee';
  Caption:= FUrl;
  with Font do begin
  	Size	:= 12;
    Color := clBlue;
    Style := [fsUnderline];
  end;
end;	// Create
{**********************
 * Destroy component	*
 **********************}
destructor TUrlLabel.Destroy;
begin
  inherited Destroy;
end;	// Destroy
{********************
 * OnClick handler	*
 ********************}
procedure TUrlLabel.Click;
var
  Tmp : string;
begin
  if Enabled then begin
  inherited Click;
  Tmp := Protocol_Strings[Protocol];
  IF Pos(tmp, Url) = 1 THEN
     tmp := '';
  ShellExecute(Application.Handle,'open',PChar(tmp + Url),nil,nil,SW_NORMAL);
  end;
end;
{********************************
 * OnMouseDown event handler		*
 * change color to ActiveColor	*
 ********************************}
procedure TUrlLabel.MouseDown(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
begin
  if Enabled and (Button = mbLeft) then
  begin
     FPassiveColor := Font.Color;// save current color
     Font.Color	:= FActiveColor; // change to Active
     inherited;
  end;
end;
{**********************************
 * OnMouseUp event handler        *
 * restored color to PassiveColor *
 **********************************}
procedure TUrlLabel.MouseUp(Button:TMouseButton; Shift:TShiftState; X,Y:Integer);
begin
  if Enabled and (Button = mbLeft) then begin
  	Font.Color := FPassiveColor;	// restore color
	  inherited;
  end;
end;
{************************************************************************
 * Component registration, change section name for you favorite Add In	*
 ************************************************************************}
procedure Register;
begin
  RegisterComponents('Add',[TUrlLabel]);
end;

end.
