unit U_glob;

interface

USES SysUtils;

FUNCTION Reverse(s : STRING) : STRING;

FUNCTION LPad(s : STRING; l : BYTE) : STRING;

FUNCTION RPad(s : STRING; l : BYTE) : STRING;

FUNCTION RTrim(s : STRING) : STRING;

FUNCTION LTrim(s : STRING) : STRING;

FUNCTION Trim(s : STRING) : STRING;

FUNCTION Apostroff_Doubling(s : STRING) : STRING;

FUNCTION My_Copy(src, dst : STRING) : BOOLEAN;

FUNCTION Dir_Exists(s : STRING) : BOOLEAN;

FUNCTION Make_Dir_If_Not_Exists(s : STRING) : BOOLEAN;

FUNCTION Str2Pchar_With_Alloc(s : STRING) : PChar; {Don't forget to free the memory!!!}

PROCEDURE Despose_PChar(p : Pchar);

FUNCTION My_Move(src, dst : STRING) : BOOLEAN;

FUNCTION Get_Win_Dir : STRING;

FUNCTION Colon_Down(s : STRING; VAR f : BOOLEAN) : STRING;

FUNCTION Add_Colon_Correct(s1, s2 : STRING; f: BOOLEAN) : STRING;

FUNCTION Double_Min(CONST d1, d2 : Double) : Double;

implementation

USES DIalogs, WinProcs;

FUNCTION RTrim(s : STRING) : STRING;

BEGIN
  WHILE (s[BYTE(Length(s))] = ' ') AND (s <> '') DO
    Delete(s, Length(s), 1);
  Result := s;
END;

FUNCTION LTrim(s : STRING) : STRING;

BEGIN
  WHILE (s <> '') AND (s[1] = ' ') DO
    Delete(s, 1, 1);
  Result := s;
END;

FUNCTION Trim(s : STRING) : STRING;

BEGIN
  Trim := LTrim(RTrim(s));
END;

FUNCTION LPad(s : STRING; l : BYTE) : STRING;

BEGIN
  Result := s;
  WHILE Length(Result) < l DO
    Result := ' ' + Result;
END;

FUNCTION RPad(s : STRING; l : BYTE) : STRING;

BEGIN
  Result := s;
  WHILE Length(Result) < l DO
    Result := Result + ' ';
END;

CONST
  Num_Set : Set OF CHAR = ['0'..'9', '.', 'A'..'Z', 'a'..'z'];

FUNCTION Reverse(s : STRING) : STRING;

VAR 
  i : BYTE;
  number : String;

BEGIN
  Result := '';
  number := '';
  FOR i := 1 TO Length(s) DO
    BEGIN
      IF s[Length(s) - i + 1] = ')' THEN
         s[Length(s) - i + 1] := '('
      ELSE
      IF  s[Length(s) - i + 1] = '(' THEN
         s[Length(s) - i + 1] := ')';
      IF NOT(s[Length(s) - i + 1] IN Num_Set) AND (number <> '') THEN
        BEGIN
          Result := Result + number + s[Length(s) - i + 1];
          Number := '';
        END
      ELSE
      IF (s[Length(s) - i + 1] IN Num_Set) THEN
         number := s[Length(s) - i + 1] + number
      ELSE
         Result := Result + s[Length(s) - i + 1];
    ENd;
  IF number <> '' THEN
    Result := Result + number;
END;

FUNCTION Apostroff_Doubling(s : STRING) : STRING;
VAR
  i : BYTE;

BEGIN
  i := 1;
  WHILE i <= Length(s) DO
    BEGIN
      IF s[i] = '''' THEN
         BEGIN
           Insert('''', s, i);
           Inc(i);
         END;
      {IF s[i] = , THEN
         BEGIN
           Insert(',', s, i);
           Inc(i);
         END;}
      Inc(i);
    END;
  Result := s;
END;

FUNCTION My_Copy(src, dst : STRING) : BOOLEAN;

VAR
  f1,f2 : FILE;
  buf : PChar;
  Res : Integer;

BEGIN
  Result := TRUE;
  IF NOT(FileExists(src)) THEN
    BEGIN
      Result := FALSE;
      MessageDlg(' ' + src + '. ', mtError, [mbOk], 0);
      EXIT;
    END;

  AssignFile(f1, src);
  AssignFile(f2, dst);
  ReSet(f1,1);
  ReWrite(f2,1);
  GetMem(buf, 16000);
  WHILE NOT EOF(f1) DO
    BEGIN
      BlockRead(f1, buf^, 16000, Res);
      BlockWrite(f2, buf^, Res);
    END;
  FreeMem(buf, 16000);
  CloseFile(f1);
  CloseFile(f2);
END;

FUNCTION My_Move(src, dst : STRING) : BOOLEAN;

VAR
 f : File;

BEGIN
  Result := My_Copy(src, dst);
  IF NOT Result THEN
     EXIT;
  AssignFile(f, src);
  Erase(f);
END;

FUNCTION Dir_Exists(s : STRING) : BOOLEAN;

VAR
  srch_rec : TSearchRec;

BEGIN
  Result := FindFirst(s, faDirectory, srch_rec) = 0;
END;

FUNCTION Make_Dir_If_Not_Exists(s : STRING) : BOOLEAN;

BEGIN
  IF s[Length(s)] = '\' THEN
     Delete(s, Length(s), 1);
  Result := Dir_Exists(s);
  IF NOT Result THEN
     MkDir(s);
END;

FUNCTION Str2Pchar_With_Alloc(s : STRING) : PChar;

BEGIN
  GetMem(Result, Length(s) + 1);
  StrPCopy(Result, s);
END;

PROCEDURE Despose_PChar(p : Pchar);

BEGIN
  FreeMem(p, StrLen(p));
END;

FUNCTION Get_Win_Dir : STRING;

VAR
  tmp : ARRAY [0..255] OF CHAR;

BEGIN
  GetWindowsDirectory(@tmp, 256);
  Result := StrPas(@tmp);
END;

FUNCTION Colon_Down(s : STRING; VAR f : BOOLEAN) : STRING;

BEGIN
  f:= Pos(':', s) <> 0;
  IF f THEN
    Delete(s, Pos(':', s), 1);
  Result := s;
END;

FUNCTION Add_Colon_Correct(s1, s2 : STRING; f: BOOLEAN) : STRING;

BEGIN
  IF f THEN
   Result := s1  + ' : ' + s2
  ELSE
   Result := s1  + ' ' + s2;
END;

FUNCTION Double_Min(Const d1, d2 : Double) : Double;

BEGIN
  Result := d1 * Byte(d1<=d2) + d2 * BYTE(d2<d1);
END;


end.
