unit Picts;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TPicts_Frm = class(TForm)
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    Image1: TImage;
    BitBtn3: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    procedure BitBtn3Click(Sender: TObject);
    procedure Image1Click(Sender: TObject);
  private
    { Private declarations }
    My_Canvas : TCanvas;
    Pict_list : TStrings;
    fCurrent_Image : TImage;
    PROCEDURE SetCurrent_Image(i : Timage);
  public
    { Public declarations }
    Result_Image_Index : Longint;
    PROPERTY Current_Image : TImage read fCurrent_Image write SetCurrent_Image;
    FUNCTION Init(Path : STRING; File_List : TStrings; Index : LongInt) : BOOLEAN;
  end;

var
  Picts_Frm: TPicts_Frm;

implementation

{$R *.DFM}

CONST
  Hor_Dist = 50;
  Ver_Dist = 20;

FUNCTION Int_Min(i1, i2 : Integer) : Integer;

BEGIN
  Result := i1 * BYTE(i1 < i2) + i2 * BYTE(i1>=i2);
END;

PROCEDURE TPicts_Frm.SetCurrent_Image(i : Timage);

BEGIN
  IF i = NIL THEN
    EXIT;
  fCurrent_Image := i;
  IF fCurrent_Image <> NIL THEN
    BEGIN
      Bevel1.Left := fCurrent_Image.Left - 4;
      Bevel1.Top := fCurrent_Image.Top - 4;
      IF Image1.Stretch THEN
        BEGIN
          Bevel1.Width  := fCurrent_Image.Width + 8;
          Bevel1.Height := fCurrent_Image.Height + 8;
        END
      ELSE
        BEGIN
          Bevel1.Width := Int_Min(fCurrent_Image.Picture.Width, fCurrent_Image.Width) + 8;
          Bevel1.Height := Int_Min(fCurrent_Image.Picture.Height, fCurrent_Image.Height) + 8;
        END;
    END;
END;

FUNCTION  TPicts_Frm.Init(Path : STRING; File_List : TStrings; Index : LongInt) : BOOLEAN;

VAR
  i : LongInt;
  Prev_Pict,
  Tmp_Pict : TImage;
  Tmp_Lb   : TLabel;

BEGIN
  Tmp_Pict := Image1;
  FOR i := 0 TO File_List.Count - 1 DO
     BEGIN
       IF Uppercase(ExtractFileExt(File_List.Strings[i])) <> '.BMP' THEN
          Continue;
       Tmp_Pict.OnClick := Image1.OnClick;
       try
       Tmp_Pict.Picture.LoadFromFile(Path + '\' + File_List.Strings[i]);
       EXCEPT
       Tmp_Pict.Picture.Bitmap := NIL;
       Continue;
       END;
       Tmp_Pict.Tag := i;
       IF i = Index THEN
          Current_Image := Tmp_Pict;
       Prev_Pict := Tmp_Pict;
       Tmp_Pict := TImage.Create(Self);
       Tmp_Lb   := TLabel.Create(Self);
       Tmp_Pict.Parent := Prev_Pict.Parent;
       Tmp_Pict.Left   := Prev_Pict.Left + Prev_Pict.Width + Hor_Dist;
       Tmp_Pict.Top    := Prev_Pict.Top;
       Tmp_Pict.Height := Prev_Pict.Height;
       Tmp_Pict.Width  := Image1.Width;
       Tmp_Pict.OnClick := Image1.OnClick;
       Tmp_Pict.Stretch := Image1.Stretch;
       IF (Tmp_Pict.Left + Tmp_Pict.Width + Hor_Dist) > ScrollBox1.Width THEN
          BEGIN
            Tmp_Pict.Left := Image1.Left;
            Tmp_Pict.Top  := Prev_Pict.Top + Prev_Pict.Height + Ver_Dist;
          END;
       Tmp_Pict.Visible := TRUE;
       Tmp_Lb.Parent := Label1.Parent;
       Tmp_Lb.AutoSize := Label1.AutoSize;
       Tmp_Lb.Font.Assign(Label1.Font);
       Tmp_Lb.Caption := File_List.Strings[i];
       Tmp_Lb.Left := Prev_Pict.Left + (Prev_Pict.Width DIV 2) - (Tmp_Lb.Width Div 2);
       IF Image1.Stretch THEN
          Tmp_Lb.Top  := Prev_Pict.Top + Prev_Pict.Height + 4
       ELSE
          Tmp_Lb.Top  := Prev_Pict.Top + Int_Min(Prev_Pict.Picture.Height, Prev_Pict.Height) + 4;
       Tmp_Lb.Name := 'Lb' + IntToStr(Prev_Pict.Tag);
       Tmp_Lb.Visible := TRUE;
     END;
  Tmp_Pict.Tag := i + 1;
  IF Index < 0 THEN
    Current_Image :=  Image1;
  Result := ShowModal = MrOk;
  IF Result THEN
     Result_Image_Index := fCurrent_Image.Tag;
  i := 1;
  WHILE i < ScrollBox1.ControlCount DO
    BEGIN 
      IF (ScrollBox1.Controls[i] <> Image1) AND 
         (ScrollBox1.Controls[i] <> Bevel1) AND 
         (ScrollBox1.Controls[i] <> Label1) THEN
         ScrollBox1.Controls[i].Free
      ELSE
         Inc(i);
    END;
END;

procedure TPicts_Frm.BitBtn3Click(Sender: TObject);
VAR
  i : Integer;
  im : Timage;
  lb : TLabel;

begin
  i := 1;
  Image1.Stretch := NOT Image1.Stretch;
  lb := FindComponent('Lb0') AS TLabel;
  im := Image1;
  IF lb <> NIL THEN
    BEGIN
      IF Image1.Stretch THEN
        lb.Top  := im.Top + im.Height + 4
      ELSE
        lb.Top  := im.Top + Int_Min(im.Picture.Height, im.Height) + 4;
      im.Refresh;
      lb.refresh;
    ENd;
  WHILE i < ScrollBox1.ControlCount DO
    BEGIN
      IF ScrollBox1.Controls[i] IS TImage THEN
        BEGIN
          im := TImage(ScrollBox1.Controls[i]);
          im.Stretch := Image1.Stretch;
          lb := FindComponent('Lb' + IntToStr(im.Tag)) AS TLabel;
          IF lb <> NIL THEN
            BEGIN
              IF Image1.Stretch THEN
                lb.Top  := im.Top + im.Height + 4
              ELSE
                lb.Top  := im.Top + Int_Min(im.Picture.Height, im.Height) + 4;
              im.Refresh;
              lb.refresh;
            ENd;
        END;
      Inc(i);
    END;
  IF Image1.Stretch THEN
     BitBtn3.Caption := 'Not stretch'
  ELSE                                 
     BitBtn3.Caption := 'Stretch';
  Current_Image := Current_Image;
end;

procedure TPicts_Frm.Image1Click(Sender: TObject);
begin
  Current_Image := TImage(Sender);
end;

end.
 