{ Component that shows label with 3-dimensional effect }

unit Label3D;

interface

uses Classes, StdCtrls, Graphics;

type
  TLabel3D = class(TLabel)
  private
    { Color to make 3D effect}
    FShadowColor: TColor;
    procedure SetShadowColor(Value: TColor);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property ShadowColor: TColor read FShadowColor
                                write SetShadowColor
                              default clBtnHighlight;
  end;

procedure Register;

implementation

uses SysUtils, WinTypes, WinProcs, Controls;

const
  ShadowHoriz = 1;
  ShadowVert  = 1;

constructor TLabel3D.Create(AOwner: TComponent);
var
  Rect: TRect;
begin
  inherited Create(AOwner);
  FShadowColor := clBtnHighlight;
  { Set new bounds }
  SetBounds(Left, Top, Width + ShadowHoriz,Height + ShadowVert);
end;

procedure TLabel3D.SetShadowColor(Value: TColor);
begin
  if FShadowColor <> Value then
  begin
    FShadowColor := Value;
    { Force label to repaint }
    Invalidate;
  end;
end;

procedure TLabel3D.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect, ShadowRect: TRect;
  Text: array[0..255] of Char;
  Flags: Word;
  Colr : TColor;
begin
  with Canvas do
    begin
      if not Transparent then
        begin
          { Fill the specified rectangle on canvas using solid brush }
          Brush.Color := Self.Color;
          Brush.Style := bsSolid;
          FillRect(ClientRect);
        end;
      Brush.Style := bsClear;
      Rect := ClientRect;
    end;

  { Set the flags to pass to API DrawText function }
  Flags := (DT_EXPANDTABS or DT_WORDBREAK) or Alignments[Alignment];
  if not ShowAccelChar then
    Flags := Flags or DT_NOPREFIX;

  { Retrieve the text of control and copy it into the Text buffer of PChar type }
  GetTextBuf(Text, SizeOf(Text));

  { Check whether the Text contains any characters }
  if (Flags and DT_CALCRECT <> 0) and ((Text[0] = #0) or ShowAccelChar and
     (Text[0] = '&') and (Text[1] = #0)) then
    StrCopy(Text, ' ');

  { Save label's font color and set it to ShadowColor }
  Colr := Font.Color;
  Canvas.Font := Font;
  Canvas.Font.Color := FShadowColor;

  { Draw shadowed text in new position }
  ShadowRect := Rect;
  ShadowRect.Left   := Rect.Left + ShadowHoriz;
  ShadowRect.Top    := Rect.Top + ShadowVert;
  ShadowRect.Right  := Rect.Right + ShadowHoriz;
  ShadowRect.Bottom := ShadowRect.Bottom + ShadowVert;
  DrawText(Canvas.Handle, Text, StrLen(Text), ShadowRect, Flags);

  { Set the color of label text }
  if not Enabled then
    Canvas.Font.Color := clGrayText
  else
    Canvas.Font.Color := Colr;

  { Draw the text one more time in original position }
  DrawText(Canvas.Handle, Text, StrLen(Text), Rect, Flags);
end;

procedure Register;
begin
  { I like to put it on Additional page }
  RegisterComponents('Additional',[TLabel3D]);
end;

end.
