unit Azimbrow;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, Label3D, ExtCtrls, Buttons, fav_Dir,
  U_Glob, IniFiles, Picts;

type
  TMain_Frm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label3D1: TLabel3D;
    DriveComboBox1: TDriveComboBox;
    FilterComboBox1: TFilterComboBox;
    GroupBox1: TGroupBox;
    Fav_list: TComboBox;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Panel4: TPanel;
    Image1: TImage;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    REm_Btn: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    SaveDialog1: TSaveDialog;
    procedure FileListBox1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Fav_listChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure REm_BtnClick(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    fCurrent_FileName : STRING;
    Delphi_Ini : TIniFile;
    Change_Flg : BOOLEAN;
    FUNCTION  GetCurrent_Bitmap  : TBitMap;
    PROCEDURE SetCurrent_Bitmap(bm : TBitMap);
    PROCEDURE SetCurrent_FileName(s : STRING);
  public                                    
    {Public declarations}
    PROPERTY Current_Bitmap   : TBitmap read GetCurrent_Bitmap write SetCurrent_Bitmap;
    PROPERTY Current_FileName : STRING read fCurrent_FileName write SetCurrent_FileName;
  end;

var
  Main_Frm: TMain_Frm;

implementation

uses About;

{$R *.DFM}
CONST
  Fav_Section = 'BMP_FAVORITS';

TYPE 
  TStrClass = CLASS
               Public
                 d : STRING;
                 Constructor Create(s: STRING);
              END;

Constructor TStrClass.Create(s: STRING);

BEGIN
  d := s;
END;

procedure TMain_Frm.FileListBox1Click(Sender: TObject);
begin
  IF FileListBox1.ItemIndex <> -1 THEN
    BEGIN
      IF (UpperCase(ExtractFileExt(FileListBox1.FileName)) = '.BMP') AND 
         (FileListBox1.FileName <> Current_FileName)         THEN
           Current_FileName := FileListBox1.FileName;
    END;
end;

procedure TMain_Frm.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TMain_Frm.BitBtn5Click(Sender: TObject);
begin
  Image1.Stretch := NOT Image1.Stretch;
  IF Image1.Stretch THEN
     BitBtn5.Caption := 'Not stretch'
  ELSE                                 
     BitBtn5.Caption := 'Stretch';
end;

procedure TMain_Frm.BitBtn6Click(Sender: TObject);
begin
  Current_Bitmap := NIL;
end;

procedure TMain_Frm.BitBtn3Click(Sender: TObject);
begin
  WITH Fav_Add_frm DO 
    BEGIN
     Cur_Dir_lb.Caption := 'Current dir. is : ' + DirectoryListBox1.Directory;
     IF ShowModal = mrOk THEN
       BEGIN
         Fav_list.Items.AddObject('Project : ' + Proj_Ed.Text + '; Directory : ' + Dir_Ed.Text,
                         TStrClass.Create(DirectoryListBox1.Directory));
         Fav_list.ItemIndex := Fav_list.Items.Count - 1;
         Change_Flg := TRUE;
       END;
    END;
end;

procedure TMain_Frm.FormCreate(Sender: TObject);
VAR 
  i : LongInt;
  Favorits   : TStringList;

begin
  Change_Flg := FALSE;
  Delphi_Ini := TIniFile.Create(Get_Win_Dir + '\DELPHI.INI');
  Favorits   := TStringList.Create;
  Delphi_Ini.ReadSectionValues(Fav_Section, Favorits);
  IF Favorits.Count > 0 THEN
     BEGIN
       FOR i := 0 TO Favorits.Count - 1 DO
          Fav_list.Items.AddObject(Favorits.Values[Trim(Copy(Favorits.Strings[i], 1, Pos('=',Favorits.Strings[i])-1))],
                    TStrClass.Create(Trim(Copy(Favorits.Strings[i], 1, Pos('=',Favorits.Strings[i])-1))));
     END;
  Favorits.Free;
  Current_FileName := '';
end;

procedure TMain_Frm.Fav_listChange(Sender: TObject);
begin
  REm_Btn.Enabled := Fav_list.ItemIndex >= 0;
  IF NOT REm_Btn.Enabled THEN
    BEGIN
      Fav_list.Text := '';
      Exit;
    END;
  DirectoryListBox1.Directory := TStrClass(Fav_list.Items.Objects[Fav_list.ItemIndex]).d;
  DirectoryListBox1.Update;
end;

procedure TMain_Frm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
VAR 
  i : LongInt;

begin
  IF NOT Change_Flg THEN 
    EXIT;
  Delphi_Ini.EraseSection(Fav_Section);
  FOR i := 0 TO Fav_list.Items.Count -1 DO
    Delphi_Ini.WriteString(Fav_Section, TStrClass(Fav_list.Items.Objects[i]).d,
                           Fav_list.Items.Strings[i]);
end;

procedure TMain_Frm.REm_BtnClick(Sender: TObject);
begin
  Fav_list.Items.Delete(Fav_list.ItemIndex);
  Fav_list.Text := '';
  REm_Btn.Enabled := FALSE;
  Change_Flg := TRUE;
end;

FUNCTION  TMain_Frm.GetCurrent_Bitmap  : TBitMap;

BEGIN
  IF Image1.Visible THEN
    Result := Image1.Picture.BitMap
  ELSE
    Result := NIL;
END;

PROCEDURE TMain_Frm.SetCurrent_Bitmap(bm : TBitMap);

BEGIN
  BitBtn5.Enabled := NOT (bm = NIL);
  BitBtn8.Enabled := NOT (bm = NIL);
  Image1.Visible  := BitBtn5.Enabled;
  IF Image1.Picture.BitMap <> bm THEN
     Image1.Picture.BitMap := bm;
END;

PROCEDURE TMain_Frm.SetCurrent_FileName(s : STRING);

BEGIN
  fCurrent_FileName := s;
  IF s = '' THEN
     Current_Bitmap := NIL
  ELSE
    BEGIN
      Image1.Picture.LoadFromFile(s);
      Current_Bitmap := Image1.Picture.BitMap;
    END;
END;

procedure TMain_Frm.BitBtn7Click(Sender: TObject);
begin
  IF Picts_Frm.Init(DirectoryListBox1.Directory, FileListBox1.Items, FileListBox1.ItemIndex) THEN
     BEGIN
       FileListBox1.ItemIndex := Picts_Frm.Result_Image_Index;
       IF DirectoryListBox1.Directory[Length(DirectoryListBox1.Directory)] <> '\' THEN
          Current_FileName := DirectoryListBox1.Directory + '\' + 
                           FileListBox1.Items[Picts_Frm.Result_Image_Index]
       ELSE
          Current_FileName := DirectoryListBox1.Directory +
                           FileListBox1.Items[Picts_Frm.Result_Image_Index];
     END;
end;

procedure TMain_Frm.BitBtn4Click(Sender: TObject);
begin
  AboutBox.Showmodal;
end;

procedure TMain_Frm.BitBtn8Click(Sender: TObject);
begin
  IF SaveDialog1.Execute THEN
    BEGIN
      Image1.Picture.SaveTOFile(SaveDialog1.FileName);
      FileListBox1.UpDate;
    END;
end;

procedure TMain_Frm.FormActivate(Sender: TObject);
begin
  BitBtn8.Enabled := BitBtn5.Enabled;
end;

end.
