unit AVIB_Reg;

interface
USES
  DsgnIntf, Forms, AzimBrow, Graphics, Classes, SysUtils, TypInfo,
  FAV_DIR, About, Picts;

TYPE
  TGlimphEditor = CLASS(TPropertyEditor)
                PUBLIC
                  Function GetValue  : STRING;  Override;
                  function GetAttributes: TPropertyAttributes; Override;
                  procedure Edit; Override;
                END;

  TPictureEditor =  CLASS(TPropertyEditor)
                PUBLIC
                  Function GetValue  : STRING;  Override;
                  function GetAttributes: TPropertyAttributes; Override;
                  procedure Edit; Override;
                END;

PROCEDURE Register;

implementation

PROCEDURE Register;

BEGIN
  RegisterPropertyEditor(TypeInfo(TBitMap), nil, '',  TGlimphEditor);
  RegisterPropertyEditor(TypeInfo(TPicture), nil, '',  TPictureEditor);
END;


Function TGlimphEditor.GetValue  : STRING;

BEGIN
  Result := 'TAlexBMP';
END;

function TGlimphEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paReadOnly];
end;

procedure TGlimphEditor.Edit;

VAR
  Cur_Dir : STRING;


BEGIN
  Application.CreateForm(TMain_Frm, Main_Frm);
  Application.CreateForm(TFav_Add_frm, Fav_Add_frm);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TPicts_Frm, Picts_Frm);
  try
  Cur_Dir := Main_Frm.DirectoryListBox1.Directory;
  Main_Frm.BitBtn5.Enabled := Pointer(GetOrdValue) <> NIL;
  Main_Frm.Image1.Visible := Main_Frm.BitBtn5.Enabled;
  IF Main_Frm.BitBtn5.Enabled  THEN
     Main_Frm.Image1.Picture.BitMap := TBitMap(GetOrdValue);
  IF (Main_Frm.ShowModal = 1) THEN
    BEGIN
      IF Main_Frm.Image1.Visible THEN
        SetOrdValue(Longint(Main_Frm.Image1.Picture.BitMap))
      ELSE
        SetOrdValue(Longint(NIL));
    END;
  Finally
     Main_Frm.DirectoryListBox1.Directory := Cur_Dir;
     Main_Frm.DirectoryListBox1.Update;
     Main_Frm.Free;
     Fav_Add_frm.Free;
     AboutBox.Free;
     Picts_Frm.Free;
  END;
END;

Function TPictureEditor.GetValue  : STRING;

BEGIN
  Result := 'Averjin';
END;

function TPictureEditor.GetAttributes: TPropertyAttributes;

BEGIN
  Result := [paMultiSelect, paSubProperties, paDialog, paReadOnly];
END;

procedure TPictureEditor.Edit;

VAR
  Cur_Dir : STRING;
  The_Pict : TPicture;

BEGIN
  Application.CreateForm(TMain_Frm, Main_Frm);
  Application.CreateForm(TFav_Add_frm, Fav_Add_frm);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TPicts_Frm, Picts_Frm);
  try
  Cur_Dir := Main_Frm.DirectoryListBox1.Directory;
  The_Pict := TPicture(GetOrdValue);
  Main_Frm.Current_Bitmap := The_Pict.BitMap;
  IF (Main_Frm.ShowModal = 1) THEN
    BEGIN
      IF Main_Frm.Image1.Visible THEN
         The_Pict.BitMap := Main_Frm.Current_Bitmap
      ELSE
         The_Pict.BitMap := NIL;
      SetOrdValue(Longint(The_Pict))
    END;

  Finally
     Main_Frm.DirectoryListBox1.Directory := Cur_Dir;
     Main_Frm.DirectoryListBox1.Update;
     Main_Frm.Free;
     Fav_Add_frm.Free;
     AboutBox.Free;
     Picts_Frm.Free;
  END;
END;


end.
