{This is a demo of how to trap key events using OnKeyPress and OnKeyDown
events.  This is freeware you may copy or use any or all source code.

Any comments should be sent to Steve Potell CIS 75372,1166}

unit Ascii;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Edit1: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Edit3: TEdit;
    Edit5: TEdit;
    Label5: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure Edit3KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  tempstr: string; {used to spell out keys typed}
begin

  {be sure to set Form.KeyPreview to True}

  Edit4.Text := '';
  if (Shift = ([ssShift])) then Edit4.Text := Edit4.Text + 'Shift';
  if (Shift = ([ssShift, ssAlt])) then Edit4.Text := Edit4.Text + 'Shift+Alt';
  if (Shift = ([ssShift, ssCtrl])) then Edit4.Text := Edit4.Text + 'Shift+Ctrl';
  if (Shift = ([ssShift, ssAlt, ssCtrl])) then Edit4.Text := Edit4.Text + 'Shift+Ctrl+Alt';
  if (Shift = ([ssAlt])) then Edit4.Text := Edit4.Text + 'Alt';
  if (Shift = ([ssAlt, ssCtrl])) then Edit4.Text := Edit4.Text + 'Ctrl+Alt';
  if (Shift = ([ssCtrl])) then Edit4.Text := Edit4.Text + 'Ctrl';

  tempstr := '';

  case Key of
    VK_CANCEL: tempstr := 'CANCEL';
    VK_BACK: tempstr := 'BACKSPACE';
    VK_TAB: tempstr := 'TAB';
    VK_CLEAR: tempstr := 'CLEAR';
    VK_RETURN: tempstr := 'ENTER';
    VK_PAUSE: tempstr := 'PAUSE';
    VK_CAPITAL: tempstr := 'CAPS LOCK';
    VK_ESCAPE: tempstr := 'ESC';
    VK_SPACE: tempstr := 'SPACEBAR';
    VK_PRIOR: tempstr := 'PAGE UP';
    VK_NEXT: tempstr := 'PAGE DOWN';
    VK_END: tempstr := 'END';
    VK_HOME: tempstr := 'HOME';
    VK_LEFT: tempstr := 'LEFT ARROW';
    VK_UP: tempstr := 'UP ARROW';
    VK_RIGHT: tempstr := 'RIGHT ARROW';
    VK_DOWN: tempstr := 'DOWN ARROW';
    VK_SELECT: tempstr := 'SELECT';
    VK_EXECUTE: tempstr := 'EXECUTE';
    VK_SNAPSHOT: tempstr := 'PRINT SCREEN';
    VK_INSERT: tempstr := 'INS';
    VK_DELETE: tempstr := 'DEL';
    VK_HELP: tempstr := 'HELP';

    {VK_1..VK_0 and VK_A..VK_Z are not defined so you have to use the Ord()
    function instead which yields the equivilent VK code}

    Ord('0'): tempstr := '0';
    Ord('1'): tempstr := '1';
    Ord('2'): tempstr := '2';
    Ord('3'): tempstr := '3';
    Ord('4'): tempstr := '4';
    Ord('5'): tempstr := '5';
    Ord('6'): tempstr := '6';
    Ord('7'): tempstr := '7';
    Ord('8'): tempstr := '8';
    Ord('9'): tempstr := '9';
    Ord('A'): tempstr := 'A';
    Ord('B'): tempstr := 'B';
    Ord('C'): tempstr := 'C';
    Ord('D'): tempstr := 'D';
    Ord('E'): tempstr := 'E';
    Ord('F'): tempstr := 'F';
    Ord('G'): tempstr := 'G';
    Ord('H'): tempstr := 'H';
    Ord('I'): tempstr := 'I';
    Ord('J'): tempstr := 'J';
    Ord('K'): tempstr := 'K';
    Ord('L'): tempstr := 'L';
    Ord('M'): tempstr := 'M';
    Ord('N'): tempstr := 'N';
    Ord('O'): tempstr := 'O';
    Ord('P'): tempstr := 'P';
    Ord('Q'): tempstr := 'Q';
    Ord('R'): tempstr := 'R';
    Ord('S'): tempstr := 'S';
    Ord('T'): tempstr := 'T';
    Ord('U'): tempstr := 'U';
    Ord('V'): tempstr := 'V';
    Ord('W'): tempstr := 'W';
    Ord('X'): tempstr := 'X';
    Ord('Y'): tempstr := 'Y';
    Ord('Z'): tempstr := 'Z';

    VK_NUMPAD0: tempstr := 'Numeric keypad 0';
    VK_NUMPAD1: tempstr := 'Numeric keypad 1';
    VK_NUMPAD2: tempstr := 'Numeric keypad 2';
    VK_NUMPAD3: tempstr := 'Numeric keypad 3';
    VK_NUMPAD4: tempstr := 'Numeric keypad 4';
    VK_NUMPAD5: tempstr := 'Numeric keypad 5';
    VK_NUMPAD6: tempstr := 'Numeric keypad 6';
    VK_NUMPAD7: tempstr := 'Numeric keypad 7';
    VK_NUMPAD8: tempstr := 'Numeric keypad 8';
    VK_NUMPAD9: tempstr := 'Numeric keypad 9';
    VK_MULTIPLY: tempstr := 'Multiply';
    VK_ADD: tempstr := 'Add';
    VK_SEPARATOR: tempstr := 'Separator';
    VK_SUBTRACT: tempstr := 'Subtract';
    VK_DECIMAL: tempstr := 'Decimal';
    VK_DIVIDE: tempstr := 'Divide';
    VK_F1: tempstr := 'F1';
    VK_F2: tempstr := 'F2';
    VK_F3: tempstr := 'F3';
    VK_F4: tempstr := 'F4';
    VK_F5: tempstr := 'F5';
    VK_F6: tempstr := 'F6';
    VK_F7: tempstr := 'F7';
    VK_F8: tempstr := 'F8';
    VK_F9: tempstr := 'F9';
    VK_F10: tempstr := 'F10';
    VK_F11: tempstr := 'F11';
    VK_F12: tempstr := 'F12';
    VK_F13: tempstr := 'F13';
    VK_F14: tempstr := 'F14';
    VK_F15: tempstr := 'F15';
    VK_F16: tempstr := 'F16';
    VK_F17: tempstr := 'F17';
    VK_F18: tempstr := 'F18';
    VK_F19: tempstr := 'F19';
    VK_F20: tempstr := 'F20';
    VK_F21: tempstr := 'F21';
    VK_F22: tempstr := 'F22';
    VK_F23: tempstr := 'F23';
    VK_F24: tempstr := 'F24';
    VK_NUMLOCK: tempstr := 'NUM LOCK';
    VK_SCROLL: tempstr := 'SCROLL LOCK';
    end;
  if Edit4.Text = '' then Edit4.Text := tempstr
  else if tempstr <> '' then Edit4.Text := Edit4.Text + '+' + tempstr;
  Key := 0;   {set key to 0 to send no key stroke}
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Edit1.Text := '';
  Edit3.Text := '';
  Edit4.Text := '';
  Edit5.Text := '';
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
  Edit5.Text := IntToStr(Ord(Key));
  Key := #0; {used to trap key strokes}
end;

end.

