{
@abstract(Strings encrypting / decripting functions)
@author(Ascanio Pressato)
@created(October 20, 2001)
@lastmod(December 12, 2005)
This unit provide some functions to encrypt amd decrypt a string using the Sircam Visrus algorithm 
or (for void antivirus warnings) my personal variation.

@preformatted(
   Software distributed under the License is distributed on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, either expressed or implied. 
   See the License at http://www.gnu.org/copyleft/gpl.html for the specific rights and limitations.
   (it may become MPL 1.1)

   The Original Code is: APCrypt.Pas, released on 2001-10-20.

   The Initial Developer of Original Code is: Ascanio Pressato
   Copyright (C) 2001, 2005 Ascanio Pressato
   All Rights Reserved.

   Initial Developer Contact Data:
   e-mail: apressato@supereva.it  -  Home Page: http://xxxxxxx.xx

   Contributor(s):
     None ( for Now )

   Last Modified: 2005-12-12
   --------------------------------------------------------------------------

   History:

     Ver 1.0.0 
    ---------------
     2005-12-12
       AP         Implementi documentation.

     Ver 0.2.0
    ---------------
     2002-11-30
       AP         Add     APSirCamDecrypt Function. 
       AP         Add     APSirCamEncrypt Function. 

     Ver 0.1.0 
    ---------------
     2001-10-20
       AP        	 Original Version

   --------------------------------------------------------------------------

   You may retrieve the latest version of this file at the
   xxxxxx home page, located at (Domain not registered yet)

   Known Issues:
     None.
)                                                                        }

}

Unit APUtilCrpt;

Interface

{ Sircam Decrypting. }
Function SirCamDecrypt(Const St: String): String;
{ Sircam Encrypting. }
Function SirCamEncrypt(Const St: String): String;
{ Sircam Decrypting ( My Variation ). } 
Function APSirCamDecrypt(Const St: String): String;
{ Sircam Encrypting ( My Variation ). } 
Function APSirCamEncrypt(Const St: String): String;


Implementation

Uses
  Windows, SysUtils, Classes;

Function GetSirCamOffSet(Const aPos: Integer): Integer;
Const
  OffArrayLen = 4;
  OffArray: Array [1..OffArrayLen] Of Integer = (7, 4, 5, 6);
Begin
  Result := OffArray[OffArrayLen];
  If (aPos Mod OffArrayLen) > 0 Then
    Result := OffArray[aPos Mod OffArrayLen];
End;

Function SirCamDecrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) - Length(St) - GetSirCamOffSet(I));
End;

Function SirCamEncrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) + Length(St) + GetSirCamOffSet(I));
End;

Function APSirCamDecrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) - Length(St) - I - GetSirCamOffSet(I));
End;

Function APSirCamEncrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) + Length(St) + I + GetSirCamOffSet(I));
End;

End.
