unit Testform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, AppIcon;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    Timer1: TTimer;
    ListBox1: TListBox;
    AppIcon1: TAppIcon;
    Label1: TLabel;
    procedure AppIcon1Activate(Sender: TObject);
    procedure AppIcon1Deactivate(Sender: TObject);
    procedure AppIcon1FileDrop(Sender: TObject; Files: TStrings);
    procedure AppIcon1Paint(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.AppIcon1Activate(Sender: TObject);
begin
  AppIcon1.Font.Color := clCaptionText;
  AppIcon1.Color := clActiveCaption;
end;

procedure TForm1.AppIcon1Deactivate(Sender: TObject);
begin
  AppIcon1.Color := clBackground;
  AppIcon1.Font.Color := clInactiveCaptionText;
end;

procedure TForm1.AppIcon1FileDrop(Sender: TObject; Files: TStrings);
begin
  ListBox1.Items := Files;
end;

procedure TForm1.AppIcon1Paint(Sender: TObject);
begin
  AppIcon1.Canvas.TextOut(0, AppIcon1.Height div 2, TimeToStr(Time));
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  AppIcon1.StayOnTop := CheckBox1.Checked;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if IsIconic(Application.Handle) then
    InvalidateRect(Application.Handle, nil, True);
end;

end.
{--=>revision-history<=--}
{1 TESTFORM.PAS 22-Sep-95,9:11:52,`lisch' CHANGE=INITIAL                      }
{     Initial version.                                                        }
{--=>revision-history<=--}
