unit Aplicata;
{ 
  Title     : TApplicata - Mutated TApplication object
  Author    : Gintaras Pikelis
}

interface

uses
    SysUtils, WinProcs, WinTypes, Classes, Forms, Graphics;

type
  TDuplicateError=class(Exception);
    
  TApplicata = class(TComponent)
  private
    { Private declarations }
    FHint: String;
    FHintColor: TColor;
    FHintPause: Integer;
    FShowHint: Boolean;

    FHelpFile: String;
    FIcon: TIcon;
    FTitle: String;

    FOneInstance: Boolean; 
    FOnSecondInstance: TNotifyEvent;
    
    FOnActivate: TNotifyEvent;
    FOnDeactivate: TNotifyEvent;
    fOnException: TExceptionEvent;
    FOnHelp: THelpEvent;
    FOnHint:  TNotifyEvent;
    FOnIdle: TIdleEvent;
    FOnMessage: TMessageEvent;

    Procedure GotoPreviousInstance;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
    procedure SetIcon(Value: TIcon);
  published
    { Published declarations }
    property Hint: String read FHint write FHint;
    property HintColor: TColor read FHintColor write FHintColor default clYellow;
    property HintPause: Integer read FHintPause write FHintPause;
    property ShowHint: Boolean read FShowHint write FShowHint default true;

    property HelpFile: String read FHelpFile write FHelpFile;
    property Title: string read FTitle write FTitle;
    property Icon: TIcon read FIcon write SetIcon;

    property OneInstance: Boolean read FOneInstance write FOneInstance default true;
    property OnSecondInstance: TNotifyEvent read  FOnSecondInstance
                                            write FOnSecondInstance;

    property OnActivate: TNotifyEvent read FOnActivate write FonActivate;
    property OnDeactivate: TNotifyEvent read FOnDeactivate write FOnDeactivate;
    property OnException: TExceptionEvent read FOnException write FOnException;
    property OnHelp: THelpEvent read FOnHelp write FOnHelp;
    property OnHint: TNotifyEvent read FOnHint write FOnHint;
    property OnIdle: TIdleEvent read FOnIdle write FOnIdle;
    property OnMessage: TMessageEvent read FOnMessage write FOnMessage;
  end;

procedure Register;
type
  PHWND = ^HWND;
  Function EnumFunc(Wnd:HWND; TargetWindow:PHWND): boolean; export;

implementation

const
     { how many copies of TApplicata are "alive" ?}
     ComponentCounter: Integer = 0;

procedure Register;
begin
  RegisterComponents('Grass', [TApplicata]);
end;

Function EnumFunc(Wnd:HWND; TargetWindow:PHWND): boolean;
var
   ClassName : array[0..30] of char;
begin
     result := TRUE;
     if GetWindowWord(Wnd,GWW_HINSTANCE)=hPrevInst then begin
        GetClassName(Wnd,ClassName,30);
        if StrIComp(ClassName,'TApplication')=0 then begin
           TargetWindow^:=Wnd;
           result:=FALSE;
        end;
     end;
end;

Constructor TApplicata.Create;
begin
     Inc(ComponentCounter);
     if ComponentCounter>1 then 
        { It isn't logical to have more than one TApplicata 
          component in your application. I don't know how will
          it react if you'll allow that. }
        raise TDuplicateError.Create('You can have only '+
              'one TApplicata component in a project');
     Inherited Create(AOwner);

     ShowHint:=True;
     HintColor:=clYellow;
     FIcon:=TIcon.Create;     { Create Icon Object }
     OneInstance:=True;
end;

Destructor TApplicata.Destroy;
begin
     Inherited Destroy;
     FIcon.Free;       { destroy the Icon object }
     Dec(ComponentCounter);
end;

Procedure TApplicata.Loaded;
begin
   Inherited Loaded;
   { don't try it in Design mode, you may find some suprises :-) }
   if not (csDesigning in ComponentState) then begin
     { do the instance count verification }
     if OneInstance and (hPrevInst<>0) then begin
        if Assigned(FOnSecondInstance) then
           FOnSecondInstance(Self);
        GotoPreviousInstance;
        Halt;
     end;

     { if everything is OK, set Application's properties }
     if FHint<>'' then Application.Hint:=FHint;
     if FHintColor<>Application.HintColor then
        Application.HintColor:=FHintColor;
     if FHintPause<>Application.HintPause then
        Application.HintPause:=FHintPause;
     if FShowHint<>Application.ShowHint then 
        Application.ShowHint:=FShowHint;

     if FHelpFile<>Application.HelpFile then
        Application.HelpFile:=FHelpFile;

        Application.Icon.Assign(FIcon);

     if FTitle<>Application.Title then
        Application.Title:=FTitle;

     { !!! maybe we should check if these were assigned in code}
     if Assigned(FOnActivate) then
        Application.OnActivate:=FOnActivate;
     if Assigned(FOnDeActivate) then
        Application.OnDeActivate:=FOnDeActivate;
     if Assigned(FOnException) then
        Application.OnException:=FOnException;
     if Assigned(FOnHelp) then
        Application.OnHelp:=FOnHelp;
     if Assigned(FOnHint) then
        Application.OnHint:=FOnHint;
     if Assigned(FOnIdle) then
        Application.OnIdle:=FOnIdle;
     if Assigned(FOnMessage) then
        Application.OnMessage:=FOnMessage;
   end;
end;

Procedure TApplicata.SetIcon(Value: TIcon);
begin
     FIcon.Assign(Value);
end;

procedure TApplicata.GotoPreviousInstance;
var
   PrevInstWnd: HWND;
begin
     PrevInstWnd:=0;
     EnumWindows(@EnumFunc,longint(@PrevInstWnd));
     if PrevInstWnd<>0 then
        if IsIconic(PrevInstWnd) then 
           ShowWindow(PrevInstWnd,SW_RESTORE)
        else 
           BringWindowToTop(PrevInstWnd);
end;

end.
 