unit APEReg;


interface

uses
  ape, SysUtils, Classes, exptintf, dsgnintf;


type
  TFormStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

procedure Register;

implementation

{$IFDEF WIN32}
{$R *.D32}
{$ELSE}
{$R *.D16}
{$ENDIF}

function TFormStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TFormStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ Registration }

type
  TApeDialogProperty = class(TFormStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TApeDialogProperty.GetValueList(List: TStrings);
var
   n,i:integer;
begin
  if (ApeMainForm<>nil) then
  with ApeMainForm do
  begin
    n:=FormNameList.count;
    List.Clear;
    for i:=0 to n-1 do
      List.Add(FormNameList.Strings[i]);
  end;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TApeMainForm,TApeForm,TApeDialog]);
  RegisterPropertyEditor(TypeInfo(string), TApeDialog, 'FormClassName',TApeDialogProperty);
end;

end.
