{ Andre's Program Engine (APE) Components

  Autor: Demidov Andre (E-mail: andre@lion.tu-chel.ac.ru)
  Version 1.04
  (c) 1997

changes from 1.0
1. test on D2.0, C++Builder
2. old onActivate event don't call
3. enable multiple TApeDialog with one Form
4. add global var CurrentPID for link with other VCLs
1.03:
5. eliminate possible error when object in TApeDialog.withObject
   is destroing
6. add withParms property to TApeDialog and TApeForm
1.04:
7. add dinamyc memory allocation for ProcessInfo and CurrentInfo
1.05
8. add help
9. fix bugs
10. run-time properties ChildForm and ParentForm
}

unit Ape;

interface
uses Forms, Classes, sysUtils;

type ApeCreateFormMode=(ThisLevel,
                        NextLevel,
                        SelectValue);

     ApeActivateFormMode=(NoneAction,
                          SelectObject,
                          WaitObject,
                          CreateObject);

     ApeFormMode=(FormWindow,
                 BrowseWindow);

    TApeSelectProc=procedure(Sender:TObject; SelectedValue:string) of object;
    TApeShowProc=procedure(Sender:TObject; PMode:ApeActivateFormMode;
         PObject:TObject; PValue,PSelect:string) of object;

    TApeDialog=class(TComponent)
    private
      FParamsList: Tstrings;
      FFormClassName:string;
      FObjectValue:TComponent;
      FParamValue:string;
      FSelectValue:string;
      FSelect:TApeSelectProc;
      FExecuteMode:ApeCreateFormMode;
      FprocessID:integer;
      procedure SetParamsList(val: TStrings);
    protected
      procedure Notification( AComponent: TComponent;
                              Operation: TOperation); override;
    public
      constructor Create(AOwner:TComponent); override;
      destructor Destroy; override;
      procedure Execute;
      function GetChildForm:TForm; {Obsolete}
      property ProcessID:integer read FprocessID;
      property ChildForm:TForm read GetChildForm;
    published
      property FormClassName:string read FFormClassName write FFormClassName;
      property withValue:string read FParamValue write FParamValue;
      property withSelect:string read FSelectValue write FSelectValue;
      property withObject:TComponent read FObjectValue write FObjectValue;
      property ExecuteMode:ApeCreateFormMode read FExecuteMode write FExecuteMode;
      property withParams: Tstrings read FParamsList write SetParamsList;
      property OnSelect:TApeSelectProc read FSelect write FSelect;
    end;

    TApeForm=class(TComponent)
    private
      oldActivateProc:TNotifyEvent;
      OldShowProc:TNotifyEvent;
      oldCloseProc:TCloseEvent;
      FFirstShow:TApeShowProc;
      FFormMode:ApeFormMode;
      FSelectResult:string;
      FParamsList: Tstrings;
      procedure SetFormMode(FMode:ApeFormMode);
      procedure SetSelectResult(FResult:string);
      procedure ActivateProc(Sender:TObject);
      procedure CloseProc(Sender:TObject; var Action: TCloseAction);
      procedure ShowProc(Sender:TObject);
    protected
      procedure Loaded; override;
    public
      constructor Create(AOwner:TComponent); override;
      destructor Destroy; override;
      function GetParentForm:TForm; {Obsolete}
      property SelectResult:string read FSelectResult write SetSelectResult;
      property withParams: Tstrings read FParamsList;
      property ParentForm:TForm read GetParentForm;
    published
      property FormMode:ApeFormMode read FFormMode write setFormMode;
      property onFirstShow:TApeShowProc read FFirstShow write FFirstShow;
    end;

    TApeMainForm=class(TComponent)
    private
      FFormNameList: TStrings;
    protected
      procedure AddFormName(val: string);
      procedure SetFormNameList(val:TStrings);
    public
      constructor Create(AOwner:TComponent); override;
      destructor Destroy; override;
    published
      property FormNameList: TStrings read FFormNameList write SetFormNameList;
    end;

function ApeGetParent(PForm:TForm):TForm;

var
   CurrentPID: integer;
   ApeMainForm: TApeMainForm;

implementation

const MaxNForm=200;
      MaxNProcess=100;

type ProcessInfoRecord=
    record
       PClass:TFormClass;
       PForm:TForm;
       PFormParent:TForm;
       PLevel:integer;
       PID:integer;
       PMode:ApeActivateFormMode;
       PObject:TObject;
       PValue:string[32];
       PSelect:string[32];
       PrID:integer;
    end;
    ProcessInfoArray=array [1..MaxNForm] of ProcessInfoRecord;
    CurrentInfoArray=array [1..MaxNProcess] of TForm;

var ProcessInfo:^ProcessInfoArray;
    CurrentInfo:^CurrentInfoArray;
    NForm:integer;
    ApeMainFormCount: integer;
    SaveExitProc:Pointer;

procedure ApeInit; forward;
procedure ApeCreateProcess(PClass:TFormClass; PID:integer;
          var PForm; PValue:string); forward;
procedure ApeSelectProcess(PID:integer); forward;
function ApeProcessRunning(PID:integer):Boolean; forward;
procedure ApeCreateForm(PClass:TFormClass; PFormP:TForm;
          var PForm; PMode:ApeCreateFormMode;
          PObject:TObject; PValue:string; PSelect:string); forward;
procedure ApeCreateForm2(PClass:TFormClass; PFormP:TForm;
          var PForm; PMode:ApeCreateFormMode;
          PObject1,PObject2:TObject; PValue:string; PSelect:string;
          PrID:integer); forward;
procedure ApeCloseForm(PForm:TForm); forward;
procedure ApeSelectForm(PForm:TForm); forward;
procedure ApeGetMode(PForm:TForm; var PMode:ApeActivateFormMode;
                   var PObject:TObject; var PValue:string;
          var PSelect:string); forward;
function ApeGetChild(PForm:TForm;PClass:TFormClass):TForm; forward;
function ApeGetChild2(PForm:TForm;PClass:TFormClass;PrID:integer):TForm; forward;
function ApeGetProcessChild(PID:integer):TForm; forward;
procedure ApeSetSelect(PForm:TForm; PSelect:string); forward;

procedure ApeExit; far;
begin
{$IFNDEF DELPHI32}
  ExitProc:=SaveExitProc;
{$ENDIF}
  if (ApeMainFormCount=0) then
  begin
    Dispose(ProcessInfo);
    Dispose(CurrentInfo);
  end;
end;

procedure ApeInit;
begin
  NForm:=0;
  ApeMainForm:=nil;
  ApeMainFormCount:=0;
  New(ProcessInfo);
  new(CurrentInfo);
{$IFNDEF DELPHI32}
  SaveExitProc:=ExitProc;
  ExitProc:=@ApeExit;
{$ENDIF}
end;

{ TApeMainForm }

procedure TApeMainForm.SetFormNameList(val:TStrings);
begin
  FFormNameList.Assign(val);
end;

procedure TApeMainForm.AddFormName(val:string);
begin
  if (FFormNameList.IndexOf(val)>-1) then exit;
  FFormNameList.Add(val);
end;

constructor TApeMainForm.Create(AOwner:Tcomponent);
begin
  inc(ApeMainFormCount);
  if (AOwner<>nil) then
    with AOwner as TForm do
    begin
        if (ApeMainForm<>nil) then
        Raise Exception.Create('TApeMainForm must be sole in the project!');
    end;

  inherited Create(Aowner);
  if (csDesigning in ComponentState)  and (AOwner<>nil) then
    with AOwner as TForm do
    begin
      FormStyle:=fsMDIForm;
    end;
  ApeMainForm:=self;
  FFormNameList:= TStringList.Create;
end;

destructor TApeMainForm.Destroy;
begin
  FFormNameList.Free;
  inherited Destroy;
  dec(ApeMainFormCount);
  if (ApeMainFormCount=0) then
    ApeMainForm:=nil;
end;

{ TApeForm }

constructor TApeForm.Create(AOwner:Tcomponent);
var
   i: integer;
begin
  if (AOwner<>nil) then
    with AOwner as TForm do
    begin
    for I := 0 to ComponentCount -1 do
     if (Components[I] is TApeForm) or (Components[I] is TApeMainForm) then
        Raise Exception.Create('TApeForm must be sole on the form!');
    end;

  inherited Create(Aowner);
  FParamsList:=nil;
  oldActivateProc:=nil;
  OldShowProc:=nil;
  oldCloseProc:=nil;
  FFormMode:=FormWindow;
  if (csDesigning in ComponentState)  and (AOwner<>nil) then
  begin
    with AOwner as TForm do
    begin
      if (ApeMainForm<>nil) then
         ApeMainForm.AddFormName(ClassName);
      FormStyle:=fsMDIChild;
      Position:=poDefaultPosOnly;
      if FFormMode=FormWindow then
      begin
        BorderIcons:=[biSystemMenu,biMinimize];
        BorderStyle:=bsSingle;
      end;
    end;
  end;
end;

destructor TApeForm.Destroy;
begin
  if not (csDesigning in ComponentState)  and (Owner<>nil) then
  begin
    with Owner as TForm do
    begin
      OnShow:=oldShowProc;
      OnActivate:=oldActivateProc;
      OnClose:=oldCloseProc;
    end;
  end;
  inherited Destroy;
end;


function TApeForm.GetParentForm:TForm;
begin
  Result:=ApeGetParent(TForm(Owner));
end;

procedure TApeForm.Loaded;
begin
  inherited Loaded;
  if not (csDesigning in ComponentState)  and (Owner<>nil) then
  begin
    with Owner as TForm do
    begin
      oldShowProc:=onShow;
      oldActivateProc:=onActivate;
      oldCloseProc:=onClose;
      onShow:=ShowProc;
      onActivate:=ActivateProc;
      onClose:=CloseProc;
    end;
  end
  else
  if (csDesigning in ComponentState)  and (Owner<>nil) then
  begin
    with Owner as TForm do
    begin
      FormStyle:=fsMDIChild;
      Position:=poDefaultPosOnly;
      if FFormMode=FormWindow then
      begin
        BorderIcons:=[biSystemMenu,biMinimize];
        BorderStyle:=bsSingle;
      end;
    end;
  end;
end;

procedure TApeForm.SetSelectResult(FResult:string);
begin
  ApeSetSelect(TForm(Owner),FResult);
  FSelectResult:=FResult;
end;

procedure TApeForm.SetFormMode(FMode:ApeFormMode);
begin
  if FFormMode<>FMode then
  begin
    FFormMode:=FMode;
  if (csDesigning in ComponentState)  and (Owner<>nil) then
  begin
    with Owner as TForm do
    begin
      FormStyle:=fsMDIChild;
      Position:=poDefaultPosOnly;
      if FFormMode=FormWindow then
      begin
        BorderIcons:=[biSystemMenu,biMinimize];
        BorderStyle:=bsSingle;
      end
      else
      begin
        BorderIcons:=[biSystemMenu,biMinimize,biMaximize];
        BorderStyle:=bsSizeable;
      end;
    end;
  end;
  end;
end;

procedure TApeForm.ActivateProc(Sender:TObject);
var PMode:ApeActivateFormMode;
    PObject:TObject;
    PValue:string;
    PSelect:string;
    SProc:TApeSelectProc;
begin
  ApeGetMode(TForm(Owner),Pmode,Pobject,PValue,Pselect);
  if Pmode=waitObject then
  begin
    if Pobject is TApeDialog then
    begin
      with PObject as TApeDialog do
      begin
        sProc:=onSelect;
        if assigned(sProc) then
          onSelect(PObject,Pselect);
      end;
    end;
  end;
  ApeSelectForm(TForm(Owner));
  if assigned(oldActivateProc) then oldActivateProc(Sender);
end;

procedure TApeForm.CloseProc(Sender:TObject; var Action: TCloseAction);
begin
  if assigned(oldCloseProc) then oldCloseProc(Sender,Action);
  Action:=caFree;
  ApeCloseForm(Tform(owner));
end;

procedure TApeForm.ShowProc(Sender:TObject);
var PMode:ApeActivateFormMode;
    PObject:TObject;
    PValue:string;
    PSelect:string;
    PForm:TForm;
    i:integer;
begin
  ApeGetMode(TForm(Owner),Pmode,Pobject,PValue,Pselect);
  if Pmode<>noneAction then
  begin
    PForm:=GetParentForm;
    if (PForm=nil) then
       PForm:=(ApeMainForm.Owner as TForm);
    FParamsList:=nil;
    with PForm do
    begin
      for I := 0 to ComponentCount -1 do
        if (Components[I] is TApeDialog) then
           if ((Components[I] as TApeDialog).GetChildForm=TForm(Self.Owner)) then
             FParamsList:=(Components[i] as TApeDialog).withParams;
    end;
    if assigned(FFirstShow) then
      FFirstShow(sender,PMode,Pobject,Pvalue,Pselect);
  end;
  if assigned(oldShowProc) then
    oldShowProc(sender);
end;

{ TApeDialog }

constructor TApeDialog.Create(AOwner:TComponent);
var i,PID,maxPID:integer;
   cmpt:TComponent;
begin
  inherited Create(Aowner);
  FparamsList:=TstringList.Create;
  FFormClassName:='';
  FObjectValue:=nil;
  FParamValue:='';
  FSelectValue:='';
  FSelect:=nil;
  FExecuteMode:=SelectValue;
  FProcessId:=0;
  maxPID:=0;
  for i:=0 to (AOwner as TForm).ComponentCount-1 do
  begin
    cmpt:=(AOwner as TForm).Components[i];
    if cmpt is TApeDialog then
    begin
      PID:=(cmpt as TApeDialog).FprocessID;
      if PID>maxPID then
        maxPID:=PID;
    end;
  end;
  FProcessId:=maxPID+1;
end;

destructor TApeDialog.Destroy;
begin
  FparamsList.Free;
  inherited Destroy;
end;

procedure TApeDialog.Notification( AComponent: TComponent;
                              Operation: TOperation);
begin
  inherited Notification( AComponent, Operation);
  if (Operation  = opRemove) and
     (AComponent = FObjectValue) then
      FObjectValue:=nil;
end;

procedure TApeDialog.Execute;
var PForm:TForm;
    PClass:TFormClass;
begin
  PClass:=TFormClass(GetClass(FFormClassName));
  if PClass<>nil then
  begin
  if (Owner as TForm).FormStyle=fsMDIChild then
  begin
    ApeCreateForm2(PClass,
       TForm(Owner),PForm,FExecuteMode,Self,FobjectValue,
          FParamValue,FSelectValue, ProcessID);
  end
  else
  begin
    ApeCreateProcess(PClass, ProcessID,
          PForm, FParamValue);
  end;
  end;
end;

function TApeDialog.GetChildForm:TForm;
var PClass:TFormClass;
begin
  Result:=nil;
  if (Owner as TForm).FormStyle=fsMDIChild then
  begin
    Pclass:=TFormClass(GetClass(FFormClassName));
    if Pclass<>nil then
      Result:=ApeGetChild2(Tform(Owner), Pclass, ProcessID);
  end
  else
    Result:=ApeGetProcessChild(ProcessID);
end;

procedure TApeDialog.SetParamsList(val:Tstrings);
begin
  FParamsList.Assign(val);
end;

function findInfo(PForm:TForm):integer;
var i:integer;
begin
  Result:=0;
  for I:=1 to NForm do
  begin
    if PForm=ProcessInfo^[i].Pform then
    begin
      Result:=i;
      break;
    end;
  end;
end;

procedure ApeCreateProcess(PClass:TFormClass; PID:integer;
          var PForm; Pvalue:string);
var i:integer;
begin
  if (PID<=0) or (PID>MaxNProcess) then
  begin
    TForm(PForm):=nil;
  end
  else if ApeProcessRunning(PID) then
  begin
    ApeSelectProcess(PID);
    TForm(PForm):=nil;
  end
  else
  begin
    i:=findInfo(nil);
    if i=0 then
    begin
      NForm:=NForm+1;
      i:=NForm;
    end;
    ProcessInfo^[i].PClass:=PClass;
    ProcessInfo^[i].PValue:=PValue;
    ProcessInfo^[i].PSelect:='';
    ProcessInfo^[i].PObject:=nil;
    ProcessInfo^[i].PMode:=CreateObject;
    ProcessInfo^[i].PID:=PID;
    CurrentPID:=PID;
    ProcessInfo^[i].PLevel:=1;
    ProcessInfo^[i].PFormParent:=nil;
    Application.CreateForm(PClass,ProcessInfo^[i].PForm);
    TForm(PForm):=ProcessInfo^[i].PForm;
    TForm(PForm).Show;
  end;
end;

procedure ApeSelectProcess(PID:integer);
var i:integer;
begin
  if (PID<=0) or (PID>MaxNProcess) then
    Exit;
  if CurrentInfo^[PID]<>nil then
  begin
    i:=findInfo(CurrentInfo^[PID]);
    if i>0 then
    begin
      with CurrentInfo^[PID] do
      begin
        if windowState=wsMinimized then
          windowState:=wsNormal;
        CurrentPID:=PID;
        Show;
      end;
    end;
  end;
end;

function ApeProcessRunning(PID:integer):Boolean;
var i:integer;
begin
  Result:=False;
  if PID=0 then
  begin
    for I:=1 to NForm do
    begin
      if (ProcessInfo^[i].PForm<>nil) then
      begin
        Result:=True;
        Exit;
      end;
    end;
  end;
  if (PID<=0) or (PID>MaxNProcess) then
    Exit;
  for I:=1 to NForm do
  begin
    if (ProcessInfo^[i].PForm<>nil) and
       (PID=ProcessInfo^[i].PID) then
    begin
      Result:=True;
      Break;
    end;
  end;
end;

function ApeGetProcessChild(PID:integer):TForm;
var i:integer;
begin
  Result:=nil;
  if (PID<=0) or (PID>MaxNProcess) then
    Exit;
  for I:=1 to NForm do
  begin
    if (ProcessInfo^[i].PForm<>nil) and
       (ProcessInfo^[i].PFormParent=nil) and
       (PID=ProcessInfo^[i].PID) then
    begin
      Result:=ProcessInfo^[i].PForm;
      Break;
    end;
  end;
end;

procedure ApeCreateForm(PClass:TFormClass; PFormP:TForm;
          var PForm; PMode:ApeCreateFormMode;
          PObject:TObject; PValue:string; Pselect:string);
begin
  if Pmode=SelectValue then
    ApeCreateForm2(Pclass,PFormP,PForm,PMode,PObject,nil,PValue,Pselect,0)
  else
    ApeCreateForm2(Pclass,PFormP,PForm,PMode,nil,PObject,PValue,Pselect,0);
end;

procedure ApeCreateForm2(PClass:TFormClass; PFormP:TForm;
          var PForm; PMode:ApeCreateFormMode;
          PObject1, PObject2:TObject; PValue:string; Pselect:string; PrID:integer);
var p,i,lvl,j:integer;
begin
  for i:=1 to Nform do
    if (ProcessInfo^[i].Pform<>nil) and
       (ProcessInfo^[i].PformParent=PFormP) and
       (ProcessInfo^[i].PClass=PClass) and
       ((PrID=0) or (ProcessInfo^[i].PrID=PrID)) then
    begin
      TForm(PForm):=ProcessInfo^[i].Pform;
      with ProcessInfo^[i].Pform do
      begin
        if windowState=wsMinimized then
          windowState:=wsNormal;
        Show;
      end;
      Exit;
    end;
  p:=findInfo(PFormP);
  if p=0 then
    TForm(PForm):=nil
  else
  begin
    i:=findInfo(nil);
    if i=0 then
    begin
      NForm:=NForm+1;
      i:=NForm;
    end;
    ProcessInfo^[i].PForm:=nil;
    ProcessInfo^[i].PValue:=PValue;
    ProcessInfo^[i].PSelect:=PSelect;
    ProcessInfo^[i].PClass:=PClass;
    ProcessInfo^[p].PSelect:='';
    ProcessInfo^[p].PMode:=NoneAction;
    ProcessInfo^[p].PObject:=PObject1;
    ProcessInfo^[i].PObject:=Pobject2;
    if Pmode=SelectValue then
      begin
        ProcessInfo^[i].PMode:=SelectObject;
      end
    else
      begin
        ProcessInfo^[i].PMode:=CreateObject;
      end;
    ProcessInfo^[i].PID:=ProcessInfo^[p].PID;
    ProcessInfo^[i].PrID:=PrID;
    CurrentPID:=ProcessInfo^[p].PID;
    ProcessInfo^[i].PFormParent:=PFormP;
    if Pmode=ThisLevel then
      ProcessInfo^[i].PLevel:=ProcessInfo^[p].Plevel
    else
    begin
      ProcessInfo^[i].PLevel:=ProcessInfo^[p].Plevel+1;
      for j:=1 to NForm do
      begin
        if (ProcessInfo^[j].PLevel=ProcessInfo^[p].Plevel) and
           (ProcessInfo^[j].PID=ProcessInfo^[p].PID) and
          (ProcessInfo^[j].PForm<>nil) then
          ProcessInfo^[j].PForm.Enabled:=false;
      end;
    end;
    Application.CreateForm(PClass,ProcessInfo^[i].PForm);
    TForm(PForm):=ProcessInfo^[i].PForm;
    TForm(PForm).Show;
  end;
end;

procedure ApeCloseForm(PForm:TForm);
var i,j,p:integer;
begin
  i:=findInfo(PForm);
  if i>0 then
  begin
    for j:=1 to Nform do
    begin
      if (ProcessInfo^[j].PForm<>nil) and
         (ProcessInfo^[j].PFormParent=PForm) then
        ProcessInfo^[j].PForm.Close;
    end;
    ProcessInfo^[i].PForm:=nil;
    if ProcessInfo^[i].PformParent<>nil then
    begin
    p:=findInfo(ProcessInfo^[i].PformParent);
    if p>0 then
    begin
      if ProcessInfo^[p].Plevel<>ProcessInfo^[i].Plevel then
      begin
        {    }
        for j:=1 to NForm do
        begin
          if (ProcessInfo^[j].PLevel=ProcessInfo^[p].Plevel) and
             (ProcessInfo^[j].PID=ProcessInfo^[p].PID) and
             (ProcessInfo^[j].PForm<>nil) then
            ProcessInfo^[j].PForm.Enabled:=True;
        end;
      end;
      CurrentPID:=ProcessInfo^[p].PID;
      with ProcessInfo^[p].Pform do
      begin
        if windowState=wsMinimized then
          windowState:=wsNormal;
        Show;
      end;
    end;
    end
    else if ProcessInfo^[i].Plevel=1 then
    begin
      CurrentInfo^[ProcessInfo^[i].PID]:=nil;
    end;
  end;
end;

procedure ApeSelectForm(PForm:TForm);
var i:integer;
begin
  i:=findInfo(PForm);
  if i>0 then
  begin
    CurrentPID:=ProcessInfo^[i].PID;
    CurrentInfo^[ProcessInfo^[i].PID]:=PForm;
    ProcessInfo^[i].Pmode:=NoneAction;
    ProcessInfo^[i].PValue:='';
    ProcessInfo^[i].PSelect:='';
  end;
end;

procedure ApeGetMode(PForm:TForm; var PMode:ApeActivateFormMode;
                   var PObject:TObject; var PValue:string; var PSelect:string);
var i:integer;
begin
  i:=findInfo(PForm);
  if i>0 then
  begin
    Pmode:=ProcessInfo^[i].Pmode;
    PObject:=ProcessInfo^[i].Pobject;
    Pvalue:=ProcessInfo^[i].Pvalue;
    PSelect:=ProcessInfo^[i].PSelect;
  end
  else
  begin
    Pmode:=NoneAction;
    PObject:=nil;
    Pvalue:='';
    PSelect:='';
  end;
end;

procedure ApeSetSelect(PForm:TForm; PSelect:string);
var i,p:integer;
begin
  i:=findInfo(PForm);
  if i>0 then
  begin
     p:=findInfo(ProcessInfo^[i].PformParent);
     if p>0 then
     begin
       ProcessInfo^[p].PSelect:=PSelect;
       ProcessInfo^[p].Pmode:=WaitObject;
     end;
  end;
end;

function ApeGetParent(PForm:TForm):TForm;
var i:integer;
begin
  I:=findinfo(PForm);
  Result:=nil;
  if i>0 then
  begin
    if findinfo(ProcessInfo^[i].PformParent)>0 then
      Result:=ProcessInfo^[i].PformParent;
  end;
end;
function ApeGetChild(PForm:TForm; PClass:TFormClass):TForm;
begin
  Result:=ApeGetChild2(PForm,PClass,0);
end;

function ApeGetChild2(PForm:TForm; PClass:TFormClass; PrID:integer):TForm;
var i:integer;
begin
  Result:=nil;
  for i:=1 to Nform do
    if (ProcessInfo^[i].Pform<>nil) and
       (ProcessInfo^[i].PformParent=PForm) and
       (ProcessInfo^[i].PClass=PClass) and
       ((PrID=0) or (ProcessInfo^[i].PrID=PrID)) then
    begin
      Result:=ProcessInfo^[i].Pform;
      Break;
    end;
end;

initialization
  ApeInit
{$IFDEF DELPHI32}
finalization
  ApeExit
{$ENDIF}
end.
