{##############################################################################}
{#                                                                            #}
{# Unit Name: APCrypt                                                         #}
{# Purpose  : Crypting / Decrypting Strings                                   #}
{# Author   : Ascanio Pressato                                                #}
{# License  : This software is provided as-is. No expressed or implied        #}
{#            warranty. In no event is author liable for damages.             #}
{# Notes    : If you like my work, please mention me in your credits.         #}
{#                                                                            #}
{##############################################################################}
{#                                                                            #}
{# History  :                                                                 #}
{#                                                                            #}
{#   Version 0.2.0.0 (2002-11-30)                                             #}
{#   ----------------------------                                             #}
{#     Added APSirCamDecrypt Function.                                        #}
{#     Added APSirCamEncrypt Function.                                        #}
{#                                                                            #}
{#   Version 0.1.0.0 (2001-10-20)                                             #}
{#   ----------------                                                         #}
{#     First Release                                                          #}
{#                                                                            #}
{##############################################################################}

Unit APCrypt;

Interface

{ Decrypting algorithm used from the Sircam virus. }
Function SirCamDecrypt(Const St: String): String;
{ Crypting algorithm used from the Sircam virus. }
Function SirCamEncrypt(Const St: String): String;
{ Decrypting algorithm used from the Sircam virus. (My Personal Variant) }
Function APSirCamDecrypt(Const St: String): String;
{ Crypting algorithm used from the Sircam virus. (My Personal Variant) }
Function APSirCamEncrypt(Const St: String): String;


Implementation

Uses
  Windows, SysUtils, Classes;

{*************************************************************}
{         [ SirCam Crypting / Decripting Functions. ]         }
{_____________________________________________________________}

Function GetSirCamOffSet(Const aPos: Integer): Integer;
Const
  OffArrayLen = 4;
  OffArray: Array [1..OffArrayLen] Of Integer = (7, 4, 5, 6);
Begin
  Result := OffArray[OffArrayLen];
  If (aPos Mod OffArrayLen) > 0 Then
    Result := OffArray[aPos Mod OffArrayLen];
End;

Function SirCamDecrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) - Length(St) - GetSirCamOffSet(I));
End;

Function SirCamEncrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) + Length(St) + GetSirCamOffSet(I));
End;

Function APSirCamDecrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) - Length(St) - I - GetSirCamOffSet(I));
End;

Function APSirCamEncrypt(Const St: String): String;
Var
  I: Integer;
Begin
  Result := '';
  For I := 1 To Length(St) Do
    Result := Result + Chr(Ord(St[I]) + Length(St) + I + GetSirCamOffSet(I));
End;

End.
