{Version 1
 Datum 9.07.99}

unit AMHSysDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI;

type
  TSysDlg = (AppWiz, BDEAdmin, Desk, InetCPL, Intl, Joy, Main, MMSys, Modem,
          NetCPL, OBDCCP32, Password, PowerCfg, StiCPL, SysDm, Telephon, TimeDate);

  TAMHSysDlg = class(TComponent)
  private
    { Private-Deklarationen }
    fSysDlg : TSysDlg;
    fSysDlgStr: string;
    fPage: byte;
    procedure SetSysDlg(Value: TSysDlg);
    procedure SetPage(Value: byte);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: boolean;
  published
    { Published-Deklarationen }
    property Page: byte read fPage write SetPage;
    property SysDlg: TSysDlg read fSysDlg write SetSysDlg;
  end;

implementation

constructor TAMHSysDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fSysDlg := AppWiz;
  fPage := 0;
end;

destructor TAMHSysDlg.Destroy;
begin
  inherited Destroy;
end;

function TAMHSysDlg.Execute: boolean;
var
  Command: string;
begin
  if fPage = 0 then
     Command := ('rundll32.exe Shell32.dll,Control_RunDLL ' + fSysDlgStr)
  else
     Command := ('rundll32.exe Shell32.dll,Control_RunDLL ' + fSysDlgStr + ',,' + inttostr(fPage));
     WinExec(@Command[1], SW_ShowNormal);
end;

procedure TAMHSysDlg.SetSysDlg(Value: TSysDlg);
begin
  if Value <> fSysDlg then
     case Value of
          Appwiz: begin
                  fSysDlg := AppWiz;
                  fSysDlgStr := 'AppWiz.CPL';
                  end;
          BDEAdmin: begin
                    fSysDlg := BDEAdmin;
                    fSysDlgStr := 'BDEAdmin.CPL';
                    end;
          Desk: begin
                fSysDlg := Desk;
                fSysDlgStr := 'Desk.CPL';
                end;
          InetCPL: begin
                   fSysDlg := InetCPL;
                   fSysDlgStr := 'InetCPL.CPL';
                   end;
          Intl: begin
                fSysDlg := Intl;
                fSysDlgStr := 'Intl.CPL';
                end;
          Joy: begin
               fSysDlg := Joy;
               fSysDlgStr := 'Joy.CPL';
               end;
          Main: begin
                fSysDlg := Main;
                fSysDlgStr := 'Main.CPL';
          end;
          MMSys: begin
                 fSysDlg := MMSys;
                 fSysDlgStr := 'MMSys.CPL';
          end;
          Modem: begin
                 fSysDlg := Modem;
                 fSysDlgStr := 'Modem.CPL';
          end;
          NetCPL: begin
                  fSysDlg := NetCPL;
                  fSysDlgStr := 'NetCPL.CPL';
          end;
          OBDCCP32: begin
                    fSysDlg := OBDCCP32;
                    fSysDlgStr := 'OBDCCP32.CPL';
          end;
          Password: begin
                    fSysDlg := Password;
                    fSysDlgStr := 'Password.CPL';
          end;
          PowerCfg: begin
                    fSysDlg := PowerCfg;
                    fSysDlgStr := 'PowerCfg.CPL';
          end;
          StiCPL: begin
                  fSysDlg := StiCPL;
                  fSysDlgStr := 'StiCPL.CPL';
          end;
          SysDm: begin
                 fSysDlg := SysDm;
                 fSysDlgStr := 'SysDm.CPL';
          end;
          Telephon: begin
                    fSysDlg := Telephon;
                    fSysDlgStr := 'Telephon.CPL';
          end;
          TimeDate: begin
                    fSysDlg := TimeDate;
                    fSysDlgStr := 'TimeDate.CPL';
          end;
     end;
end;

procedure TAMHSysDlg.SetPage(Value: byte);
begin
  if Value <> fPage then begin
     if (Value < 0) or (Value > 10) then
        fPage := 0
     else
         fPage := Value;
  end;
end;

end.
