{Version 1
 Datum 9.7.99}

unit AMHFileOp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellAPI;

type
  TFileOp = (foCopy, foDelete, foMove, foRename);
  TFileOpFlag = (fofAllowUndo, fofConfirmMouse, fofFilesOnly,
    fofMultiDestFiles, fofNoConfirmation, fofNoConfirmMkDir,
    fofRenameOnCollision, fofSilent, fofSimpleProgress,
    fofWantMappingHandle);
  TFileOpFlags = set of TFileOpFlag;

  TAMHFileOp = class(TComponent)
  private
    { Private-Deklarationen }
    FOperation: TFileOp;
    FFrom: string;
    FTo: string;
    FFlags: TFileOpFlags;
    procedure SetFrom(Value: string);
    procedure SetTo(Value: string);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: boolean;
  published
    { Published-Deklarationen }
    property FilesFrom: string read FFrom write FFrom;
    property FilesTo: string read FTo write FTo;
    property Flags: TFileOpFlags read FFlags write FFlags;
    property Operation: TFileOp read FOperation write FOperation;
  end;

implementation

constructor TAMHFileOp.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TAMHFileOp.Destroy;
begin
  inherited Destroy;
end;

function TAMHFileOp.Execute: boolean;
const
  OperationToSH: array[TFileOp] of Integer =
    (FO_COPY, FO_DELETE, FO_MOVE, FO_RENAME);
  FileOpToSH: array[TFileOpFlag] of FILEOP_FLAGS =
    (FOF_ALLOWUNDO, FOF_CONFIRMMOUSE, FOF_FILESONLY,
     FOF_MULTIDESTFILES, FOF_NOCONFIRMATION, FOF_NOCONFIRMMKDIR,
     FOF_RENAMEONCOLLISION, FOF_SILENT, FOF_SIMPLEPROGRESS,
     FOF_WANTMAPPINGHANDLE);
var
  lpFileOp: TSHFileOpStruct;
  AFrom, ATo: string;
  Dummy: Integer;
begin
  with lpFileOp do begin
    if Owner is TForm then
       Wnd := TForm(Owner).Handle
    else
        Wnd := Application.Handle;
    wFunc := OperationToSH[FOperation];
    AFrom := FFrom + #0#0;
    for Dummy := 1 to Length(AFrom) do
        if AFrom[Dummy] = ';' then
           AFrom[Dummy] := #0;
    pFrom := PChar(AFrom);
    ATo   := FTo + #0#0;
    for Dummy := 1 to Length(ATo) do
        if ATo[Dummy] = ';' then
           ATo[Dummy] := #0;
    pTo   := PChar(ATo);
    fFlags := 0;
    if fofAllowUndo in Flags then
       fFlags := fFlags or FOF_ALLOWUNDO;
    if fofConfirmMouse in Flags then
       fFlags := fFlags or FOF_CONFIRMMOUSE;
    if fofFilesOnly in Flags then
       fFlags := fFlags or FOF_FILESONLY;
    if fofMultiDestFiles in Flags then
       fFlags := fFlags or FOF_MULTIDESTFILES;
    if fofNoConfirmation in Flags then
       fFlags := fFlags or FOF_NOCONFIRMATION;
    if fofNoConfirmMkDir in Flags then
       fFlags := fFlags or FOF_NOCONFIRMMKDIR;
    if fofRenameOnCollision in Flags then
       fFlags := fFlags or FOF_RENAMEONCOLLISION;
    if fofSilent in Flags then
       fFlags := fFlags or FOF_SILENT;
    if fofSimpleProgress in Flags then
       fFlags := fFlags or FOF_SIMPLEPROGRESS;
    if fofWantMappingHandle in Flags then
       fFlags := fFlags or FOF_WANTMAPPINGHANDLE;
  end;
  Result := not Boolean(SHFileOperation(lpFileOp));
end;

procedure TAMHFileOp.SetFrom(Value: string);
begin
  FFrom := ExpandFileName(Value)
end;

procedure TAMHFileOp.SetTo(Value: string);
begin
  FTo := ExpandFileName(Value)
end;

end.
