unit AMHFileCtrlRes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, FileCtrl;

type
  TAMHDirectoryListBox = class(TDirectoryListBox)
  protected
    procedure ReadBitmaps; override;
  end;

  TAMHDriveComboBox = class(TDriveComboBox)
  public
    constructor Create(AOwner: TComponent); override;
  end;

implementation

{$R AMHFile.RES}

procedure TAMHDirectoryListBox.ReadBitmaps;
begin
  ClosedBMP := TFolderBitmap.Create;
  ClosedBMP.Handle := LoadBitmap(HInstance, 'AMHCLOSEDFOLDER');
  CurrentBMP := TFolderBitmap.Create;
  CurrentBMP.Handle := LoadBitmap(HInstance, 'AMHCURRENTFOLDER');
  OpenedBMP := TFolderBitmap.Create;
  OpenedBMP.Handle := LoadBitmap(HInstance, 'AMHOPENFOLDER');
end;

constructor TAMHDriveComboBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  CDROMBMP.Free;
  CDROMBMP := TBitmap.Create;
  CDROMBMP.Handle := LoadBitmap(HInstance, 'AMHCDROM');
  FloppyBMP.Free;
  FloppyBMP := TBitmap.Create;
  FloppyBMP.Handle := LoadBitmap(HInstance, 'AMHFLOPPY');
  FixedBMP.Free;
  FixedBMP := TBitmap.Create;
  FixedBMP.Handle := LoadBitmap(HInstance, 'AMHHARD');
  NetworkBMP.Free;
  NetworkBMP := TBitmap.Create;
  NetworkBMP.Handle := LoadBitmap(HInstance, 'AMHNETWORK');
  Perform(CM_FONTCHANGED, 0, 0);
end;

end.
