unit Aligrid;

{ (c) 1995/96 Andreas Hrstemeier  }
{ Version 1.2     1996-12-14       }
{ this component is public domain  }
{ please check the file readme.txt }
{ for more detailed info on usage  }
{ and distributing                 }

(*@/// interface *)
interface

(*@/// uses *)
uses
  SysUtils,
  WinTypes,
  WinProcs,
  Messages,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Grids;
(*@\\\0000000B03*)

type TMyAlign=(alRight,alLeft,alCenter);

(*@/// TStringAlignGrid=class(TStringGrid) *)
TStringAlignGrid = class(TStringGrid)
private
  FHintPos: TPoint;

  FAlign: TMyAlign;
  FAlignCol: TList;
  FFAlignCol: TList;
  FAlignCell: TList;

  FHintCell: TList;

  function GetItemCell(ACol,ARow: Integer; List:TList):Pointer;
  function SetItemCell(ACol,ARow: Integer; List:TList; value:Pointer):pointer;

  function GetItemCol(ACol: Integer; List:TList):Pointer;
  function SetItemCol(ACol: Integer; List:TList; value:Pointer):pointer;

  function GetAlign: TMyAlign;
  procedure SetAlign(const Value: TMyAlign);
  function GetAlignCol(ACol: integer):TMyAlign;
  procedure SetAlignCol(ACol: integer; const Value: TMyAlign);
  function GetFixAlignCol(ACol: integer):TMyAlign;
  procedure SetFixAlignCol(ACol: integer; const Value: TMyAlign);
  function GetAlignCell(ACol,ARow: integer):TMyAlign;
  procedure SetAlignCell(ACol,ARow: integer; const Value: TMyAlign);
  function GetHintCell(ACol,ARow: integer):string;
  procedure SetHintCell(ACol,ARow: integer; const Value: string);
  procedure Initialize;
protected
  procedure DrawCell(ACol,ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
  procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  procedure ShowHintCell(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
public
  constructor Create(AOwner: TComponent); override;
  destructor Destroy; override;
  property AlignCell[ACol,ARow:integer]: TMyAlign read GetAlignCell write SetAlignCell;
  property AlignCol[ACol:integer]: TMyAlign read GetAlignCol write SetAlignCol;
  property FixAlignCol[ACol:integer]: TMyAlign read GetFixAlignCol write SetFixAlignCol;
  property HintCell[ACol,ARow:integer]:string read GetHintCell write SetHintCell;
  procedure ResetAlignCell(ACol,ARow:integer);
  procedure ResetAlignCol(ACol:integer);
  procedure ResetFAlignCol(ACol:integer);
  procedure ResetAlignment;
published
  property Alignment: TMyAlign read GetAlign write SetAlign default alLeft;
end;
(*@\\\0000002001*)

procedure AddToShowHint(grid: TStringAlignGrid);
procedure RemoveFromShowHint(grid: TStringAlignGrid);

procedure Register;
(*@\\\0000000701*)
(*@/// implementation *)
implementation

(*@/// TStringAlignGrid = class(TStringGrid) *)
(*@/// function TStringAlignGrid.GetItemCell(ACol,ARow: Integer; List:TList):Pointer; *)
function TStringAlignGrid.GetItemCell(ACol,ARow: Integer; List:TList):Pointer;
var
  sublist: TList;
begin
  if ACol+1 > List.Count then
    GetItemCell:=NIL
  else
    if List.Items[ACol] = NIL then
      GetItemCell:=NIL
    else begin
      sublist:=TList(List.Items[ACol]);
      if ARow+1 > sublist.Count then
        GetItemCell:=NIL
      else
        GetItemCell:=sublist.Items[ARow]
    end;
  end;
(*@\\\0000001001*)
(*@/// function TStringAlignGrid.SetItemCell(ACol,ARow: Integer; List:TList; value:Pointer):pointer; *)
function TStringAlignGrid.SetItemCell(ACol,ARow: Integer; List:TList; value:Pointer):pointer;
(* give back the pointer to the previously stored element to let the caller dispose it *)
var
  i:integer;
  t:pointer;
  sublist:TList;
begin
  t:=NIL;
  if ACol+1 > List.Count then
    for i:=List.Count to ACol do
      List.Add(NIL);
  if List.Items[ACol] = NIL then
    List.Items[ACol]:=TList.Create;
  sublist:=TList(List.Items[ACol]);
  if ARow+1 > sublist.Count then
    for i:=sublist.Count to ARow do
      sublist.Add(NIL);
  if sublist.items[ARow] <> NIL then begin
    t:=sublist.items[ARow];
{     FreeMem(t,size); }
    sublist.Items[ARow]:=value;
    end
  else
    sublist.Items[ARow]:=value;
  SetItemCell:=t;
  end;
(*@\\\0000000201*)

(*@/// function TStringAlignGrid.GetItemCol(ACol: Integer; List:TList):Pointer; *)
function TStringAlignGrid.GetItemCol(ACol: Integer; List:TList):Pointer;
begin
  if ACol+1 > List.Count then
    GetItemCol:=NIL
  else
    if List.Items[ACol] = NIL then
      GetItemCol:=NIL
    else begin
      GetItemCol:=List.Items[ACol];
      end;
  end;
(*@\\\0000000901*)
(*@/// function TStringAlignGrid.SetItemCol(ACol: Integer; List:TList; value:Pointer):pointer; *)
function TStringAlignGrid.SetItemCol(ACol: Integer; List:TList; value:Pointer):pointer;
var
  i:integer;
  t:pointer;
begin
  t:=NIL;
  if ACol+1 > List.Count then
    for i:=List.Count to ACol do
      List.Add(NIL);
  if List.Items[ACol] <> NIL then begin
    t:=List.Items[ACol];
{     FreeMem(List.Items[ACol],size); }
    List.Items[ACol]:=value;
    end
  else
    List.Items[ACol]:=value;
  SetItemCol:=t;
  end;
(*@\\\0000000158*)

(*@/// function TStringAlignGrid.GetAlignCol(ACol:Integer):TMyAlign; *)
function TStringAlignGrid.GetAlignCol(ACol:Integer):TMyAlign;
var
  v:^tmyalign;
begin
  v:=GetItemCol(ACol, FAlignCol);
  if v=NIL then
    GetAlignCol:=Alignment
  else
    GetAlignCol:=v^;
  end;
(*@\\\0000000914*)
(*@/// procedure TStringAlignGrid.SetAlignCol(ACol:integer; const Value: TMyAlign); *)
procedure TStringAlignGrid.SetAlignCol(ACol:integer; const Value: TMyAlign);
var
  v:^tmyalign;
begin
  New(v);
  v^:=value;
  v:=SetItemCol(ACol, FAlignCol, v);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000501*)
(*@/// function TStringAlignGrid.GetFixAlignCol(ACol:Integer):TMyAlign; *)
function TStringAlignGrid.GetFixAlignCol(ACol:Integer):TMyAlign;
var
  v:^tmyalign;
begin
  v:=GetItemCol(ACol, FFAlignCol);
  if v=NIL then
    GetFixAlignCol:=Alignment
  else
    GetFixAlignCol:=v^;
  end;
(*@\\\0000000917*)
(*@/// procedure TStringAlignGrid.SetFixAlignCol(ACol:integer; const Value: TMyAlign); *)
procedure TStringAlignGrid.SetFixAlignCol(ACol:integer; const Value: TMyAlign);
var
  v:^tmyalign;
begin
  New(v);
  v^:=value;
  v:=SetItemCol(ACol, FFAlignCol, v);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000B01*)
(*@/// function TStringAlignGrid.GetAlignCell(ACol,ARow:Integer):TMyAlign; *)
function TStringAlignGrid.GetAlignCell(ACol,ARow:Integer):TMyAlign;
(*@/// function AnyAlignCol(ACol:integer):TMyAlign; *)
function AnyAlignCol(ACol:integer):TMyAlign;
begin
  if ARow >= FixedRows then
    AnyAlignCol:=AlignCol[ACol]
  else
    AnyAlignCol:=FixAlignCol[ACol];
  end;
(*@\\\0000000401*)
var
  v:^tmyalign;
begin
  v:=GetItemCell(ACol,ARow,FAlignCell);
  if v=NIL then
    GetAlignCell:=AnyAlignCol(ACol)
  else
    GetAlignCell:=v^;
  end;
(*@\\\0000000215*)
(*@/// procedure TStringAlignGrid.SetAlignCell(ACol,ARow:integer; const Value: TMyAlign); *)
procedure TStringAlignGrid.SetAlignCell(ACol,ARow:integer; const Value: TMyAlign);
var
  v:^tmyalign;
begin
  New(v);
  v^:=value;
  v:=SetItemCell(ACol,ARow, FAlignCell, v);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000301*)

(*@/// function TStringAlignGrid.GetAlign: TMyAlign; *)
function TStringAlignGrid.GetAlign: TMyAlign;
begin
  GetAlign:=FAlign;
  end;
(*@\\\000000010B*)
(*@/// procedure TStringAlignGrid.SetAlign(const Value: TMyAlign); *)
procedure TStringAlignGrid.SetAlign(const Value: TMyAlign);
begin
  FAlign:=Value;
  Invalidate;
  end;
(*@\\\000000030B*)

(*@/// procedure TStringAlignGrid.ResetAlignCell(ACol,ARow:integer); *)
procedure TStringAlignGrid.ResetAlignCell(ACol,ARow:integer);
var
  v:^tmyalign;
begin
  v:=SetItemCell(ACol,ARow, FAlignCell, NIL);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000401*)
(*@/// procedure TStringAlignGrid.ResetAlignCol(ACol:integer); *)
procedure TStringAlignGrid.ResetAlignCol(ACol:integer);
var
  v:^tmyalign;
begin
  v:=SetItemCol(ACol, FAlignCol, NIL);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000401*)
(*@/// procedure TStringAlignGrid.ResetFAlignCol(ACol:integer); *)
procedure TStringAlignGrid.ResetFAlignCol(ACol:integer);
var
  v:^tmyalign;
begin
  v:=SetItemCol(ACol, FFAlignCol, NIL);
  if v<>NIL then
    dispose(v);
  Invalidate;
  end;
(*@\\\0000000401*)
(*@/// procedure TStringAlignGrid.ResetAlignment; *)
procedure TStringAlignGrid.ResetAlignment;
begin
  FAlign:=alLeft;
  Invalidate;
  end;
(*@\\\0000000301*)

(*@/// function TStringAlignGrid.GetHintCell(ACol,ARow: integer):string; *)
function TStringAlignGrid.GetHintCell(ACol,ARow: integer):string;
var
  v:pstring;
begin
  v:=GetItemCell(ACol,ARow,FHintCell);
  if v=NIL then
    GetHintCell:=''
  else
    GetHintCell:=v^;
  end;
(*@\\\0000000714*)
(*@/// procedure TStringAlignGrid.SetHintCell(ACol,ARow: integer; const Value: string); *)
procedure TStringAlignGrid.SetHintCell(ACol,ARow: integer; const Value: string);
var
  v:pstring;
begin
  v:=NewStr(value);
  v:=SetItemCell(ACol,ARow, FHintCell, v);
  if v<>NIL then
    DisposeStr(v);
  end;
(*@\\\0000000901*)

(*@/// constructor TStringAlignGrid.Create(AOwner: TComponent); *)
constructor TStringAlignGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Initialize;
  end;
(*@\\\*)
(*@/// destructor TStringAlignGrid.Destroy; *)
destructor TStringAlignGrid.Destroy;
(*@/// procedure cleanlist(List:TList; size:integer); *)
procedure cleanlist(List:TList; size:integer);
var
  i:integer;
begin
  if list<>NIL then begin
    for i:=0 to List.Count-1 do
      if List.Items[i] <> NIL then
        Freemem(List.Items[i],size);
    end;
    list.Free;
    list:=NIL;
  end;
(*@\\\0000000B0F*)
(*@/// procedure cleanlist_pstring(List:TList); *)
procedure cleanlist_pstring(List:TList);
var
  i:integer;
begin
  if list<>NIL then begin
    for i:=0 to List.Count-1 do
      if List.Items[i] <> NIL then
        DisposeStr(List.Items[i]);
    end;
    list.Free;
    list:=NIL;
  end;
(*@\\\0000000C01*)
var
  i,j:integer;
begin
  cleanlist(FAlignCol,sizeof(TMyAlign));
  cleanlist(FFAlignCol,sizeof(TMyAlign));
  for i:=0 to FAlignCell.Count-1 do
    cleanlist(TList(FAlignCell.Items[i]),sizeof(TMyAlign));
  FAlignCell.Free;
  FAlignCell:=NIL;
  for i:=0 to FHintCell.Count-1 do
    cleanlist_pstring(TList(FHintCell.Items[i]));
  FHintCell.Free;
  FHintCell:=NIL;
  RemoveFromShowHint(self);
  inherited Destroy;
  end;
(*@\\\0000001101*)
(*@/// procedure TStringAlignGrid.Initialize; *)
procedure TStringAlignGrid.Initialize;
begin
  FAlignCol:=TList.Create;
  FFAlignCol:=TList.Create;
  FAlignCell:=TList.Create;
  FHintCell:=TList.Create;
  FAlign:=alLeft;
  AddToShowHint(self);
  end;
(*@\\\0000000515*)
(*@/// procedure TStringAlignGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; *)
procedure TStringAlignGrid.DrawCell(ACol, ARow: Longint; ARect: TRect;
  AState: TGridDrawState);
(*@/// procedure DrawCellText; *)
procedure DrawCellText;
var
  Text:array[0..255] of char;
  l:integer;
  Left:integer;
  AlignValue:TMyAlign;
begin
  StrPCopy(Text, Cells[ACol, ARow]);
  l:=Canvas.TextWidth(Cells[ACol, ARow]);

{ if nothing is set use left bounding }
  Left:=ARect.Left;

  AlignValue:=AlignCell[ACol,ARow];

  if AlignValue in [alCenter] then begin
    l:=( (Arect.Right-ARect.Left)-l ) div 2;
    Left:=ARect.Left+l-1;
    end;
  if AlignValue in [alRight] then
    Left:=ARect.Right-l-4;

  ExtTextOut(Canvas.Handle, Left+2, Arect.Top+2,  ETO_CLIPPED or
    ETO_OPAQUE, @Arect, Text, StrLen(Text), nil);
  end;
(*@\\\*)
begin
  if DefaultDrawing then
    DrawCellText
  else
    inherited DrawCell(ACol, ARow, ARect, AState);
  end;
(*@\\\0000000301*)

(*@/// procedure TStringAlignGrid.ShowHintCell(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo); *)
procedure TStringAlignGrid.ShowHintCell(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
var
  col,row:longint;
  HintPos:TRect;
begin
{   if @FOldOnHint<>NIL then }
{     FOldOnHint(HintStr, CanShow, HintInfo); }
  if hintinfo.hintcontrol=self then begin
    fhintpos:=hintinfo.cursorpos;
    self.mousetocell(hintinfo.cursorpos.x,hintinfo.cursorpos.y,col,row);
    hintpos:=self.Cellrect(col,row);
    hintinfo.hintpos.x:=hintpos.left;
    hintinfo.hintpos.y:=hintpos.bottom+6;
    hintinfo.hintpos:=self.clienttoscreen(hintinfo.hintpos);
    hintstr:=HintCell[col,row];
    end;
  end;
(*@\\\*)
(*@/// procedure TStringAlignGrid.MouseMove(Shift: TShiftState; X, Y: Integer); *)
procedure TStringAlignGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  col1,col2,row1,row2: longint;
begin
  self.mousetocell(fhintpos.x,fhintpos.y,col1,row1);
  self.mousetocell(x,y,col2,row2);
  if (col1<>col2) or (row1<>row2) then
    Application.CancelHint;
  inherited MouseMove(Shift, X, Y);
  end;
(*@\\\0000000727*)
(*@\\\0000001B01*)

var
  ShowHintProcs: TList;

(*@/// TDummyObject = class(TObject) *)
type
  TDummyObject=class(TObject)
  procedure ShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
  end;
(*@/// procedure TDummyObject.ShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo); *)
procedure TDummyObject.ShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
var
  i:integer;
begin
  for i:=0 to ShowHintProcs.Count-1 do
    if ShowHintProcs.Items[i]<>NIL then begin
      TStringAlignGrid(ShowHintProcs.Items[i]).ShowHintCell(HintStr,CanShow,HintInfo);
      end;
  end;
(*@\\\0000000701*)
(*@\\\0000000501*)

var
  Dummy: TDummyObject;

(*@/// procedure AddToShowHint(grid: TStringAlignGrid); *)
procedure AddToShowHint(grid: TStringAlignGrid);
begin
  if ShowHintProcs.Count=0 then
    Application.OnShowHint:=Dummy.ShowHint;
  ShowHintProcs.Add(grid);
  end;
(*@\\\0000000301*)
(*@/// procedure RemoveFromShowHint(grid: TStringAlignGrid); *)
procedure RemoveFromShowHint(grid: TStringAlignGrid);
begin
  ShowHintProcs.Remove(grid);
  ShowHintProcs.Pack;
  end;
(*@\\\0000000401*)

(*@/// procedure Register; *)
procedure Register;
begin
  RegisterComponents('Custom', [TStringAlignGrid]);
  end;
(*@\\\0000000403*)

(*@/// procedure DoneUnit; far; *)
procedure DoneUnit; far;                (* Delphi2: finalization *)
begin
  ShowHintProcs.Free;
  ShowHintProcs:=NIL;
  Dummy.Free;
  Dummy:=NIL;
  end;
(*@\\\000000050E*)
(*@\\\0030001001000F01000D01*)

begin
  Dummy:=TDummyObject.Create;
  ShowHintProcs:=TList.Create;
  AddExitProc(DoneUnit);
  end.
(*@\\\000F000D01000D01000B01000011000B01*)
