unit Ufrmprog;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Gauges, uDBConv;

type
  TfrmProgress = class(TForm)
    ProgressGauge: TGauge;
    StatusLabel: TLabel;
    bbStop: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bbStopClick(Sender: TObject);
  private
    { Private declarations }
    fDBConverter : TDBConverter;
  public
    { Public declarations }
    constructor CreateForDBConversion(aDBConverter : TDBConverter);
  end;

var
  frmProgress: TfrmProgress;

implementation

{$R *.DFM}

constructor TfrmProgress.CreateForDBConversion(aDBConverter : TDBConverter);
begin
  inherited Create(NIL);

  fDBConverter               := aDBConverter;
  fDBConverter.ProgressGauge := ProgressGauge;
  fDBConverter.StatusLabel   := StatusLabel;
end;

procedure TfrmProgress.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfrmProgress.bbStopClick(Sender: TObject);
begin
  fDBConverter.Stop := TRUE;
  Close;
end;

end.
