unit Ufrmmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, Buttons, Udbconv, ExtCtrls,
  RXCtrls, Gauges, UfrmProg, FileCtrl;

type
  TfrmMain = class(TForm)
    cbSourceAlias: TComboBox;
    Label1: TLabel;
    cbDestinationAlias: TComboBox;
    Label2: TLabel;
    mSource: TMemo;
    mDestination: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    Panel1: TPanel;
    bbConvert: TBitBtn;
    Label5: TLabel;
    clIncludedTables: TRxCheckListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    Label6: TLabel;
    cbStrictIndexConvertion: TCheckBox;
    Edit1: TEdit;
    Label7: TLabel;
    DBConverter: TDBConverter;
    procedure FormCreate(Sender: TObject);
    procedure cbSourceAliasChange(Sender: TObject);
    procedure cbDestinationAliasChange(Sender: TObject);
    procedure bbConvertClick(Sender: TObject);
    procedure cbStrictIndexConvertionClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Session.GetAliasNames(cbSourceAlias.Items);
  cbDestinationAlias.Items.AddStrings(cbSourceAlias.Items);
end;

procedure TfrmMain.cbSourceAliasChange(Sender: TObject);
var n : integer;
begin
  Session.GetAliasParams(cbSourceAlias.Text, mSource.Lines);
  DBConverter.SourceAlias := cbSourceAlias.Text;

  { Selects the tables to export - Default all }
  clIncludedTables.Items.Clear;
  clIncludedTables.Items.AddStrings(DBConverter.TablesToConvert);
  for n := 0 to (clIncludedTables.Items.Count-1)
    do clIncludedTables.Checked[n] := TRUE;
end;

procedure TfrmMain.cbDestinationAliasChange(Sender: TObject);
begin
  Session.GetAliasParams(cbDestinationAlias.Text, mDestination.Lines);
  DBConverter.DestinationAlias := cbDestinationAlias.Text;
end;

procedure TfrmMain.bbConvertClick(Sender: TObject);
var n      : integer;
    result : integer;
    msg    : PChar;
begin
  { Eliminates the tables the user doesn't want to conver from the list  }
  DBConverter.TablesToConvert.Clear;
  for n := 0 to (clIncludedTables.Items.Count-1)
    do if clIncludedTables.Checked[n] then DBConverter.TablesToConvert.Add(clIncludedTables.Items[n]);

  with TfrmProgress.CreateForDBConversion(DBConverter) do
    try
      Show;
      result := DBConverter.Execute;
    finally
      if Visible then Close;
    end;

  if (result=0)
    then Application.MessageBox( 'Migration succesfully completed.',
                                 'Information',
                                 MB_ICONINFORMATION + MB_OK)

    else Application.MessageBox( 'Errors encountered.',
                                 'Information',
                                 MB_ICONSTOP + MB_OK);

end;

procedure TfrmMain.cbStrictIndexConvertionClick(Sender: TObject);
begin
  DBConverter.StrictIndexConvertion := cbStrictIndexConvertion.Checked;
end;

procedure TfrmMain.Edit1Change(Sender: TObject);
begin
  DBConverter.ResultFile := Edit1.Text;
end;

end.
