unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls,Dialogs,
  Buttons;

type
  TForm2 = class(TForm)
    ScrollBox: TScrollBox;
    Label1: TLabel;
    EditMFR: TDBEdit;
    Label2: TLabel;
    EditDESCRIPT: TDBEdit;
    Label3: TLabel;
    EditDMODIF: TDBEdit;
    Label4: TLabel;
    EditDCREATE: TDBEdit;
    Label5: TLabel;
    EditCREATEBY: TDBEdit;
    Label6: TLabel;
    EditMODIFBY: TDBEdit;
    DataSource1: TDataSource;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Bevel1: TBevel;
    Table1: TTable;
    Table1MFR: TStringField;
    Table1DESCRIPT: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Table1MFRValidate(Sender: TField);
    procedure Table1BeforePost(DataSet: TDataset);
  private
    { private declarations }
  public
    { public declarations }
    function ShowInsert: Boolean;
  end;

var
  Form2: TForm2;
  bolChanged: Boolean;

implementation

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
begin
  {Table1.Open;}
  bolChanged := False;
end;

function TForm2.ShowInsert: Boolean;
begin
     ShowModal;
     if Table1.State in [dsInsert,dsInsert] then begin
        if (EditDescript.Text = '') or (EditMfr.Text = '') then begin
           Table1.Cancel;
           MessageDlg('Insert Cancelled.', mtInformation, [mbOK], 0);
           end
        else begin
             if MessageDlg('Save New Manufacturer?',    mtInformation, [mbYes, mbNo], 0) = mrYes then begin
                Table1.Post;
                bolChanged := True;
             end
             else
                Table1.Cancel;
        end;
     end;

     Result := bolChanged;

end;


procedure TForm2.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     {Check to see the state of Table1}

end;

procedure TForm2.BitBtn1Click(Sender: TObject);
begin
     if (EditDescript.Text = '') or (EditMfr.Text = '') then begin
        if not (MessageDlg('Information Missing... Continue Editing??',    mtInformation, [mbYes, mbNo], 0) = mrYes) then begin
                Table1.Cancel;
                bolChanged := False;
                MessageDlg('Insert Cancelled.', mtInformation, [mbOK], 0);
                close;
        end
        else  EditMfr.SetFocus;
     end
     else begin
          Table1.Post;
          bolChanged := True;
          close;
     end;
end;

procedure TForm2.BitBtn2Click(Sender: TObject);
begin
     Table1.Cancel;
     close;
end;

procedure TForm2.Table1MFRValidate(Sender: TField);
begin
     if Table1MFR.Text = '' then begin
        MessageDlg('Manufacturer cannot be empty.', mtWarning, [mbOK], 0 );
        EditMfr.SetFocus;
     end
     else
         MessageDlg('MFR OK', mtInformation, [mbOK], 0 );
end;

procedure TForm2.Table1BeforePost(DataSet: TDataset);
begin
     Table1MFRValidate( Table1MFR );
end;

end.