unit Test1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, StdCtrls, DBLookup, Mlkdcomb, Mask, DBCtrls,
  ExtCtrls, Buttons, ADBLkup;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Label1: TLabel;
    Shape1: TShape;
    BitBtn1: TBitBtn;
    Memo1: TMemo;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Shape6: TShape;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label6: TLabel;
    ComboBox4: TComboBox;
    BitBtn2: TBitBtn;
    MDBLCombo1: TADBLkupCombo;
    Edit1: TEdit;
    Label7: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure MDBLCombo1Search(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ResetEm;
    procedure ComboBox4Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure MDBLCombo1InsertClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  bolSearch: Boolean;
  BookMark: TBookMark;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
     Table1.DatabaseName := ExtractFilePath( Application.ExeName );
     Table1.Open;
     {Apollo1.setorder(1);}
     {if not FileExists('MANUF4.MDX') then
        Table1.AddIndex('MFR','MFR',[]);}
     bolSearch := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Table1.Close;
end;

procedure TForm1.MDBLCombo1Search(Sender: TObject);
var
   iRec: Integer;
begin
     {iRec := Apollo1.recno;
     if not Apollo1.seek(MDBLCombo1.Text) then Apollo1.go(iRec);}
     if BookMark = nil then
        BookMark := Table1.GetBookMark;
     Table1.IndexName := 'MFR';
     Table1.SetKey;
     Table1.Fields[0].AsString := MDBLCombo1.Text;
     Table1.FindNearest([MDBLCombo1.Text]) {then}
        {raise Exception.CreateFmt('Cannot find Key %s', [MDBLCombo1.Text]);}
     {if BookMark <> nil then begin
        Table1.FreeBookMark(BookMark);
        BookMark := nil;
     end;}

end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     Table1.Close;
     Close;
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
     if ComboBox3.Text='ON' then begin
        MDBLCombo1.SpeedSearch := True;
        bolSearch := True;
     end
     else begin
          MDBLCombo1.SpeedSearch := False;
          bolSearch := False;
     end;
     ResetEm;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
     if ComboBox2.Text = 'dtEditKey' then
        MDBLCombo1.DropTrigger := dtEditKey;
     if ComboBox2.Text = 'dtDefault' then
        MDBLCombo1.DropTrigger := dtDefault;
     if ComboBox2.Text = 'dtEditAndValid' then
        MDBLCombo1.DropTrigger := dtEditAndValid;
     if ComboBox2.Text = 'dtValidOnExit' then
        MDBLCombo1.DropTrigger := dtValidOnExit;
     ResetEm;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
     if ComboBox1.Text = 'ecNormal' then
        MDBLCombo1.CharCase := ecNormal;
     if ComboBox1.Text = 'ecLowerCase' then
        MDBLCombo1.CharCase := ecLowerCase;
     if ComboBox1.Text = 'ecUpperCase' then
        MDBLCombo1.CharCase := ecUpperCase;
     ResetEm;
end;

procedure TForm1.ResetEm;
begin
     MDBLCombo1.Text := '';
     MDBLCombo1.SetFocus;
     {Apollo1.gotop;}
end;

procedure TForm1.ComboBox4Change(Sender: TObject);
begin
     if ComboBox4.Text = 'False' then
        MDBLCombo1.ExitOnEnter := False
     else MDBLCombo1.ExitOnEnter := True;
     Resetem;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     ResetEm;
end;

procedure TForm1.MDBLCombo1InsertClick(Sender: TObject);
var
   InsForm: TForm2;
   iRec: Integer;
begin
     {iRec := Apollo1.recno;}
     InsForm := TForm2.Create(Application);
     InsForm.Table1 := Table1;
     InsForm.DataSource1.DataSet := Table1;;
     {InsForm.Apollo1.DataSource := DataSource1;}
     Table1.Insert;
     Table1.FieldByName('CreateBy').AsString := 'TSD LTD';
     Table1.FieldByName('MODIFBY').AsString := 'TSD LTD';
     Table1.FieldByName('DCreate').AsString :=  DateToStr(Date);
     Table1.FieldByName('DModif').AsString := DateToStr(Date);
     InsForm.ShowInsert;
     {if not InsForm.ShowInsert then Apollo1.go(iRec);}
     InsForm.Free;
end;

end.
