unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, AbPrtTrd, AbTrend, ComCtrls, Tabnotbk, Printers, StdCtrls,
  _AbFlash, AbFlashT, _AbProc, unit2, Spin;

type
  TForm1 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    AbTrend1: TAbTrend;
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    Button1: TButton;
    PrintDialog1: TPrintDialog;
    SaveDialog1: TSaveDialog;
    PaintBox1: TPaintBox;
    AbPrintTrend2: TAbPrintTrend;
    Button3: TButton;
    AbPrintTrend1: TAbPrintTrend;
    CheckBox1: TCheckBox;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label2: TLabel;
    Bevel4: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    Label5: TLabel;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
{draws 2 trends on a "Portrait" paper (A4-size) }
begin
   if PrintDialog1.Execute then begin
     Printer.Title := AbPrintTrend1.Name + ' - ' + AbPrintTrend1.Trend.Caption;
     Printer.Orientation :=  poPortrait	;
     printer.BeginDoc;
     AbPrintTrend1.ExPrintTrend(150,100);
     {set trend to a trend on another form}
     AbPrintTrend1.Trend := form2.AbTrend1;
     AbPrintTrend1.ExPrintTrend(150,1500);
     AbPrintTrend1.Trend := AbTrend1;  {set preview back to trend 1}
     printer.EndDoc;
   end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
{draws a trend on a "Landscape" paper (A4-size) }
   if PrintDialog1.Execute then begin
     Printer.Orientation :=  poLandscape;
     AbPrintTrend2.PrintTrend(10,50);
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
{draws a trend on a bitmap, save to file}
var
   Bmp : TBitmap;
begin
   try
     {create a bitmap}
     Bmp := TBitmap.Create;

     {sets Bmp size and draws the trend }

      if RadioButton1.Checked then
         AbPrintTrend1.DrawTrendBmp(Bmp)
      else
         AbPrintTrend2.DrawTrendBmp(Bmp);

     {save to file}
     SaveDialog1.InitialDir := ExtractFilePath(Application.ExeName);
     SaveDialog1.DefaultExt := GraphicExtension(TBitmap);
     SaveDialog1.FileName := 'Test.bmp';
     if SaveDialog1.Execute then begin
        Bmp.SaveToFile(SaveDialog1.Filename);
     end;

   finally
     Bmp.Free;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   AbTrend1.LoadFromFile('test.trd');
   SpinEdit1.Value := round(AbPrintTrend2.PreviewZoom * 100);
   SpinEdit2.MaxValue := AbTrend1.RecordInfo.TotalRecords;
   SpinEdit3.MaxValue := AbTrend1.RecordInfo.TotalRecords;
   SpinEdit2.Value := 78;
   SpinEdit3.Value := 477;
   SpinEdit2Change(self);
   SpinEdit3Change(self);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   if CheckBox1.checked then begin
     AbPrintTrend1.Options := [ptCaption, ptLegend, ptColor, ptVerticalScale];
     AbPrintTrend2.Options := [ptCaption, ptLegend, ptColor, ptVerticalScale];
   end else begin
     AbPrintTrend1.Options := [ptCaption, ptLegend, ptVerticalScale];
     AbPrintTrend2.Options := [ptCaption, ptLegend, ptVerticalScale];
   end;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
   if SpinEdit1.Value >= 10 then
      if RadioButton1.Checked then
         AbPrintTrend1.PreviewZoom := SpinEdit1.Value / 100
      else
         AbPrintTrend2.PreviewZoom := SpinEdit1.Value / 100;
end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
   AbPrintTrend1.PreviewPaintBox := nil;
   AbPrintTrend2.PreviewPaintBox := PaintBox1;
   SpinEdit1.Value := round(AbPrintTrend2.PreviewZoom * 100);
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
   AbPrintTrend2.PreviewPaintBox := nil;
   AbPrintTrend1.PreviewPaintBox := PaintBox1;
   SpinEdit1.Value := round(AbPrintTrend1.PreviewZoom * 100);
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
var
 t: TDateTime;
begin
  SpinEdit2.MaxValue := SpinEdit3.Value;
  AbTrend1.ReadRecTime(SpinEdit3.Value,t);
  Label6.caption := DateTimeToStr(t);
  AbPrintTrend1.RecTo := SpinEdit3.Value;
  AbPrintTrend2.RecTo := SpinEdit3.Value;

end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
var
 t: TDateTime;
begin
  SpinEdit3.MinValue := SpinEdit2.Value;
  AbTrend1.ReadRecTime(SpinEdit2.Value,t);
  Label5.caption := DateTimeToStr(t);
  AbPrintTrend1.RecFrom := SpinEdit2.Value;
  AbPrintTrend2.RecFrom := SpinEdit2.Value;
end;

end.
