unit Unit19;

interface

uses
  {$IFDEF WIN32}
     Windows,
  {$ELSE}
     WinTypes,
     WinProcs,
  {$ENDIF}
 Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, _AnlgGC, AbVMeter, _BinGC, AbLED;

type
  TAnalogIndEventsForm = class(TForm)
    GroupBox1: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    Button1: TButton;
    AbVMeter5: TAbVMeter;
    GroupBox2: TGroupBox;
    GroupBox4: TGroupBox;
    Label2: TLabel;
    GroupBox3: TGroupBox;
    Label14: TLabel;
    Memo1: TMemo;
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    ScrollBar1: TScrollBar;
    GroupBox5: TGroupBox;
    AbLED1: TAbLED;
    AbLED2: TAbLED;
    AbLED3: TAbLED;
    AbLED4: TAbLED;
    AbLED5: TAbLED;
    AbLED6: TAbLED;
    procedure AbVMeter5MinMaxChange(Sender: TObject);
    procedure AbVMeter5Overflow(Sender: TObject; PPT: Integer);
    procedure AbVMeter5SectorChange(Sender: TObject; Sector1, Sector2,
      Sector3, Enter: Boolean);
    procedure AbVMeter5ValueChange(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AbVMeter5Limit(Sender: TObject; Lower, Upper: Boolean);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

procedure TAnalogIndEventsForm.AbVMeter5MinMaxChange(Sender: TObject);
var
   MinStr, MaxStr : String;
begin
   With AbVMeter5 do begin
      MaxStr := 'Max : '+
                FormatFloat(SignalSettings.ValueFormat,MinMax.Max) +
                ' ' + SignalSettings.ValueUnit +
                ' , ' +
                DateTimeToStr(MinMax.MaxDateTime);

      MinStr := 'Min : '+
                FormatFloat(SignalSettings.ValueFormat,MinMax.Min) +
                ' ' + SignalSettings.ValueUnit +
                ' , ' +
                DateTimeToStr(MinMax.MinDateTime);

      Label12.caption := MaxStr;
      Label13.caption := MinStr;

   end;
end;

procedure TAnalogIndEventsForm.AbVMeter5Overflow(Sender: TObject;
  PPT: Integer);
begin
   case PPT of
      0..1000    : Label2.caption := 'Value Normal';
      -100..-1   : Label2.caption := 'Value to Low';
      1001..1100 : Label2.caption := 'Value to High';
   end;
end;

procedure TAnalogIndEventsForm.AbVMeter5SectorChange(Sender: TObject;
  Sector1, Sector2, Sector3, Enter: Boolean);
begin
   if Enter then begin
      If Sector1 then AbLED3.checked := true
      else If Sector2 then AbLED4.checked := true
      else If Sector3 then AbLED5.checked := true;
   end else AbLED6.checked := true;
end;

procedure TAnalogIndEventsForm.AbVMeter5ValueChange(Sender: TObject);
begin
   Label14.caption := AbVMeter5.ValueStr;
end;

procedure TAnalogIndEventsForm.ScrollBar1Change(Sender: TObject);
begin
   AbVMeter5.digit := ScrollBar1.position;
end;

procedure TAnalogIndEventsForm.Button1Click(Sender: TObject);
begin
   AbVMeter5.ResetMinMax;
end;

procedure TAnalogIndEventsForm.FormCreate(Sender: TObject);
begin
   AbVMeter5.ResetMinMax;
   Label14.caption := AbVMeter5.ValueStr;
   AbLED4.checked := true;
end;

procedure TAnalogIndEventsForm.AbVMeter5Limit(Sender: TObject; Lower,
  Upper: Boolean);
begin
   AbLED1.Checked := lower;
   AbLED2.Checked := upper;
end;

end.
