{ This is my first try on a floating toolbar         }
{ Please note that the buttons must be the same size }
{ Comments are welcome to gda@hol.gr                 }
{ Version 0.0.1                                      }

unit toolbar;
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type
  TToolPanel = class( TPanel )
  private
  protected
     procedure Horizontal;
     procedure Vertical;
     procedure AsForm;
     procedure AlignLeft;
     procedure AlignRight;
     procedure AlignTop;
     procedure AlignBottom;
     procedure WMMouseDown(Var Msg: TMessage); message wm_LButtonDown;
  public
     constructor Create( AOwner: TComponent ); override;
  published
  end;

procedure Register;

implementation

constructor TToolPanel.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  Caption := '';
end;

procedure TToolPanel.Horizontal;
Var
  ctl: TWinControl;
  i,x: Integer;
  w,h: Integer;
begin
  If ControlCount = 0 then Exit;
  Width := TWinControl(Controls[0]).Width + 4;
  Height := TWinControl(Controls[0]).Height + 4;
  x := 2;
  for i := 0 to ControlCount - 1 do
  begin
    ctl := TWinControl( Controls[i] );
    ctl.Left := x;
    ctl.Top := 2;
    inc(x, ctl.Width);
  end;
end;

procedure TToolPanel.Vertical;
Var
  ctl: TWinControl;
  i,y: Integer;
  w,h: Integer;
begin
  If ControlCount = 0 then Exit;
  Width := TWinControl(Controls[0]).Width + 4;
  Height := TWinControl(Controls[0]).Height + 4;
  y := 2;
  for i := 0 to ControlCount - 1 do
  begin
    ctl := TWinControl( Controls[i] );
    ctl.Left := 2;
    ctl.Top := y;
    inc(y, ctl.Height);
  end;
end;

procedure TToolPanel.AsForm;
Var
  ctl: TWinControl;
  i,j,x,y: Integer;
  w,h: Integer;
begin
  If ControlCount = 0 then Exit;
  Align := AlNone;
  w := 3;
  h := ControlCount div w;
  Width := TWinControl(Controls[0]).Width * w + 10;
  Height := TWinControl(Controls[0]).Height * h + 20;
  x := 2; y := 16; j := 1;
  for i := 0 to ControlCount - 1 do
  begin
    ctl := TWinControl( Controls[i] );
    ctl.Left := x;
    ctl.Top := y;
    inc(x, ctl.Width);
    if j mod w = 0 then
    begin
      inc(y, ctl.Height);
      x := 2;
    end;
    inc(j);
  end;
  Align := AlNone;
end;

procedure TToolPanel.AlignLeft;
begin
  Vertical;
  Align := alLeft;
  Width := TWinControl(Controls[0]).Width + 6;
end;

procedure TToolPanel.AlignRight;
begin
  Vertical;
  Align := alRight;
  Width := TWinControl(Controls[0]).Width + 6;
end;

procedure TToolPanel.AlignTop;
begin
  Horizontal;
  Align := alTop;
  Height := TWinControl(Controls[0]).Height + 6;
end;

procedure TToolPanel.AlignBottom;
begin
  Horizontal;
  Align := alBottom;
  Height := TWinControl(Controls[0]).Height + 6;
end;

procedure TToolPanel.WMMouseDown(Var Msg: TMessage);
Const SC_DragMove = $F012;
begin
  ReleaseCapture;
  perform(WM_SysCommand, SC_DragMove, 0);
  if (Top < 0) then AlignTop
  else
  if (Top+Height > (Owner as TWinControl).Height) Then AlignBottom
  else
  if (Left < 0) then AlignLeft
  else
  if (Left+Width > (Owner as TWinControl).Width) then AlignRight
  else
    AsForm;
end;

procedure Register;
begin
  RegisterComponents('Andreas', [TToolPanel]);
end;

end.

