unit Testcass;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, TCASCONT, Spin, Acerca, ExtCtrls;

type
  TForm1 = class(TForm)
    bSTOP: TBitBtn;
    bPLAY: TBitBtn;
    bRW: TBitBtn;
    bFF: TBitBtn;
    SpinSpeed: TSpinEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    EsetTCode: TEdit;
    Bevel1: TBevel;
    Bevel2: TBevel;
    LTcode: TLabel;
    BClear: TBitBtn;
    BitBtn2: TBitBtn;
    SpeedButton1: TSpeedButton;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bSTOPClick(Sender: TObject);
    procedure bPLAYClick(Sender: TObject);
    procedure bRWClick(Sender: TObject);
    procedure bFFClick(Sender: TObject);
    procedure SpinSpeedChange(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BClearClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
  private
    { Private declarations }
    FCounter:TCasseteContador;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    FCounter:= TCasseteContador.Create(self);
    with FCounter do
    Begin
      Parent:=Self;
      Top:=40;  Left:=80;
      with Font do
      Begin Name:='Arial'; Size:=36; Color:=clWhite; Style:=[fsbold,fsitalic]; end;
      Caption:='00:00:00';
      SpinSpeed.Value:=FastSpeed;
      SpinEdit1.Value:= CountLimit;
    end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   FCounter.Free;
end;

procedure TForm1.bSTOPClick(Sender: TObject);
begin
     FCounter.SetOperacion(Stop);
end;

procedure TForm1.bPLAYClick(Sender: TObject);
begin
     FCounter.SetOperacion(Play);
end;

procedure TForm1.bRWClick(Sender: TObject);
begin
     FCounter.SetOperacion(Rwd);
end;

procedure TForm1.bFFClick(Sender: TObject);
begin
     FCounter.SetOperacion(FF);
end;

procedure TForm1.SpinSpeedChange(Sender: TObject);
begin
     FCounter.FastSpeed:=SpinSpeed.Value;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     About.ShowModal;
end;

procedure TForm1.BClearClick(Sender: TObject);
begin
     FCounter.ResetTimeCode
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
     If EsetTCode.Text = '' then exit;
     If    FCounter.SetTcodeStr(EsetTCode.Text) = false
     then  LTCode.Caption:='Error in Time'
     else  LTCode.Caption:='Time OK';
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
    Fcounter.CountLimit:= SpinEdit1.Value;
end;

end.
