unit Tcascont;
{Esta Unit corresponde al componente TCasseteContador que }
{coloca en pantalla un contador de tiempo h:m:s manejable}
{como el contador de una grabadora}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;
Type
   FormatoTimeCode = Record
     Cuadro,Min,Seg:Byte;
     Hora:Integer;
   end;
Type
   OperacionCinta = (Stop,Play,FF,Rwd,Null);

type
  TCasseteContador = class(TLabel)
  private
    { Private declarations }
    FContador:FormatoTimeCode;
    FTimer:TTimer;
    FLimite:Integer;
    FOpera: OperacionCinta;
    FSpeed:Integer; {Change speed of FF and Rwd}
    procedure SetTimeBCD(time:FormatoTimeCode);
    Function  GetTimeBCD:FormatoTimeCode;
    procedure SetTimeBin(time:FormatoTimeCode);
    Function  GetTimeBin:FormatoTimeCode;
   Procedure FTimerOnTimer(Sender:TObject);

  protected
    { Protected declarations }
    procedure WriteCaption;
  public
   { Public declarations }
    Constructor Create(AOwner:TComponent); override;
    Destructor  Destroy;
    Procedure SetOperacion(Operacion:OperacionCinta);
    Procedure ResetTimeCode;
    property  TimeCodeBCD:FormatoTimeCode read GetTimeBCD write SetTimeBCD;
    property  TimeCodeBin:FormatoTimeCode read GetTimeBin write SetTimeBin;
    Function  SetTCodeStr(Timecode:string):Boolean;
  published
    property CountLimit:Integer read FLimite write FLimite;
    property FastSpeed:Integer  read FSpeed write FSpeed;
    { Published declarations }
  end;

procedure Register;

implementation

procedure TCasseteContador.WriteCaption;
var
  t2:String;
Begin
  with FContador do Begin
    t2:=IntToStr(Seg);
    if byte(Length(t2)) = 1 then t2:=':0'+ t2 else t2:=':' + t2;
    t2:= IntToStr(Min)  + t2;
    If byte(Length(t2)) = 4 then t2:=':0'+ t2 else t2:= ':' + t2;
    t2:= IntToStr(Hora) + t2;
    If byte(Length(t2)) = 7 then t2:='0' + t2;
  end;
  Caption:= t2;
End;
procedure Register;
begin
  RegisterComponents('Samples', [TCasseteContador]);
end;
{Creador del Objeto}
Constructor TCasseteContador.Create(AOwner:TComponent);
Begin
  inherited Create(AOwner);
  Ftimer:= TTimer.Create(self);
  FTimer.OnTimer:=FTimerOnTimer;
  with FContador do Begin Cuadro:=1; Hora:=0; Min:=0; Seg:=0; end;
  FOpera:=Stop;
  FSpeed:=10; {100 cambios por segundo}
  FTimer.Interval:=1000;
  FTimer.Enabled:=False;
  FLimite:=3;
  WriteCaption;
End;
{Destructor del Objeto}
Destructor TCasseteContador.Destroy;
Begin
  FTimer.Destroy;
  inherited Destroy;
End;
Procedure  TCasseteContador.SetOperacion(Operacion:OperacionCinta);
Begin
   FOpera:=Operacion;
   Case FOPera of
    Stop: FTimer.Enabled:=False;
    Play: with FTimer do Begin Interval:= 1000; Enabled:=True; end;
    FF:   with FTimer do Begin Interval:= FSpeed; Enabled:=True; end;
    Rwd:  with FTimer do Begin Interval:= FSpeed; Enabled:=True; end;
   end;
End;
{Lleva a cero el contador de cassete}
Procedure TCasseteContador.ResetTimeCode;
Begin
  with FContador do Begin Cuadro:=1; Hora:=0; Min:=0; Seg:=0; end;
  WriteCaption; {Actualiza el contador}
End;
{Interno: Actualiza el Contador de Cassete}
procedure TCasseteContador.SetTimeBCD(time:FormatoTimeCode);
var
bl,bh,bth,btm,bts:byte;
Begin
  {Conversion de la entrada BCD a binario}
  with Time do
  begin
     bl:= hora and $0F; bh:= hora and $F0;
     bh:= (bh shr 4);
     bth:= (bh * 10) + bl;
     If bth > 24 then Exit;
     bl:= min and $0F; bh:= min and $F0;
     btm:= (bh * 10) + bl;
     If btm > 59 then Exit;
     bl:= seg and $0F; bh:= seg and $F0;
     bh:= (bh shr 4);
     bts:= (bh * 10) + bl;
     If bts > 59 then Exit;
  end;
  {Es almacenado el valor si es valido}
  with FContador do begin Hora:=bth; Min:=btm; Seg:=bts; end;
  WriteCaption;
end;
{Entrega el valor del contador en BCD}
Function TCasseteContador.GetTimeBCD:FormatoTimeCode;
var
 bd,bu,bht,bmt,bst:Byte;
 output:FormatoTimeCode;
Begin
   output.Cuadro:=1; {Esto es fijo}
   {Conversion a Formato BCD}
   with FContador do
   Begin
     bu:=Hora ; bd:=0; bht:=0;
     while bu > 9 do Begin Inc(bd,1); Dec(bu,10); end;
     bht:= (bd shl 4) or bu;
     bu:=Min ; bd:=0; bmt:=0;
     while bu > 9 do Begin Inc(bd,1); Dec(bu,10); end;
     bmt:= (bd shl 4) or bu;
     bu:=Seg ; bd:=0; bst:=0;
     while bu > 9 do Begin Inc(bd,1); Dec(bu,10); end;
     bst:= (bd shl 4) or bu;
   end;
   With Output do Begin Hora:=bht; Min:=bmt; Seg:=bst; end;
   GetTimeBCD:=OutPut;
end;

Procedure TCasseteContador.FTimerOnTimer(Sender:TObject);
Begin
  If FOpera = Rwd
  then {Si activo Rwd decremente}
    with FContador do
    Begin
     Dec(seg,1);
     If (seg and $80)<>0 then Begin Dec(Min,1); Seg:=59; end;
     If (Min and $80)<>0 then Begin Dec(Hora,1); Min:=59; end;
     If (Hora and $80)<> 0 then ResetTimeCode else WriteCaption;
     Exit;
    end;
  If (FOpera = Play) or (FOpera = FF)
  then {Incremento valor del contador}
    with FContador do
    Begin
     Inc(seg,1);
     If seg  > 59 then Begin Inc(Min,1); Seg:=00; end;
     If Min  > 59 then Begin Inc(Hora,1); Min:=00; end;
     If Hora > FLimite then Hora:=FLimite;
     WriteCaption;
    end;
End;
{Permite setear el Time Code desde una string, si la string no es valida}
{devuelve false, si es mayor que el maximo permitido coloca el maximo}
Function  TCasseteContador.SetTCodeStr(Timecode:string):Boolean;
var
 vh,vm,vs,vms:Word;
Begin
   try DecodeTime(StrToTime(TimeCode),vh,vm,vs,vms);
   except
     SetTCodestr:=false;
     Exit;
   end;
   with FContador do
   Begin
     If vH > FLimite then Hora:=FLimite else Hora:=vH;
     Min:=vm; Seg:=vs; Cuadro:=1;
   end;
   SetTCodeStr:=True;
   WriteCaption;
end;

function TCasseteContador.GetTimeBin: FormatoTimeCode;
begin
  Result:= FContador;
end;

procedure TCasseteContador.SetTimeBin(time: FormatoTimeCode);
var
 i:integer;
begin
   with time do
   begin
     if Seg > 59 then
     Begin
       i:= Seg DIV 60;
       Seg:= Seg MOD 60;
       Min:= i + Min;
     end;
     If Min > 59 then
     Begin
       i   := Min DIV 60;
       Min := Min MOD 60;
       Hora:= i + Hora;
     end;
   end;
   with FContador do
   begin Hora:=time.Hora; Min:=time.Min; Seg:=time.Seg; end;
   WriteCaption;
end;

end.
