unit uDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StringTree, StdCtrls, FileCtrl, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    btnGetDirTree: TButton;
    Edit1: TEdit;
    btnGetFileList: TButton;
    btnFindFile: TButton;
    btnDeleteDir: TButton;
    btnGetDirList: TButton;
    Label1: TLabel;
    btnCreateDir: TButton;
    btnCreateFile: TButton;
    btnShowDirTree: TButton;
    Edit2: TEdit;
    Label2: TLabel;
    btnGetAllFiles: TButton;
    Panel2: TPanel;
    Memo1: TMemo;
    Memo2: TMemo;
    btnSaveToFile: TButton;
    btnLoadFromFile: TButton;
    btnDeleteFiles: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnGetDirTreeClick(Sender: TObject);
    procedure btnGetFileListClick(Sender: TObject);
    procedure btnFindFileClick(Sender: TObject);
    procedure btnDeleteDirClick(Sender: TObject);
    procedure btnGetDirListClick(Sender: TObject);
    procedure btnCreateDirClick(Sender: TObject);
    procedure btnShowDirTreeClick(Sender: TObject);
    procedure btnCreateFileClick(Sender: TObject);
    procedure btnLoadFromFileClick(Sender: TObject);
    procedure btnSaveToFileClick(Sender: TObject);
    procedure btnGetAllFilesClick(Sender: TObject);
    procedure btnDeleteFilesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  StringTree1: TStringTree;


implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     StringTree1 := TStringTree.Create;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     StringTree1.Free;
end;

procedure TForm1.btnGetDirTreeClick(Sender: TObject);
var
   stringList: TStringList;
begin
     if StringTree1.DirExists( Edit1.Text) then begin
        stringList:= TStringList.Create;
        if StringTree1.GetDirTree( Edit1.Text, stringList) = strOK then begin
           Memo1.Lines.Assign( stringList);
        end;
        stringList.Free;
     end;
end;

procedure TForm1.btnGetFileListClick(Sender: TObject);
var
   stringList: TStringList;
   stringTreeError: TStringTreeError;
begin
     stringList := TStringList.Create;
     Memo1.Lines.Clear;
     stringTreeError := StringTree1.GetFileList( Edit1.Text, stringList);
     if stringTreeError = strOK then
           Memo1.Lines.Assign( stringList)
     else ShowMessage( StringTree1.ErrorToStr( stringTreeError));
     stringList.Free;
end;

procedure TForm1.btnFindFileClick(Sender: TObject);
var
   stringList: TStringList;
begin
     stringList := TStringList.Create;
     if StringTree1.FindFile( Edit2.Text, stringList) = strOK then begin
           Memo1.Lines.Assign( stringList);
     end;
     stringList.Free;
end;

procedure TForm1.btnDeleteDirClick(Sender: TObject);
begin
     StringTree1.DeleteDir( Edit1.Text);
end;

procedure TForm1.btnGetDirListClick(Sender: TObject);
var
   stringList: TStringList;
begin
     stringList := TStringList.Create;
     StringTree1.GetDirList( Edit1.Text, stringList);
     Memo1.Lines.Assign( stringList);
     stringList.Free;
end;

procedure TForm1.btnCreateDirClick(Sender: TObject);
begin
     StringTree1.CreateDir( Edit1.Text);
end;

procedure TForm1.btnShowDirTreeClick(Sender: TObject);
var
   stringList: TStringList;
begin
     stringList := TStringList.Create;
     StringTree1.GetDirTree( '', stringList);
     Memo1.Lines.Assign( stringList);
     stringList.Free;
end;


procedure TForm1.btnCreateFileClick(Sender: TObject);
begin
     StringTree1.CreateFile( Edit1.Text, Edit2.Text);
end;

procedure TForm1.btnLoadFromFileClick(Sender: TObject);
begin
     StringTree1.LoadFromFile( ExtractFilePath( Application.ExeName)
         + 'Data.ini');
     Memo2.Lines.LoadFromFile( ExtractFilePath( Application.ExeName)
         + 'Data.ini');
end;


procedure TForm1.btnSaveToFileClick(Sender: TObject);
begin
     if StringTree1.SaveToFile( ExtractFilePath( Application.ExeName)
         + 'Data.ini') <> strOK then
         ShowMessage( 'Save failed');
end;

procedure TForm1.btnGetAllFilesClick(Sender: TObject);
var
   stringList: TStringList;
begin
     stringList := TStringList.Create;
     StringTree1.GetAllFiles( Edit1.Text, stringList);
     Memo1.Lines.Assign( stringList);
     stringList.Free;
end;


procedure TForm1.btnDeleteFilesClick(Sender: TObject);
var
   stringTreeError: TStringTreeError;
begin
     stringTreeError := StringTree1.DeleteFiles( Edit1.Text);
     if stringTreeError <> strOK then
        ShowMessage( StringTree1.ErrorToStr( stringTreeError));
end;

end.
