(*****************************************************************************)
(** COPYRIGHT (c) 2003 Niclas Svan (niclas.svan@home.se)                     *)
(*****************************************************************************)
(** Description:                                                             *)
(** A function that returns a substrings position in a string and starts     *)
(** searching in the string from a given index. If the substring is not found*)
(** the function returns 0(zero). E.g NSPosInStr('MyLittleString','leS',3)   *)
(** returns 7 and starts the search by comparing 'L' with 'l'.               *)
(** The search can be either casesensitive or not.                                                                          *)
(**
(** Version 1.1                                                              *)
(*****************************************************************************)
unit uNSPosInStr;

interface
function NSPosInStr(const Str : string;
                    const SubStr: string;
                    StartPos: cardinal = 1;
                    CaseSensitive: boolean = TRUE): cardinal;


implementation
uses SysUtils;

function NSPosInStr(const Str : string;
                    const SubStr: string;
                    StartPos: cardinal = 1;
                    CaseSensitive: boolean = TRUE): cardinal;
var
  i, j, index : cardinal;
  bMatch : boolean;
  tmpStr, tmpSubStr : string;
begin
  index := 0;
  Result := 0;
  bMatch := FALSE;

  if (StartPos >= cardinal(Length(Str))) or (Length(SubStr) > Length(Str)) then
    Exit;

  if not CaseSensitive then
  begin
    tmpStr := AnsiUpperCase(Str);
    tmpSubStr:= AnsiUpperCase(SubStr);
  end
  else
  begin
    tmpStr := Str;
    tmpSubStr:= SubStr;
  end;

  if StartPos = 0 then
    StartPos := 1;

  i := 0;
  j := 1;
  while (i <= cardinal(Length(Str))) and (j <= cardinal(Length(SubStr)))  do
  begin
    if (j = cardinal(Length(SubStr))) and (bMatch) then
    begin
      Result := index;
      Exit;
    end;
    if bMatch then
      inc(j);
    if tmpStr[StartPos + i] = tmpSubStr[j] then
    begin
      if not bMatch then
      begin
        bMatch := TRUE;
        index := StartPos + i;
      end;
    end
    else
    begin
      if bMatch then
      begin
        bMatch := FALSE;
        j := 1;
        dec(i);
      end;
    end;
    inc(i);
  end;
end;
end.
