unit FNumLet;
interface

uses classes, SysUtils, Controls, Windows, StdCtrls, Math;

type
  TControlPropio = class(TCustomEdit)
  published
    property OnChange;
  end;

type
  DPoint = (dpComa, dpPunto);

type
  TNumLet = class(TComponent)
  private
    VUnid: array[1..15] of String;
    VDec : array[1..10] of String;
    VCen : array[1..9] of String;
    VMil : array[1..7] of String;
    Millares :word;
    FT, Cambiar : boolean;
    FDecimalPoint: DPoint;
    Resto,Resultado,Estrin, Teksto:string;
    Nro: array[0..2] of char;
    N1,N2,N3:Integer;
    Valor : Extended;
    FDecimal: word;
    P : TCustomEdit;
    Change : TNotifyEvent;
    Control : TControl;
    function ConvierteNumeroALetras(Number:Extended;OnDecimales:boolean):string;
    procedure OnSetNumber(Cn:TCustomEdit);
    procedure CargaValor(Nro:Extended);
    procedure OnResult;
    procedure OnChange(Sender:TObject);
    procedure CambiaUpper(VF:Boolean);
    procedure ChangeCombo(Value: DPoint);
    procedure WriteControl(Objeto:TControl);
    procedure CargaVectores;
    procedure CheckDecimal(Valor:word);
  published
    property SetNumber : Extended read Valor write CargaValor;
    property Result : String read Estrin;
    property AssociateOutput : TControl read Control write WriteControl;
    property AssociateInput : TCustomEdit read P write OnSetNumber;
    property Upper : boolean read FT write CambiaUpper;
    property DecimalPoint : DPoint read FDecimalPoint write ChangeCombo;
    property Decimales: word read FDecimal write CheckDecimal;
  public
    constructor Create(AOwner:TComponent) ;override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TNumLet]);
end;

{ TNumLet }

procedure TNumLet.CargaValor(Nro: Extended);
begin
  Valor := Nro;
  OnResult;
end;

function TNumLet.ConvierteNumeroALetras(Number: Extended;OnDecimales:boolean): string;
var i :word;
begin
  Resto := floattostr(Number);
  if (Length(Resto) mod 3) <> 0 then
    Resto := stringofchar('0',3-(Length(Resto) mod 3))+Resto;
  Millares := trunc(Length(Resto) / 3);
  for i := 1 to Millares do begin
    Resultado := '';
    strpcopy(Nro,copy(Resto,Length(Resto)-2,3));
    N1 := strtoint(Nro[0]);
    N2 := strtoint(Nro[1]);
    N3 := strtoint(Nro[2]);
    Delete(Resto,Length(Resto)-2,3);
    if N1 > 0 then begin
      Resultado := VCen[N1];
      if ((N2 <> 0) or (N3 <> 0)) and (N1 = 1) then
        Resultado := Resultado +'to';
    end;
    if ((N2*10)+N3) < 16 then
      if (N2 <> 0) or (N3 <>0) then
        Resultado := Resultado+' '+VUnid[(N2*10)+N3]
      else
    else
      if N3 <> 0 then
        if N2 = 1 then
          Resultado := Resultado+' '+VDec[1]+VUnid[N3]
        else if N2 = 2 then
          Resultado := Resultado + ' ' +VDec[10]+VUnid[N3]
        else
          Resultado := Resultado + ' '+VDec[N2]+ ' y '+VUnid[N3]
      else
        Resultado := Resultado + ' '+ VDec[N2];
    if i > 1 then
      if i = 3 then
        if (N1 = 0) and (N2 = 0) and (N3 = 1) then
          Resultado := Resultado + ' '+VMil[2]
        else
          Resultado := Resultado + ' '+VMil[i]
      else if i = 5 then
        if (N1 = 0) and (N2 = 0) and (N3 = 1) then
          Resultado := Resultado + ' '+VMil[i]
        else
          Resultado := Resultado + ' '+VMil[6+Length(floattostr(Number))-15]
      else if i in([2,4]) then
        if (N1 <> 0) or (N2 <> 0) or (N3 <>0) then
          Resultado := Resultado + ' ' + VMil[1]
        else
      else
        Resultado := Resultado + ' ' + VMil[i]
    else
      if N3 = 1 then
        if N2 <> 1 then
          Resultado := Resultado+'o';
    if Resultado <> '' then
      if not OnDecimales then
        ConvierteNumeroALetras := trim(Resultado)+' '+Result
      else
        ConvierteNumeroALetras := trim(Resultado);
  end;
end;

constructor TNumLet.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
  CargaVectores;
  Upper := False;
  DecimalPoint := dpComa;
  Decimales := 2;
  Cambiar := True;
end;

procedure TNumLet.OnResult;
var c: array[0..128] of char;
    Dec,Lorva: Extended;
begin
  Lorva := (round(frac(Valor)*IntPower(10,FDecimal)))/IntPower(10,FDecimal);
  Valor := Valor -frac(Valor);
  if Lorva <> 0 then
    Dec := Lorva * IntPower(10,FDecimal)
  else
    Dec := 0;
  Estrin := ConvierteNumeroALetras(Valor,False);
  if Dec > 0 then begin
    Estrin := trim(Estrin)+' con '+ConvierteNumeroALetras(Dec,True);
    if copy(floattostr(Dec),Length(floattostr(Dec)),1) = '1' then
      Estrin := copy(Estrin,1,Length(Estrin)-1);
    if Dec > 1 then
      Estrin := Estrin +' centavos'
    else
      Estrin := Estrin + ' centavo';
  end;
  if Upper then
    Estrin := uppercase(Estrin);
  Control.SetTextBuf(c);
  strpcopy(c,Estrin);
  Control.SetTextBuf(c);
  Valor := Valor + Lorva;
end;

procedure TNumLet.OnSetNumber(Cn: TCustomEdit);
var x : array[0..128] of char;
    buffer,i : integer;
begin
  if P <> Cn then begin
    Change := nil;
    P := Cn;
    if Cn <> nil then begin
      if Assigned(TControlPropio(P).Onchange) then
        Change := TControlPropio(P).OnChange;
      TControlPropio(P).OnChange := OnChange;
    end;
  end;
  if Assigned(P) then begin
    buffer := P.GetTextLen+1;
    P.GetTextBuf(x,buffer);
    end
  else
    buffer := 2;
  for i := 0 to buffer-2 do
    if not (x[i] in(['0','1','2','3','4','5','6','7','8','9',',','.'])) then
      x[i] := #0;

  if (buffer > 0) and (Length(strpas(x)) > 0) then
    try
      Teksto := strpas(x);
      if FDecimalPoint = dpComa then
        for i:= 1 to Length(Teksto) do
          if Teksto[i] = '.' then
            Delete(Teksto,i,1)
          else
      else if FDecimalPoint = dpPunto then
        for i:= 1 to Length(Teksto) do
          if Teksto[i] = ',' then
            Delete(Teksto,i,1)
          else
       else
         for i:= 1 to Length(Teksto) do
           if Teksto[i] in(['.',',']) then
             Delete(Teksto,i,1);
      Valor := strtofloat(Teksto);
      OnResult;
    except end;
end;

procedure TNumLet.Onchange(Sender: TObject);
begin
  if Cambiar then begin
    OnSetNumber(TControlPropio(Sender));
    if Assigned(Change) then begin
      Cambiar := False;
      P.SetTextBuf(pchar(Teksto));
      Cambiar := True;
      Change(Sender);
    end;
  end;
end;

procedure TNumLet.CambiaUpper(VF: Boolean);
begin
  FT := VF;
  OnResult;
end;

procedure TNumLet.WriteControl(Objeto: TControl);
begin
  Control := Objeto;
end;

procedure TNumLet.ChangeCombo(Value: DPoint);
begin
  FDecimalPoint := Value;
  OnResult;
end;

procedure TNumLet.CargaVectores;
begin
  VUnid[1] := 'un';
  VUnid[2] := 'dos';
  VUnid[3] := 'tres';
  VUnid[4] := 'cuatro';
  VUnid[5] := 'cinco';
  VUnid[6] := 'seis';
  VUnid[7] := 'siete';
  VUnid[8] := 'ocho';
  VUnid[9] := 'nueve';
  VUnid[10] := 'diez';
  VUnid[11] := 'once';
  VUnid[12] := 'doce';
  VUnid[13] := 'trece';
  VUnid[14] := 'catorce';
  VUnid[15] := 'quince';
  VDec[1] := 'dieci';
  VDec[2] := 'veinte';
  VDec[3] := 'treinta';
  VDec[4] := 'cuarenta';
  VDec[5] := 'cincuenta';
  VDec[6] := 'sesenta';
  VDec[7] := 'setenta';
  VDec[8] := 'ochenta';
  VDec[9] := 'noventa';
  VDec[10] := 'veinti';
  VCen[1] := 'cien';
  VCen[2] := 'doscientos';
  VCen[3] := 'trescientos';
  VCen[4] := 'cuatrocientos';
  VCen[5] := 'quinientos';
  VCen[6] := 'seiscientos';
  VCen[7] := 'setecientos';
  VCen[8] := 'ochocientos';
  VCen[9] := 'novecientos';
  VMil[1] := 'mil';
  VMil[2] := 'milln';
  VMil[3] := 'millones';
  VMil[4] := 'mil millones';
  VMil[5] := 'billn';
  VMil[6] := 'billones';
  VMil[7] := 'mil billones';
end;

procedure TNumLet.CheckDecimal(Valor: word);
begin
  if not (Valor in([0,2])) then
    raise Exception.Create('Los valores posibles para esta propiedad son 0 (cero) o 2 (dos) !')
  else
    FDecimal := Valor;
end;

end.
