{*******************************************************************
 *  Copyright (c) 1999  Shlomo ABUISAK                             *
 *  CopyRight (c) 1999  LIM ELECTRONICS                            *
 *                  P.O.B 1149 GIVATAYIM                           *
 *                       ISRAEL                                    *
 *                                                                 *
 *  MODULE:  HEBREW HOLIDAYS  V1.0                                 *
 *                                                                 *
 *  DATE: 19/07/2004 10:20:21                                      *
 *                                                                 *
 *  NOTES:                                                         *
 *                                                                 *
 *                                                                 *
 *  HISTORY:                                                       *
 *   Many routins are taken from the MOON component                *
 *   Copyright 1997-2001 Andreas Hrstemeier                       *
 *         Version 2.0 2001-07-07                                  *
 * I have changed in all the function                              *
 *   raise EConvertError.Create not to return text but else        *
 *                                                                 *
 *******************************************************************}
unit HebHolyDays;
interface

uses DateUtil, sysutils;
type
  TJewishYearStyle = (ys_common_deficient, ys_common_regular, ys_common_complete,
    ys_leap_deficient, ys_leap_regular, ys_leap_complete);
var
  julian_offset: extended = 0;
const
  calendar_change_standard: extended = 2299160.5;
  Jewish_year_length: array[TJewishYearStyle] of integer = (353, 354, 355, 383, 384, 385);
  Jewish_Month_length: array[1..13, TJewishYearStyle] of word = (
    (30, 30, 30, 30, 30, 30),
    (29, 29, 29, 29, 29, 29),
    (30, 30, 30, 30, 30, 30),
    (29, 29, 29, 29, 29, 29),
    (30, 30, 30, 30, 30, 30),
    (29, 29, 29, 29, 29, 29),
    (30, 30, 30, 30, 30, 30),
    (29, 29, 30, 29, 29, 30),
    (29, 30, 30, 29, 30, 30),
    (29, 29, 29, 29, 29, 29),
    (30, 30, 30, 30, 30, 30),
    (29, 29, 29, 30, 30, 30),
    (0, 0, 0, 29, 29, 29)
    );

(* jewish month
0   'Nisan',
1    'Iyar',
2    'Sivan',
3    'Tammuz',
4    'Av',
5    'Elul',
6    'Tishri',
7    'Heshvan',
8    'Kislev',
9    'Tevet',
10    'Shevat',
11    'Adar',
12    'Adar 2'
*)
//TholyDays= record
const
  Holydays = 9; // to add more holidays
  // names of the holidays !!!this is in hebrew!!!  7          7
  HolyDayName: array[0..Holydays] of string = (' ', ' ',
       //7       9       11       12/13     1         2         3
    '', '', ' ', '', '', ' ', '',
     // 5
    ' ');
  HolyDayMonth: array[0..Holydays] of integer = (7, 7, 7, 9, 11, 13, 1, 2, 3, 5);
  // the day of the holiday
  HolyDayDay: array[0..Holydays] of integer =   (1, 10, 15, 25, 15, 14, 15, 18, 6, 9);
  // the length of the holiday
  HolyDaySpan: array[0..Holydays] of integer =  (2, 1, 8, 8, 1, 2, 7, 1, 1, 1);

function GetHolidayName(Date: TdateTime;var DaySpan:integer):String;
function IsItAnHoliday(Date: TdateTime): boolean;
function MyEncodeDateJewish(year, month, day: word; var DT: TDateTime): Boolean;

var
  y, m, d: word;
  I: integer;
  DB, DE: TdateTime;

implementation
(*
ALL THE FUNCTIONS ARE FROM THE MOON COMPONENTS BY
   Copyright 1997-2001 Andreas Hrstemeier
       Version 2.0 2001-07-07
       CHANGED ONLY  raise EConvertError.Create(.....
*)
function delphi_date(juldat: extended): TDateTime;
begin
  delphi_date := juldat - julian_offset;
end;

function Calc_Julian_date_julian(year, month, day: word): extended;
begin
  if (year < 1) or (year > 9999) then
//    raise EConvertError.Create('Invalid year');
    result := 0;
  if month < 3 then begin
    month := month + 12;
    year := year - 1;
  end;
  case month of
    3, 5, 7, 8, 10, 12, 13: if (day < 1) or (day > 31) then
    //EConvertError.Create('Invalid day');
        result := 0;
    4, 6, 9, 11: if (day < 1) or (day > 30) then
        result := 0; //EConvertError.Create('Invalid day');
    14: case day of
        1..28: ;
        29: if (year + 1) mod 4 <> 0 then
            result := 0; //EConvertError.Create('Invalid day');
      else result := 0; //EConvertError.Create('Invalid day');
      end;
  else result := 0; //EConvertError.Create('Invalid month');
  end;
  result := trunc(365.25 * (year + 4716)) + trunc(30.6001 * (month + 1)) + day - 1524.5;
end;

function Calc_Julian_date_gregorian(year, month, day: word): extended;
var
  a, b: longint;
begin
  if (year < 1) or (year > 9999) then
    result := 0; //EConvertError.Create('Invalid year');
  if month < 3 then begin
    month := month + 12;
    year := year - 1;
  end;
  a := year div 100;
  case month of
    3, 5, 7, 8, 10, 12, 13: if (day < 1) or (day > 31) then
        result := 0; //EConvertError.Create('Invalid day');
    4, 6, 9, 11: if (day < 1) or (day > 30) then
        result := 0; // EConvertError.Create('Invalid day');
    14: case day of
        1..28: ;
        29: if (((year mod 4) <> 0) or ((year mod 100) = 0)) and
          ((year mod 400) <> 0) then
            result := 0; //EConvertError.Create('Invalid day');
      else result := 0; //EConvertError.Create('Invalid day');
      end;
  else result := 0; //raise EConvertError.Create('Invalid month');
  end;
  b := 2 - a + (a div 4);
  result := trunc(365.25 * (year + 4716)) + trunc(30.6001 * (month + 1)) + day + b - 1524.5;
end;

function Calc_Julian_date_switch(year, month, day: word; switch_date: extended): extended;
begin
  result := Calc_Julian_date_julian(year, month, day);
  if result >= switch_date then begin
    result := Calc_Julian_date_gregorian(year, month, day);
    if result < switch_date then
      result := 0; //raise EConvertError.Create('Date invalid due to calendar change');
  end;
end;

function Calc_Julian_date(year, month, day: word): extended;
begin
  result := Calc_Julian_date_switch(year, month, day, calendar_change_standard);
end;

function EncodedateCorrect(year, month, day: word): TDateTime;
begin
  result := delphi_date(Calc_Julian_date(year, month, day));
end;

function PesachDate(year: integer): TDateTime;
var
  a, b, c, d, j, s: integer;
  q, r: extended;
begin
  if year < 359 then
    result := 0;
//    raise E_OutOfAlgorithmRange.Create('Out of range of the algorithm');
  c := year div 100;
  if year < 1583 then
    s := 0
  else
    s := (3 * c - 5) div 4;
  a := (12 * year + 12) mod 19;
  b := year mod 4;
  q := -1.904412361576 + 1.554241796621 * a + 0.25 * b - 0.003177794022 * year + s;
  j := (trunc(q) + 3 * year + 5 * b + 2 - s) mod 7;
  r := frac(q);
  if false then
  else if j in [2, 4, 6] then
    d := trunc(q) + 23
  else if (j = 1) and (a > 6) and (r >= 0.632870370) then
    d := trunc(q) + 24
  else if (j = 0) and (a > 11) and (r >= 0.897723765) then
    d := trunc(q) + 23
  else
    d := trunc(q) + 22;

  if d > 31 then
    result := EncodedateCorrect(year, 4, d - 31)
  else
    result := EncodedateCorrect(year, 3, d);
end;

function MyJewishYearStyle(year: word): TJewishYearStyle;
var
  i: TJewishYearStyle;
  yearlength: integer;
begin
  yearlength := round(pesachdate(year - 3760) - pesachdate(year - 3761));
  result := low(TJewishYearStyle);
  for i := low(TJewishYearStyle) to high(TJewishYearStyle) do
    if yearlength = Jewish_year_length[i] then
      result := i;
end;

function MyEncodeDateJewish(year, month, day: word; var DT: TDateTime): Boolean;
var
  yearstyle: TJewishYearStyle;
  offset, i: integer;
  Flag: boolean;

begin
  flag := false;
  yearstyle := MyJewishYearStyle(year);
  if (month < 1) or (month > 13) then
    flag := true;
//    raise EConvertError.Create('Invalid month');
  if (month = 13) and
    (yearstyle in [ys_common_deficient, ys_common_regular, ys_common_complete]) then
    flag := true;
//    raise EConvertError.Create('Invalid month');
  if (day < 1) or (day > Jewish_Month_length[month, yearstyle]) then
    flag := true;
//    raise EConvertError.Create('Invalid day');
  offset := day - 1;
  // count months from tishri
  month := (month + 6) mod 13 + 1;
  for i := 1 to month - 1 do
    offset := offset + Jewish_Month_length[(i + 5) mod 13 + 1, yearstyle];
  DT := pesachdate(year - 3761) + 163 + offset;
  if flag then Result := false
  else Result := true;
end;

procedure Calc_Calendar_date_julian(juldat: extended; var year, month, day: word);
var
  z, a, b, c, d, e: longint;
begin
  if juldat < 0 then
    exit; //  raise EConvertError.Create('Negative julian dates not supported');
  juldat := juldat + 0.5;
  z := trunc(juldat);
  a := z;
  b := a + 1524;
  c := trunc((b - 122.1) / 365.25);
  d := trunc(365.25 * c);
  e := trunc((b - d) / 30.6001);
  day := b - d - trunc(30.6001 * e);
  year := c - 4716;
  if e < 14 then
    month := e - 1
  else begin
    month := e - 13;
    year := year + 1;
  end;
end;

procedure Calc_Calendar_date_gregorian(juldat: extended; var year, month, day: word);
var
  alpha, z, a, b, c, d, e: longint;
begin
  if juldat < 0 then
    exit; // raise EConvertError.Create('Negative julian dates not supported');
  juldat := juldat + 0.5;
  z := trunc(juldat);
  alpha := trunc((z - 1867216.25) / 36524.25);
  a := z + 1 + alpha - trunc(alpha / 4);
  b := a + 1524;
  c := trunc((b - 122.1) / 365.25);
  d := trunc(365.25 * c);
  e := trunc((b - d) / 30.6001);
  day := b - d - trunc(30.6001 * e);
  year := c - 4716;
  if e < 14 then
    month := e - 1
  else begin
    month := e - 13;
    year := year + 1;
  end;
end;

procedure Calc_Calendar_date_switch(juldat: extended; var year, month, day: word; switch_date: extended);
begin
  if juldat < 0 then
    exit;
// raise EConvertError.Create('Negative julian dates not supported');
  if juldat < switch_date then
    Calc_Calendar_date_julian(juldat, year, month, day)
  else
    Calc_Calendar_date_gregorian(juldat, year, month, day);
end;

procedure Calc_Calendar_date(juldat: extended; var year, month, day: word);
begin
  Calc_Calendar_date_switch(juldat, year, month, day, calendar_change_standard);
end;

function julian_date(date: TDateTime): extended;
begin
  julian_date := julian_offset + date
end;

procedure DecodedateCorrect(date: TDateTime; var year, month, day: word);
begin
  Calc_Calendar_date(julian_date(date), year, month, day);
end;

function JewishYearStyle(year: word): TJewishYearStyle;
var
  i: TJewishYearStyle;
  yearlength: integer;
begin
  yearlength := round(pesachdate(year - 3760) - pesachdate(year - 3761));
  result := low(TJewishYearStyle);
  for i := low(TJewishYearStyle) to high(TJewishYearStyle) do
    if yearlength = Jewish_year_length[i] then
      result := i;
end;

procedure DecodeDateJewish(date: TDateTime; var year, month, day: word);
var
  year_g, month_g, day_g: word;
  yearstyle: TJewishYearStyle;
  tishri1: TDateTime;
begin
  DecodedateCorrect(date, year_g, month_g, day_g);
  tishri1 := pesachdate(year_g) + 163;
  if tishri1 > date then begin
    tishri1 := pesachdate(year_g - 1) + 163;
    year := year_g + 3760;
  end
  else
    year := year_g + 3761;
  yearstyle := JewishYearStyle(year);
  month := 7;
  day := round(date - tishri1 + 1);
  while day > Jewish_Month_length[month, yearstyle] do begin
    dec(day, Jewish_Month_length[month, yearstyle]);
    month := (month mod 13) + 1;
  end;
end;

(*
   LIM ELECTRONICS PART
   TO USE IN CALANDERS
*)


function GetHolidayName(Date: TdateTime;var DaySpan:integer):String;
begin
  result := '';
  DecodeDateJewish(date, y, m, d);
  for i := 0 to Holydays do
  begin // for adar a or b
    if not MyEncodedateJewish(y, HolydayMonth[i], HolydayDay[i], DB) then
      MyEncodedateJewish(y, HolydayMonth[i] - 1, HolydayDay[i], DB);
    DE := IncDay(DB, HolyDaySpan[i] - 1);
    if (Date >= DB) and (Date <= DE) then
    begin
      DaySpan :=HolyDaySpan[i];
      result := HolyDayName[i];
      exit;
    end;
  end;
end;

function IsItAnHoliday(Date: TdateTime): boolean;
begin
  result := false;
  DecodeDateJewish(date, y, m, d);
  for i := 0 to Holydays do
  begin // for adar a or b
    if not MyEncodedateJewish(y, HolydayMonth[i], HolydayDay[i], DB) then
      MyEncodedateJewish(y, HolydayMonth[i] - 1, HolydayDay[i], DB);
    DE := IncDay(DB, HolyDaySpan[i] - 1);
    if (Date >= DB) and (Date <= DE) then
    begin
      result := true;
      exit;
    end;
  end;
end;
initialization
  julian_offset := 2451544.5 - EncodeDate(2000, 1, 1);
end.

