{
    $Id: objects.pp,v 1.37 2000/04/07 21:10:35 pierre Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2000 by the Free Pascal development team.

    Objects.pas clone for Free Pascal

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{************[ SOURCE FILE OF FREE VISION ]****************}
{                                                          }
{    System independent clone of objects.pas               }
{                                                          }
{    Interface Copyright (c) 1992 Borland International    }
{                                                          }
{    Parts Copyright (c) 1999-2000 by Florian Klaempfl       }
{    fnklaemp@cip.ft.uni-erlangen.de                       }
{                                                          }
{    Parts Copyright (c) 1999-2000 by Frank ZAGO                }
{    zago@ecoledoc.ipc.fr                                  }
{                                                          }
{    Parts Copyright (c) 1999-2000 by MH Spiegel                }
{                                                          }
{    Parts Copyright (c) 1996, 1999-2000 by Leon de Boer        }
{    ldeboer@ibm.net                                       }
{                                                          }
{    Free Vision project coordinator Balazs Scheidler      }
{    bazsi@tas.vein.hu                                     }
{                                                          }
unit Objects;

{$I platform.inc}

{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>}
interface
{<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>}

{==== Select assembler ==============================================}
{$IFDEF CPU86}
{$ASMMODE ATT}
{$ENDIF}

{$IFDEF CPU68}
{$ASMMODE MOT}
{$ENDIF}

{==== Compiler directives ===========================================}
{$H-} { No ansistrings }
{$X+} { Extended syntax is ok }
{$R-} { Disable range checking }
{$IFNDEF Linux}
{$S-} { Disable Stack Checking }
{$ENDIF}
{$I-} { Disable IO Checking }
{$Q-} { Disable Overflow Checking }
{$V-} { Turn off strict VAR strings }
{====================================================================}

{***************************************************************************}
{                             PUBLIC CONSTANTS                              }
{***************************************************************************}

const
  MaxAvail = MaxInt;

  {---------------------------------------------------------------------------}
  {                          STREAM ERROR STATE MASKS                         }
  {---------------------------------------------------------------------------}
const
  stOk = 0; { No stream error }
  stError = -1; { Access error }
  stInitError = -2; { Initialize error }
  stReadError = -3; { Stream read error }
  stWriteError = -4; { Stream write error }
  stGetError = -5; { Get object error }
  stPutError = -6; { Put object error }
  stSeekError = -7; { Seek error in stream }
  stOpenError = -8; { Error opening stream }

  {---------------------------------------------------------------------------}
  {                        STREAM ACCESS MODE CONSTANTS                       }
  {---------------------------------------------------------------------------}
const
  stCreate = $3C00; { Create new file }
  stOpenRead = $3D00; { Read access only }
  stOpenWrite = $3D01; { Write access only }
  stOpen = $3D02; { Read/write access }

  {---------------------------------------------------------------------------}
  {                          TCollection ERROR CODES                          }
  {---------------------------------------------------------------------------}
const
  coIndexError = -1; { Index out of range }
  coOverflow = -2; { Overflow }

  {---------------------------------------------------------------------------}
  {         VMT HEADER CONSTANT - HOPEFULLY WE CAN DROP THIS LATER            }
  {---------------------------------------------------------------------------}
const
  vmtHeaderSize = 8; { VMT header size }

const
  {---------------------------------------------------------------------------}
  {                            MAXIUM DATA SIZES                              }
  {---------------------------------------------------------------------------}
  {$IFDEF FPC}
  MaxBytes = 128 * 1024 * 1024; { Maximum data size }
  {$ELSE}
  MaxBytes = 16384;
  {$ENDIF}
  MaxWords = MaxBytes div SizeOf(Word); { Max word data size }
  MaxPtrs = MaxBytes div SizeOf(Pointer); { Max ptr data size }
  MaxCollectionSize = MaxBytes div SizeOf(Pointer); { Max collection size }
  MaxTPCompatibleCollectionSize = 65520 div 4;

  {***************************************************************************}
  {                          PUBLIC TYPE DEFINITIONS                          }
  {***************************************************************************}

type
  DWORD = Cardinal;

  {---------------------------------------------------------------------------}
  {                               CHARACTER SET                               }
  {---------------------------------------------------------------------------}
type
  TCharSet = set of Char; { Character set }
  PCharSet = ^TCharSet; { Character set ptr }

  {---------------------------------------------------------------------------}
  {                               GENERAL ARRAYS                              }
  {---------------------------------------------------------------------------}
type
  TByteArray = array[0..MaxBytes - 1] of Byte; { Byte array }
  PByteArray = ^TByteArray; { Byte array pointer }

  TWordArray = array[0..MaxWords - 1] of Word; { Word array }
  PWordArray = ^TWordArray; { Word array pointer }

  TPointerArray = array[0..MaxPtrs - 1] of Pointer; { Pointer array }
  PPointerArray = ^TPointerArray; { Pointer array ptr }

  {---------------------------------------------------------------------------}
  {                             POINTER TO STRING                             }
  {---------------------------------------------------------------------------}
type
  PString = ^string; { String pointer }

  {---------------------------------------------------------------------------}
  {                    OS dependent File type / consts                        }
  {---------------------------------------------------------------------------}
  {$IFDEF GO32V1}
type
  FNameStr = string[79];
  THandle = Integer;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF GO32V2}
type
  FNameStr = string;
  THandle = Integer;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF Win32}
type
  FNameStr = string;
  THandle = LongInt;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF OS2}
type
  FNameStr = string;
  THandle = Word;
const
  MaxReadBytes = $7FFFFFFF;
  invalidhandle = $FFFF;
  {$ENDIF}
  {$IFDEF LINUX}
type
  FNameStr = string;
  { values are words, though the OS calls return 32-bit values }
  { to check (CEC)                                             }
  THandle = LongInt;
const
  MaxReadBytes = $7FFFFFFF;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF AMIGA}
type
  FNameStr = string;
  THandle = LongInt;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF ATARI}
type
  FNameStr = string[79];
  THandle = Integer;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}
  {$IFDEF MAC}
type
  FNameStr = string;
  THandle = Integer;
const
  MaxReadBytes = $FFFE;
  invalidhandle = -1;
  {$ENDIF}

  {---------------------------------------------------------------------------}
  {                            DOS ASCIIZ FILENAME                            }
  {---------------------------------------------------------------------------}
type
  AsciiZ = array[0..255] of Char; { Filename array }

  {---------------------------------------------------------------------------}
  {                        BIT SWITCHED TYPE CONSTANTS                        }
  {---------------------------------------------------------------------------}
type
  Sw_Word = LongInt; { Long Word now }
  Sw_Integer = LongInt; { Long integer now }

  {***************************************************************************}
  {                        PUBLIC RECORD DEFINITIONS                          }
  {***************************************************************************}

  {---------------------------------------------------------------------------}
  {                          TYPE CONVERSION RECORDS                          }
  {---------------------------------------------------------------------------}
type
  WordRec = packed record
    Lo, Hi: Byte; { Word to bytes }
  end;

  LongRec = packed record
    Lo, Hi: Word; { LongInt to words }
  end;

  PtrRec = packed record
    Ofs, Seg: Word; { Pointer to words }
  end;

  {---------------------------------------------------------------------------}
  {                  TStreamRec RECORD - STREAM OBJECT RECORD                 }
  {---------------------------------------------------------------------------}
type
  PStreamRec = ^TStreamRec; { Stream record ptr }
  TStreamRec = packed record
    ObjType: Sw_Word; { Object type id }
    VmtLink: Pointer; { VMT link }
    Load: Pointer; { Object load code }
    Store: Pointer; { Object store code }
    Next: PStreamRec; { Next stream record }
  end;

  {***************************************************************************}
  {                        PUBLIC OBJECT DEFINITIONS                          }
  {***************************************************************************}

{---------------------------------------------------------------------------}
{                  TObject OBJECT - BASE ANCESTOR OBJECT                    }
{---------------------------------------------------------------------------}
type
  TObject = object
    constructor Init;
    procedure Free;
    function Is_Object(p: Pointer): Boolean;
    destructor Done; virtual;
  end;
  PObject = ^TObject;

  { ******************************* REMARK ****************************** }
  {  All the changes here should be completely transparent to existing    }
  {  code. Basically the memory blocks do not have to be base segments    }
  {  but this means our list becomes memory blocks rather than segments.  }
  {  The stream will also expand like the other standard streams!!        }
  { ****************************** END REMARK *** Leon de Boer, 19May96 * }

type
  TItemList = array[0..MaxCollectionSize - 1] of Pointer;
  PItemList = ^TItemList;

  { ******************************* REMARK ****************************** }
  {    The changes here look worse than they are. The Sw_Integer simply   }
  {  switches between Integers and LongInts if switched between 16 and 32 }
  {  bit code. All existing code will compile without any changes.        }
  { ****************************** END REMARK *** Leon de Boer, 10May96 * }

  {---------------------------------------------------------------------------}
  {              TCollection OBJECT - COLLECTION ANCESTOR OBJECT              }
  {---------------------------------------------------------------------------}
  TCollection = object(TObject)
    Items: PItemList; { Item list pointer }
    Count: Sw_Integer; { Item count }
    Limit: Sw_Integer; { Item limit count }
    Delta: Sw_Integer; { Inc delta size }
    constructor Init(ALimit, ADelta: Sw_Integer);
    destructor Done; virtual;
    function At(Index: Sw_Integer): Pointer;
    function IndexOf(Item: Pointer): Sw_Integer; virtual;
    procedure Pack;
    procedure FreeAll;
    procedure DeleteAll;
    procedure Free(Item: Pointer);
    procedure Insert(Item: Pointer); virtual;
    procedure Delete(Item: Pointer);
    procedure atFree(Index: Sw_Integer);
    procedure FreeItem(Item: Pointer); virtual;
    procedure atDelete(Index: Sw_Integer);
    procedure SetLimit(ALimit: Sw_Integer); virtual;
    procedure Error(Code, Info: Integer); virtual;
    procedure atPut(Index: Sw_Integer; Item: Pointer);
    procedure atInsert(Index: Sw_Integer; Item: Pointer);
  end;
  PCollection = ^TCollection;

  {---------------------------------------------------------------------------}
  {          TSortedCollection OBJECT - SORTED COLLECTION ANCESTOR            }
  {---------------------------------------------------------------------------}
type
  TSortedCollection = object(TCollection)
    Duplicates: Boolean; { Duplicates flag }
    constructor Init(ALimit, ADelta: Sw_Integer);
    function KeyOf(Item: Pointer): Pointer; virtual;
    function IndexOf(Item: Pointer): Sw_Integer; virtual;
    function Compare(Key1, Key2: Pointer): Sw_Integer; virtual;
    function Search(Key: Pointer; var Index: Sw_Integer): Boolean; virtual;
    procedure Insert(Item: Pointer); virtual;
  end;
  PSortedCollection = ^TSortedCollection;

  {---------------------------------------------------------------------------}
  {           TStringCollection OBJECT - STRING COLLECTION OBJECT             }
  {---------------------------------------------------------------------------}
type
  TStringCollection = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Sw_Integer; virtual;
    procedure FreeItem(Item: Pointer); virtual;
  end;
  PStringCollection = ^TStringCollection;

  {---------------------------------------------------------------------------}
  {        TUnSortedStringCollection - UNSORTED STRING COLLECTION OBJECT         }
  {---------------------------------------------------------------------------}
type
  TUnSortedStringCollection = object(TStringCollection)
    procedure Insert(Item: Pointer); virtual;
  end;
  PUnSortedStringCollection = ^TUnSortedStringCollection;

type
  TStrIndexRec = packed record
    Key, Count, Offset: Word;
  end;

  TStrIndex = array[0..9999] of TStrIndexRec;
  PStrIndex = ^TStrIndex;

  {---------------------------------------------------------------------------}
  {                 TStringList OBJECT - STRING LIST OBJECT                   }
  {---------------------------------------------------------------------------}
  TStringList = object(TObject)
    destructor Done; virtual;
  private
    IndexSize: Sw_Word;
      Index: PStrIndex;
  end;
  PStringList = ^TStringList;

  {---------------------------------------------------------------------------}
  {                 TStrListMaker OBJECT - RESOURCE FILE OBJECT               }
  {---------------------------------------------------------------------------}
type
  TStrListMaker = object(TObject)
    constructor Init(AStrSize, AIndexSize: Sw_Word);
    destructor Done; virtual;
    procedure Put(Key: Sw_Word; s: string);
  private
    StrPos: Sw_Word;
    StrSize: Sw_Word;
    strings: PByteArray;
    IndexPos: Sw_Word;
    IndexSize: Sw_Word;
      Index: PStrIndex;
    cur: TStrIndexRec;
    procedure CloseCurrent;
  end;
  PStrListMaker = ^TStrListMaker;

  {***************************************************************************}
  {                            INTERFACE ROUTINES                             }
  {***************************************************************************}

  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
  {                    DYNAMIC STRING INTERFACE ROUTINES                      }
  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  {-NewStr-------------------------------------------------------------
  Allocates a dynamic string into memory. If S is nil, NewStr returns
  a nil pointer, otherwise NewStr allocates Length(S)+1 bytes of memory
  containing a copy of S, and returns a pointer to the string.
  12Jun96 LdB
  ---------------------------------------------------------------------}
function NewStr(const s: ansistring): PString;

{-DisposeStr---------------------------------------------------------
Disposes of a PString allocated by the function NewStr.
12Jun96 LdB
---------------------------------------------------------------------}
procedure DisposeStr(p: PString);

procedure SetStr(var p: PString; const s: string);

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                        STREAM INTERFACE ROUTINES                          }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{-Abstract-----------------------------------------------------------
Terminates program with a run-time error 211. When implementing
an abstract object type, call Abstract in those virtual methods that
must be overridden in descendant types. This ensures that any
attempt to use instances of the abstract object type will fail.
12Jun96 LdB
---------------------------------------------------------------------}
procedure Abstract;

{-RegisterType-------------------------------------------------------
Registers the given object type with Free Vision's streams, creating
a list of known objects. Streams can only store and return these known
object types. Each registered object needs a unique stream registration
record, of type TStreamRec.
02Sep97 LdB
---------------------------------------------------------------------}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                    GENERAL FUNCTION INTERFACE ROUTINES                    }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{-LongMul------------------------------------------------------------
Returns the long integer value of X * Y integer values.
04Sep97 LdB
---------------------------------------------------------------------}
function LongMul(X, y: Integer): LongInt;

{-LongDiv------------------------------------------------------------
Returns the integer value of long integer X divided by integer Y.
04Sep97 LdB
---------------------------------------------------------------------}
function LongDiv(X: LongInt; y: Integer): Integer;

implementation

{***************************************************************************}
{                      HELPER ROUTINES FOR CALLING                          }
{***************************************************************************}

type
  FramePointer = Pointer;
  PointerLocal = function(_EBP: FramePointer; Param1: Pointer): Pointer;
  PointerConstructor = function(VMT: Pointer; Obj: Pointer; Param1: Pointer): Pointer;
  PointerMethod = function(Obj: Pointer; Param1: Pointer): Pointer;

function CallPointerLocal(func: Pointer; Frame: FramePointer; Param1: Pointer): Pointer;
begin
  CallPointerLocal := PointerLocal(func)(Frame, Param1)
end;

{***************************************************************************}
{                      PRIVATE INITIALIZED VARIABLES                        }
{***************************************************************************}

{---------------------------------------------------------------------------}
{               INITIALIZED DOS/DPMI/WIN/OS2 PRIVATE VARIABLES              }
{---------------------------------------------------------------------------}
const
  StreamTypes: PStreamRec = nil; { Stream types reg }

  {---------------------------------------------------------------------------}
  {  RegisterError -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 12Jun96 LdB    }
  {---------------------------------------------------------------------------}
procedure RegisterError;
begin
  RunError(212); { Register error }
end;

{***************************************************************************}
{                               OBJECT METHODS                              }
{***************************************************************************}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                           TObject OBJECT METHODS                          }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

type
  DummyObject = object(TObject) { Internal object }
    Data: record end; { Helps size VMT link }
  end;

  { ******************************* REMARK ****************************** }
  { I Prefer this code because it self sizes VMT link rather than using a }
  { fixed record structure thus it should work on all compilers without a }
  { specific record to match each compiler.                               }
  { ****************************** END REMARK *** Leon de Boer, 10May96 * }

  {--TObject------------------------------------------------------------------}
  {  Init -> Platforms DOS/DPMI/WIN/OS2 - Checked 10May96 LdB                 }
  {---------------------------------------------------------------------------}
constructor TObject.Init;
var
  LinkSize: LongInt; Dummy: DummyObject;
begin
  LinkSize := LongInt(@Dummy.Data) - LongInt(@Dummy); { Calc VMT link size }
  FillChar(Pointer(LongInt(@Self) + LinkSize)^,
    SizeOf(Self) - LinkSize, #0); { Clear data fields }
end;

{--TObject------------------------------------------------------------------}
{  Free -> Platforms DOS/DPMI/WIN/OS2 - Checked 10May96 LdB                 }
{---------------------------------------------------------------------------}
procedure TObject.Free;
begin
  Dispose(PObject(@Self), Done); { Dispose of self }
end;

{--TObject------------------------------------------------------------------}
{  Is_Object -> Platforms DOS/DPMI/WIN/OS2 - Checked 5Mar00 DM              }
{---------------------------------------------------------------------------}
function TObject.Is_Object(p: Pointer): Boolean;
type
  PVMT = ^VMT;
  VMT = record
    Size, NegSize: LongInt;
    ParentLink: PVMT;
  end;
var
  sp: ^PVMT; Q: PVMT;
begin
  sp := @Self;
  Q := sp^;
  Is_Object := False;
  while Q <> nil do
    begin
      if Q = p then
        begin
          Is_Object := True;
          Break;
        end;
      Q := Q^.ParentLink;
    end;
end;

{--TObject------------------------------------------------------------------}
{  Done -> Platforms DOS/DPMI/WIN/OS2 - Checked 10May96 LdB                 }
{---------------------------------------------------------------------------}
destructor TObject.Done;
begin { Abstract method }
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                       TCollection OBJECT METHODS                          }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{--TCollection--------------------------------------------------------------}
{  Init -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                 }
{---------------------------------------------------------------------------}
constructor TCollection.Init(ALimit, ADelta: Sw_Integer);
begin
  inherited Init; { Call ancestor }
  Delta := ADelta; { Set increment }
  SetLimit(ALimit); { Set limit }
end;

{--TCollection--------------------------------------------------------------}
{  Done -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                 }
{---------------------------------------------------------------------------}
destructor TCollection.Done;
begin
  FreeAll; { Free all items }
  SetLimit(0); { Release all memory }
end;

{--TCollection--------------------------------------------------------------}
{  At -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                   }
{---------------------------------------------------------------------------}
function TCollection.At(Index: Sw_Integer): Pointer;
begin
  if (Index < 0) or (Index >= Count) then
    begin { Invalid index }
      Error(coIndexError, Index); { Call error }
      At := nil; { Return nil }
    end
  else
    At := Items^[Index]; { Return item }
end;

{--TCollection--------------------------------------------------------------}
{  IndexOf -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB              }
{---------------------------------------------------------------------------}
function TCollection.IndexOf(Item: Pointer): Sw_Integer;
var
  i: Sw_Integer;
begin
  if (Count > 0) then
    begin { Count is positive }
      for i := 0 to Count - 1 do { For each item }
        if (Items^[i] = Item) then
          begin { Look for match }
            IndexOf := i; { Return index }
            Exit; { Now exit }
          end;
    end;
  IndexOf := -1; { Return index }
end;

{--TCollection--------------------------------------------------------------}
{  Pack -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                 }
{---------------------------------------------------------------------------}
procedure TCollection.Pack;
var
  i, j: Sw_Integer;
begin
  i := 0; { Initialize dest }
  j := 0; { Intialize test }
  while (i < Count) and (j < Limit) do
    begin { Check fully packed }
      if (Items^[j] <> nil) then
        begin { Found a valid item }
          if (i <> j) then
            begin
              Items^[i] := Items^[j]; { Transfer item }
              Items^[j] := nil; { Now clear old item }
            end;
          Inc(i); { One item packed }
        end;
      Inc(j); { Next item to test }
    end;
  if (i < Count) then Count := i; { New packed count }
end;

{--TCollection--------------------------------------------------------------}
{  FreeAll -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB              }
{---------------------------------------------------------------------------}
procedure TCollection.FreeAll;
var
  i: Sw_Integer;
begin
  for i := Count - 1 downto 0 do
    FreeItem(At(i));
  Count := 0; { Clear item count }
end;

{--TCollection--------------------------------------------------------------}
{  DeleteAll -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB            }
{---------------------------------------------------------------------------}
procedure TCollection.DeleteAll;
begin
  Count := 0; { Clear item count }
end;

{--TCollection--------------------------------------------------------------}
{  Free -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                 }
{---------------------------------------------------------------------------}
procedure TCollection.Free(Item: Pointer);
begin
  Delete(Item); { Delete from list }
  FreeItem(Item); { Free the item }
end;

{--TCollection--------------------------------------------------------------}
{  Insert -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB               }
{---------------------------------------------------------------------------}
procedure TCollection.Insert(Item: Pointer);
begin
  atInsert(Count, Item); { Insert item }
end;

{--TCollection--------------------------------------------------------------}
{  Delete -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB               }
{---------------------------------------------------------------------------}
procedure TCollection.Delete(Item: Pointer);
begin
  atDelete(IndexOf(Item)); { Delete from list }
end;

{--TCollection--------------------------------------------------------------}
{  AtFree -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB               }
{---------------------------------------------------------------------------}
procedure TCollection.atFree(Index: Sw_Integer);
var
  Item: Pointer;
begin
  Item := At(Index); { Retreive item ptr }
  atDelete(Index); { Delete item }
  FreeItem(Item); { Free the item }
end;

{--TCollection--------------------------------------------------------------}
{  FreeItem -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB             }
{---------------------------------------------------------------------------}
procedure TCollection.FreeItem(Item: Pointer);
var
  p: PObject;
begin
  p := PObject(Item); { Convert pointer }
  if (p <> nil) then Dispose(p, Done); { Dispose of object }
end;

{--TCollection--------------------------------------------------------------}
{  AtDelete -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB             }
{---------------------------------------------------------------------------}
procedure TCollection.atDelete(Index: Sw_Integer);
begin
  if (Index >= 0) and (Index < Count) then
    begin { Valid index }
      Dec(Count); { One less item }
      if (Count > Index) then
        Move(Items^[Index + 1],
          Items^[Index], (Count - Index) * SizeOf(Pointer)); { Shuffle items down }
    end
  else
    Error(coIndexError, Index); { Index error }
end;

{--TCollection--------------------------------------------------------------}
{  SetLimit -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB             }
{---------------------------------------------------------------------------}
procedure TCollection.SetLimit(ALimit: Sw_Integer);
var
  AItems: PItemList;
begin
  if (ALimit < Count) then
    ALimit := Count;
  if (ALimit > MaxCollectionSize) then
    ALimit := MaxCollectionSize;
  if (ALimit <> Limit) then
    begin
      if (ALimit = 0) then
        AItems := nil
      else
        begin
          GetMem(AItems, ALimit * SizeOf(Pointer));
          if (AItems <> nil) then
            FillChar(AItems^, ALimit * SizeOf(Pointer), #0);
        end;
      if (AItems <> nil) or (ALimit = 0) then
        begin
          if (AItems <> nil) and (Items <> nil) then
            Move(Items^, AItems^, Count * SizeOf(Pointer));
          if (Limit <> 0) and (Items <> nil) then
            FreeMem(Items, Limit * SizeOf(Pointer));
        end;
      Items := AItems;
      Limit := ALimit;
    end;
end;

{--TCollection--------------------------------------------------------------}
{  Error -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                }
{---------------------------------------------------------------------------}
procedure TCollection.Error(Code, Info: Integer);
begin
  RunError(212 - Code); { Run error }
end;

{--TCollection--------------------------------------------------------------}
{  AtPut -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                }
{---------------------------------------------------------------------------}
procedure TCollection.atPut(Index: Sw_Integer; Item: Pointer);
begin
  if (Index >= 0) and (Index < Count) then { Index valid }
    Items^[Index] := Item { Put item in index }
  else
    Error(coIndexError, Index); { Index error }
end;

{--TCollection--------------------------------------------------------------}
{  AtInsert -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB             }
{---------------------------------------------------------------------------}
procedure TCollection.atInsert(Index: Sw_Integer; Item: Pointer);
var
  i: Sw_Integer;
begin
  if (Index >= 0) and (Index <= Count) then
    begin { Valid index }
      if (Count = Limit) then SetLimit(Limit + Delta); { Expand size if able }
      if (Limit > Count) then
        begin
          if (Index < Count) then
            begin { Not last item }
              for i := Count - 1 downto Index do { Start from back }
                Items^[i + 1] := Items^[i]; { Move each item }
            end;
          Items^[Index] := Item; { Put item in list }
          Inc(Count); { Inc count }
        end
      else
        Error(coOverflow, Index); { Expand failed }
    end
  else
    Error(coIndexError, Index); { Index error }
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                       TSortedCollection OBJECT METHODS                    }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{--TSortedCollection--------------------------------------------------------}
{  Init -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                 }
{---------------------------------------------------------------------------}
constructor TSortedCollection.Init(ALimit, ADelta: Sw_Integer);
begin
  inherited Init(ALimit, ADelta); { Call ancestor }
  Duplicates := False; { Clear flag }
end;

{--TSortedCollection--------------------------------------------------------}
{  KeyOf -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB                }
{---------------------------------------------------------------------------}
function TSortedCollection.KeyOf(Item: Pointer): Pointer;
begin
  KeyOf := Item; { Return item as key }
end;

{--TSortedCollection--------------------------------------------------------}
{  IndexOf -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB              }
{---------------------------------------------------------------------------}
function TSortedCollection.IndexOf(Item: Pointer): Sw_Integer;
var
  i, j: Sw_Integer;
begin
  j := -1; { Preset result }
  if Search(KeyOf(Item), i) then
    begin { Search for item }
      if Duplicates then { Duplicates allowed }
        while (i < Count) and (Item <> Items^[i]) do
          Inc(i); { Count duplicates }
      if (i < Count) then j := i; { Index result }
    end;
  IndexOf := j; { Return result }
end;

{--TSortedCollection--------------------------------------------------------}
{  Compare -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB              }
{---------------------------------------------------------------------------}
function TSortedCollection.Compare(Key1, Key2: Pointer): Sw_Integer;
begin
  Abstract; { Abstract method }
  Compare := 0;
end;

{--TSortedCollection--------------------------------------------------------}
{  Search -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB               }
{---------------------------------------------------------------------------}
function TSortedCollection.Search(Key: Pointer; var Index: Sw_Integer): Boolean;
var
  l, h, i, c: Sw_Integer;
begin
  Search := False; { Preset failure }
  l := 0; { Start count }
  h := Count - 1; { End count }
  while (l <= h) do
    begin
      i := (l + h) shr 1; { Mid point }
      c := Compare(KeyOf(Items^[i]), Key); { Compare with key }
      if (c < 0) then
        l := i + 1
      else
        begin { Item to left }
          h := i - 1; { Item to right }
          if c = 0 then
            begin { Item match found }
              Search := True; { Result true }
              if not Duplicates then l := i; { Force kick out }
            end;
        end;
    end;
  Index := l; { Return result }
end;

{--TSortedCollection--------------------------------------------------------}
{  Insert -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB               }
{---------------------------------------------------------------------------}
procedure TSortedCollection.Insert(Item: Pointer);
var
  i: Sw_Integer;
begin
  if not Search(KeyOf(Item), i) or Duplicates then { Item valid }
    atInsert(i, Item); { Insert the item }
end;

{--TStringCollection--------------------------------------------------------}
{  Compare -> Platforms DOS/DPMI/WIN/OS2 - Checked 21Aug97 LdB              }
{---------------------------------------------------------------------------}
function TStringCollection.Compare(Key1, Key2: Pointer): Sw_Integer;
var
  i, j: Sw_Integer; p1, p2: PString;
begin
  p1 := PString(Key1); { String 1 pointer }
  p2 := PString(Key2); { String 2 pointer }
  if (Length(p1^) < Length(p2^)) then
    j := Length(p1^)
  else
    j := Length(p2^); { Shortest length }
  i := 1; { First character }
  while (i < j) and (p1^[i] = p2^[i]) do
    Inc(i); { Scan till fail }
  if (i = j) then
    begin { Possible match }
      { * REMARK * - Bug fix   21 August 1997 }
      if (p1^[i] < p2^[i]) then
        Compare := -1
      else { String1 < String2 }
        if (p1^[i] > p2^[i]) then
          Compare := 1
        else { String1 > String2 }
          if (Length(p1^) > Length(p2^)) then
            Compare := 1 { String1 > String2 }
          else
            if (Length(p1^) < Length(p2^)) then { String1 < String2 }
              Compare := -1
            else
              Compare := 0; { String1 = String2 }
      { * REMARK END * - Leon de Boer }
    end
  else
    if (p1^[i] < p2^[i]) then
      Compare := -1 { String1 < String2 }
    else
      Compare := 1; { String1 > String2 }
end;

{--TStringCollection--------------------------------------------------------}
{  FreeItem -> Platforms DOS/DPMI/WIN/OS2 - Checked 22May96 LdB             }
{---------------------------------------------------------------------------}
procedure TStringCollection.FreeItem(Item: Pointer);
begin
  DisposeStr(Item); { Dispose item }
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                   TUnSortedStrCollection OBJECT METHODS                   }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{--TUnSortedCollection------------------------------------------------------}
{  Insert -> Platforms DOS/DPMI/WIN/OS2 - Checked 23May96 LdB               }
{---------------------------------------------------------------------------}
procedure TUnSortedStringCollection.Insert(Item: Pointer);
begin
  atInsert(Count, Item); { Insert - NO sorting }
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                           TResourceItem RECORD                            }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
type
  TResourceItem = packed record
    Posn: LongInt; { Resource position }
    Size: LongInt; { Resource size }
    Key: string; { Resource key }
  end;
  PResourceItem = ^TResourceItem;

  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
  {                  PRIVATE RESOURCE MANAGER CONSTANTS                       }
  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
const
  RStreamMagic: LongInt = $52504246; { 'FBPR' }
  RStreamBackLink: LongInt = $4C424246; { 'FBBL' }

  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
  {                    PRIVATE RESOURCE MANAGER TYPES                         }
  {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
type
  {$IFDEF NewExeFormat} { New EXE format }
  TExeHeader = packed record
    eHdrSize: Word;
    eMinAbove: Word;
    eMaxAbove: Word;
    eInitSS: Word;
    eInitSP: Word;
    eCheckSum: Word;
    eInitPC: Word;
    eInitCS: Word;
    eRelocOfs: Word;
    eOvlyNum: Word;
    eRelocTab: Word;
    eSpace: array[1..30] of Byte;
    eNewHeader: Word;
  end;
  {$ENDIF}

  THeader = packed record
    Signature: Word;
    case Integer of
      0: (
        LastCount: Word;
        PageCount: Word;
        ReloCount: Word);
      1: (
        InfoType: Word;
        InfoSize: LongInt);
  end;

  {--TStringList--------------------------------------------------------------}
  {  Done -> Platforms DOS/DPMI/WIN/OS2 - Checked 30Jun97 LdB                 }
  {---------------------------------------------------------------------------}
destructor TStringList.Done;
begin
  FreeMem(Index, IndexSize * SizeOf(TStrIndexRec)); { Release memory }
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                         TStrListMaker OBJECT METHODS                      }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{--TStrListMaker------------------------------------------------------------}
{  Init -> Platforms DOS/DPMI/WIN/OS2 - Checked 30Jun97 LdB                 }
{---------------------------------------------------------------------------}
constructor TStrListMaker.Init(AStrSize, AIndexSize: Sw_Word);
begin
  inherited Init; { Call ancestor }
  StrSize := AStrSize; { Hold size }
  IndexSize := AIndexSize; { Hold index size }
  GetMem(strings, AStrSize); { Allocate memory }
  GetMem(Index, AIndexSize * SizeOf(TStrIndexRec)); { Allocate memory }
end;

{--TStrListMaker------------------------------------------------------------}
{  Done -> Platforms DOS/DPMI/WIN/OS2 - Checked 30Jun97 LdB                 }
{---------------------------------------------------------------------------}
destructor TStrListMaker.Done;
begin
  FreeMem(Index, IndexSize * SizeOf(TStrIndexRec)); { Free index memory }
  FreeMem(strings, StrSize); { Free data memory }
end;

{--TStrListMaker------------------------------------------------------------}
{  Put -> Platforms DOS/DPMI/WIN/OS2 - Checked 30Jun97 LdB                  }
{---------------------------------------------------------------------------}
procedure TStrListMaker.Put(Key: Sw_Word; s: string);
begin
  if (cur.Count = 16) or (Key <> cur.Key + cur.Count) then CloseCurrent; { Close current }
  if (cur.Count = 0) then
    begin
      cur.Key := Key; { Set key }
      cur.Offset := StrPos; { Set offset }
    end;
  Inc(cur.Count); { Inc count }
  Move(s, strings^[StrPos], Length(s) + 1); { Move string data }
  Inc(StrPos, Length(s) + 1); { Adjust position }
end;

{***************************************************************************}
{                      TStrListMaker PRIVATE METHODS                        }
{***************************************************************************}

{--TStrListMaker------------------------------------------------------------}
{  CloseCurrent -> Platforms DOS/DPMI/WIN/OS2 - Checked 30Jun97 LdB         }
{---------------------------------------------------------------------------}
procedure TStrListMaker.CloseCurrent;
begin
  if (cur.Count <> 0) then
    begin
      Index^[IndexPos] := cur; { Hold index position }
      Inc(IndexPos); { Next index }
      cur.Count := 0; { Adjust count }
    end;
end;

{***************************************************************************}
{                            INTERFACE ROUTINES                             }
{***************************************************************************}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                    DYNAMIC STRING INTERFACE ROUTINES                      }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{---------------------------------------------------------------------------}
{  NewStr -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 12Jun96 LdB           }
{---------------------------------------------------------------------------}
function NewStr(const s: ansistring): PString;
begin
  if (s = '') then
    Result := nil
  else
    begin { Return nil }
      GetMem(Result, Length(s) + 1); { Allocate memory }
      if (Result <> nil) then Result^ := s; { Hold string }
    end;
end;

{---------------------------------------------------------------------------}
{  DisposeStr -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 12Jun96 LdB       }
{---------------------------------------------------------------------------}
procedure DisposeStr(p: PString);
begin
  if (p <> nil) then FreeMem(p, Length(p^) + 1); { Release memory }
end;

procedure SetStr(var p: PString; const s: string);
begin
  if p <> nil then
    FreeMem(p, Length(p^) + 1);
  GetMem(p, Length(s) + 1);
  PString(p)^ := s
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                        STREAM INTERFACE ROUTINES                          }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{---------------------------------------------------------------------------}
{  Abstract -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 12Jun96 LdB         }
{---------------------------------------------------------------------------}
procedure Abstract;
begin
  RunError(211); { Abstract error }
end;

{---------------------------------------------------------------------------}
{  RegisterType -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 02Sep97 LdB     }
{---------------------------------------------------------------------------}
(*procedure RegisterType(var s: TStreamRec);
var
  p: PStreamRec;
begin
  p := StreamTypes; { Current reg list }
  while (p <> nil) and (p^.ObjType <> s.ObjType) do
    p := p^.Next; { Find end of chain }
  if (p = nil) and (s.ObjType <> 0) then
    begin { Valid end found }
      s.Next := StreamTypes; { Chain the list }
      StreamTypes := @s; { We are now first }
    end
  else
    RegisterError; { Register the error }
end;*)

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{                    GENERAL FUNCTION INTERFACE ROUTINES                    }
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{---------------------------------------------------------------------------}
{  LongMul -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 04Sep97 LdB          }
{---------------------------------------------------------------------------}
function LongMul(X, y: Integer): LongInt;
begin
  LongMul := LongInt(X * y);
end;
{---------------------------------------------------------------------------}
{  LongDiv -> Platforms DOS/DPMI/WINDOWS/OS2 - Checked 04Sep97 LdB          }
{---------------------------------------------------------------------------}
function LongDiv(X: LongInt; y: Integer): Integer;
begin
  LongDiv := Integer(X div y);
end;

end.

