{
@abstract(simple routines to print messages regarding verbosity settings)
@created(28 Aug 1999)
@lastmod(10 Apr 2000)
@author(Marco Schmidt (marcoschmidt@geocities.com))

The procedures @link(Print) and @link(PrintLn) write their respective
string parameters to standard output (usually the console / shell) if the
integer parameters of these routines are larger than or equal to the
current verbosity level.
This level can be queried with @link(GetVerbosityLevel) and modified with
@link(SetVerbosityLevel).
}
unit Msg;

{$I platform.inc}

interface

const
  DEFAULT_VERBOSITY_LEVEL = 2;

  { Returns current verbosity level as an integer value larger than or equal to
    zero.
    The smaller this number is, the less information will be printed in the
    application.}
function GetVerbosityLevel: Integer;
{ If L is smaller than or equal to @link(GetVerbosityLevel), S is written
  to standard out using the System.Write procedure. }
procedure Print(l: Integer; const s: string);
{ If L is smaller than or equal to @link(GetVerbosityLevel), S is written
  to standard out using the System.WriteLn procedure. }
procedure PrintLn(l: Integer; const s: string);
{ Sets the verbosity level to NewLevel, which must be larger than or equal to
  zero.
  The smaller this number is, the less information will be printed in the
  application. }
procedure SetVerbosityLevel(const NewLevel: Integer);

implementation

var
  VerbosityLevel: Integer = DEFAULT_VERBOSITY_LEVEL;

function GetVerbosityLevel: Integer;
begin
  GetVerbosityLevel := VerbosityLevel;
end;

procedure Print(l: Integer; const s: string);
begin
  if (l <= VerbosityLevel) and (l >= 1) then Write(s);
end;

procedure PrintLn(l: Integer; const s: string);
begin
  if (l <= VerbosityLevel) and (l >= 1) then WriteLn(s);
end;

procedure SetVerbosityLevel(const NewLevel: Integer);
begin
  if (NewLevel >= 0) then VerbosityLevel := NewLevel;
end;

end.

