{ @abstract(Contains language definitions and translations.)
  @author(Ralf Junker <delphi@zeitungsjunge.de>)
  @author(Ivan Montes Velencoso (Catalan and Spanish translations))
  @author(Jean Dit Bailleul (Frensh translation))
  @author(Marc Weustinks (Dutch translation))
  @author(Martin Hansen <mh@geus.dk> (Danish translation))
  @author(Peter imkovi <simkovic_jr@manal.sk> (Slovak translation))
  @author(Rodrigo Urubatan Ferreira Jardim <rodrigo@netscape.net> (Brasilian translation))
  @author(Michele Bersini <michele.bersini@smartit.it> (Italian translation))
  @author(Vitaly Kovalenko <v_l_kovalenko@alsy.by> (Russian translation))
  @author(Alexander Lisnevsky <alisnevsky@yandex.ru> (Russian translation))
  @author(Peter Thrnqvist <pt@timemetrics.se> (Swedish translation))  }

unit Languages;

interface

{$I platform.inc}

{ }
procedure SetLanguageBrasilian;
{ }
procedure SetLanguageCatalan;
{ }
procedure SetLanguageDanish;
{ }
procedure SetLanguageDutch;
{ }
procedure SetLanguageEnglish;
{ }
procedure SetLanguageFrench;
{ }
procedure SetLanguageGerman;
{ }
procedure SetLanguageItalian;
{ }
procedure SetLanguagePolish;
{ }
procedure SetLanguageRussian_1251;
{ }
procedure SetLanguageRussian_866;
{ }
procedure SetLanguageRussian_koi8;
{ }
procedure SetLanguageSlovak;
{ }
procedure SetLanguageSpanish;
{ }
procedure SetLanguageSwedish;

type
  { An enumeration type of all supported languages.
    Should always be kept in alphabetical order. }
  TLanguageID = (
    lgBrasilian,
    lgCatalan,
    lgDanish,
    lgDutch,
    lgEnglish,
    lgFrench,
    lgGerman,
    lgItalian,
    lgPolish,
    lgRussian_1251,
    lgRussian_866,
    lgRussian_koi8,
    lgSlovak,
    lgSpanish,
    lgSwedish);

  TSetLanguageProc = procedure;

  TLanguageRecord = record
    Name: AnsiString;
    Syntax: AnsiString;
    CharSet: AnsiString;
    proc: TSetLanguageProc;
  end;

const
  LANGUAGE_ARRAY: array[TLanguageID] of TLanguageRecord = (
    (Name: 'Brasilian'; Syntax: 'br'; CharSet: ''; proc: SetLanguageBrasilian),
    (Name: 'Catalan'; Syntax: 'cat'; CharSet: ''; proc: SetLanguageCatalan),
    (Name: 'Danish'; Syntax: 'dk'; CharSet: ''; proc: SetLanguageDanish),
    (Name: 'Dutch'; Syntax: 'nl'; CharSet: ''; proc: SetLanguageDutch),
    (Name: 'English'; Syntax: 'e'; CharSet: ''; proc: SetLanguageEnglish),
    (Name: 'Frensh'; Syntax: 'fr'; CharSet: ''; proc: SetLanguageFrench),
    (Name: 'German'; Syntax: 'de'; CharSet: ''; proc: SetLanguageGerman),
    (Name: 'Italian'; Syntax: 'it'; CharSet: ''; proc: SetLanguageItalian),
    (Name: 'Polish'; Syntax: 'pl'; CharSet: ''; proc: SetLanguagePolish),
    (Name: 'Russian (Codepage 1251)'; Syntax: 'ru1251'; CharSet: 'windows-1251'; proc: SetLanguageRussian_1251),
    (Name: 'Russian (Codepage 866)'; Syntax: 'ru866'; CharSet: 'IBM866'; proc: SetLanguageRussian_866),
    (Name: 'Russian (KOI-8)'; Syntax: 'ruKOI8'; CharSet: 'koi8-r'; proc: SetLanguageRussian_koi8),
    (Name: 'Slovak'; Syntax: 'sk'; CharSet: ''; proc: SetLanguageSlovak),
    (Name: 'Spanish'; Syntax: 'es'; CharSet: ''; proc: SetLanguageSpanish),
    (Name: 'Swedish'; Syntax: 'se'; CharSet: ''; proc: SetLanguageSwedish));

  DEFAULT_LANGUAGE = lgEnglish;

type
  { An enumeration type of all static output texts. }
  TTranslationID = (
    trAuthor,
    trAuthors,
    trCio,
    trClass,
    trClasses,
    trConstants,
    trCreated,
    trDeclaration,
    trDescription,
    trDispInterface,
    trFields,
    trFunctionsAndProcedures,
    trHelp,
    trHierarchy,
    trIdentifiers,
    trInterface,
    trLegend,
    trMethods,
    trLastModified,
    trName,
    trNone,
    trObject,
    trObjects,
    trOverview,
    trPrivate,
    trProperties,
    trProtected,
    trPublic,
    trPublished,
    trType,
    trTypes,
    trUnit,
    trUnits,
    trVariables,

    trHeadlineCio,
    trHeadlineConstants,
    trHeadlineFunctionsAndProcedures,
    trHeadlineIdentifiers,
    trHeadlineTypes,
    trHeadlineUnits,
    trHeadlineVariables,

    trSummaryCio,

    trWarningOverwrite);

var
  Translation: array[TTranslationID] of AnsiString;

implementation

procedure SetLanguageEnglish;
begin
  Translation[trAuthor] := 'Author';
  Translation[trAuthors] := 'Authors';
  Translation[trCio] := 'Classes, Interfaces and Objects';
  Translation[trClass] := 'Class';
  Translation[trClasses] := 'Classes';
  Translation[trConstants] := 'Constants';
  Translation[trCreated] := 'Created';
  Translation[trDeclaration] := 'Declaration';
  Translation[trDescription] := 'Description';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Fields';
  Translation[trFunctionsAndProcedures] := 'Functions and Procedures';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Hierarchy';
  Translation[trIdentifiers] := 'Identifiers';
  Translation[trInterface] := 'Interface';
  Translation[trLegend] := 'Legend';
  Translation[trMethods] := 'Methods';
  Translation[trLastModified] := 'Last Modified';
  Translation[trName] := 'Name';
  Translation[trNone] := 'None';
  Translation[trObject] := 'Object';
  Translation[trObjects] := 'Objects';
  Translation[trOverview] := 'Overview';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Properties';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Type';
  Translation[trTypes] := 'Types';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variables';

  Translation[trHeadlineCio] := 'All Classes, Interfaces and Objects';
  Translation[trHeadlineConstants] := 'All Constants';
  Translation[trHeadlineFunctionsAndProcedures] := 'All Functions and Procedures';
  Translation[trHeadlineIdentifiers] := 'All Identifiers';
  Translation[trHeadlineTypes] := 'All Types';
  Translation[trHeadlineUnits] := 'All Units';
  Translation[trHeadlineVariables] := 'All Variables';

  Translation[trSummaryCio] := 'Summary of Classes, Interfaces and Objects';

  Translation[trWarningOverwrite] := 'Warning: Do not edit - this file has been created automatically and is likely be overwritten';
end;

{ ---------- }

procedure SetLanguageBrasilian;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autores';
  Translation[trCio] := 'Classes, Interfaces e Objetos';
  Translation[trClass] := 'Classe';
  Translation[trClasses] := 'Classes';
  Translation[trConstants] := 'Constantes';
  Translation[trCreated] := 'Criado';
  Translation[trDeclaration] := 'Declarao';
  Translation[trDescription] := 'Descrio';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Campos';
  Translation[trFunctionsAndProcedures] := 'Funes e Procedimentos';
  Translation[trHelp] := 'Ajuda';
  Translation[trHierarchy] := 'Hierarquia';
  Translation[trIdentifiers] := 'Identificadores';
  Translation[trInterface] := 'Interface';
  Translation[trLegend] := 'Legenda';
  Translation[trLastModified] := 'ltima modificao';
  Translation[trMethods] := 'Mtodos';
  Translation[trName] := 'Nome';
  Translation[trNone] := 'Nenhum';
  Translation[trObject] := 'Objeto';
  Translation[trObjects] := 'Objetos';
  Translation[trOverview] := 'Viso geral';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Propriedades';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Tipo';
  Translation[trTypes] := 'Tipos';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Unit';
  Translation[trVariables] := 'Variveis';
  Translation[trWarningOverwrite] := 'Aviso, no altere - este arquivo foi gerado automaticamente e ser sobrescrito';

  Translation[trHeadlineCio] := 'Todas as classes, interfaces e objetos';
  Translation[trHeadlineConstants] := 'Todas as constantes';
  Translation[trHeadlineFunctionsAndProcedures] := 'Todas as funes e procedimentos';
  Translation[trHeadlineIdentifiers] := 'Todos os identificadores';
  Translation[trHeadlineTypes] := 'Todos os tipos';
  Translation[trHeadlineUnits] := 'Todos as units';
  Translation[trHeadlineVariables] := 'Todas as variveis';

  Translation[trSummaryCio] := 'Lista de classes, interfaces e objetos';
end;

{ ---------- }

procedure SetLanguageCatalan;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autors';
  Translation[trCio] := 'Clases, interfaces i objectes';
  Translation[trClass] := 'Clase';
  Translation[trClasses] := 'Clases';
  Translation[trConstants] := 'Constants';
  Translation[trCreated] := 'Creat';
  Translation[trDeclaration] := 'Declaraci';
  Translation[trDescription] := 'Descripci';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Camps';
  Translation[trFunctionsAndProcedures] := 'Funcions i procediments';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Hierarchy';
  Translation[trIdentifiers] := 'Identificadors';
  Translation[trInterface] := 'Interface';
  Translation[trLastModified] := 'ltima modificaci';
  Translation[trLegend] := 'Legend';
  Translation[trMethods] := 'Mtodes';
  Translation[trName] := 'Nom';
  Translation[trNone] := 'Ningu';
  Translation[trObject] := 'Objecte';
  Translation[trObjects] := 'Objectes';
  Translation[trOverview] := 'Resum';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Propietats';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Tipus';
  Translation[trTypes] := 'Tipus';
  Translation[trUnit] := 'Unitat';
  Translation[trUnits] := 'Unitats';
  Translation[trVariables] := 'Variables';
  Translation[trWarningOverwrite] := 'Atenci, no editar - aquest fitxer ha estat creat automaticament i ser sobrescrit';

  Translation[trHeadlineCio] := 'Totes les clases, interfaces i objectes';
  Translation[trHeadlineConstants] := 'Totes les constants';
  Translation[trHeadlineFunctionsAndProcedures] := 'Totes les funcions i procediments';
  Translation[trHeadlineIdentifiers] := 'Tot els indentificadors';
  Translation[trHeadlineTypes] := 'Tots els tipus';
  Translation[trHeadlineUnits] := 'Totes les unitats';
  Translation[trHeadlineVariables] := 'Totes les variables';

  Translation[trSummaryCio] := 'Llista de clases, interfaces i objectes';
end;

{ ---------- }

procedure SetLanguageDanish;
begin
  Translation[trAuthor] := 'Forfatter';
  Translation[trAuthors] := 'Forfatre';
  Translation[trCio] := 'Klasser, interfaces og objekter';
  Translation[trClass] := 'Klasse';
  Translation[trClasses] := 'Klasser';
  Translation[trConstants] := 'Konstanter';
  Translation[trCreated] := 'Udfrt';
  Translation[trDeclaration] := 'Declaration';
  Translation[trDescription] := 'Beskrivelse';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Felter';
  Translation[trFunctionsAndProcedures] := 'Funktioner og prosedurer';
  Translation[trHelp] := 'Hjlp';
  Translation[trHierarchy] := 'Herarki';
  Translation[trIdentifiers] := 'Identifiers';
  Translation[trInterface] := 'Interface';
  Translation[trLegend] := 'Legende';
  Translation[trLastModified] := 'Sidst Modificieret';
  Translation[trMethods] := 'Metoder';
  Translation[trName] := 'Navn';
  Translation[trNone] := 'Ingen';
  Translation[trObject] := 'Objekt';
  Translation[trObjects] := 'Objekter';
  Translation[trOverview] := 'Sammendrag';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Egenskaber';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Type';
  Translation[trTypes] := 'Typer';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variable';
  Translation[trWarningOverwrite] := 'Advarsel: Editer ikke denne fil, den er autogeneret og vil sansylgvis blive overskret';

  Translation[trHeadlineCio] := 'Alle Klasesr, Interfaces og Objekter';
  Translation[trHeadlineConstants] := 'Alle Konstanter';
  Translation[trHeadlineFunctionsAndProcedures] := 'Alle Functioner and Procedurer';
  Translation[trHeadlineIdentifiers] := 'Alle Identifiers';
  Translation[trHeadlineTypes] := 'Alle Typer';
  Translation[trHeadlineUnits] := 'Alle Units';
  Translation[trHeadlineVariables] := 'Alle Variable';

  Translation[trSummaryCio] := 'Oversigt over klasser, interfaces & objekter';
end;

{ ---------- }

procedure SetLanguageDutch;
begin
  Translation[trAuthor] := 'Auteur';
  Translation[trAuthors] := 'Auteurs';
  Translation[trCio] := 'Classes, interfaces and objecten';
  Translation[trClass] := 'Class';
  Translation[trClasses] := 'Classes';
  Translation[trConstants] := 'Constanten';
  Translation[trCreated] := 'Gemaakt';
  Translation[trDeclaration] := 'Declaratie';
  Translation[trDescription] := 'Omschrijving';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Velden';
  Translation[trFunctionsAndProcedures] := 'Functies en procedures';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Hierarchie';
  Translation[trIdentifiers] := 'Identifiers';
  Translation[trInterface] := 'Interface';
  Translation[trLastModified] := 'Laatste wijziging';
  Translation[trLegend] := 'Legend';
  Translation[trMethods] := 'Methods';
  Translation[trName] := 'Naam';
  Translation[trNone] := 'Geen';
  Translation[trObject] := 'Object';
  Translation[trObjects] := 'Objecten';
  Translation[trOverview] := 'Overzicht';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Eigenschappen';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Type';
  Translation[trTypes] := 'Typen';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variabelen';
  Translation[trWarningOverwrite] := 'Waarschuwing, wijzig niets - dit bestand is automatisch gegenereerd en zal worden overschreven';

  Translation[trHeadlineCio] := 'Alle classes, interfaces en objecten';
  Translation[trHeadlineConstants] := 'Alle constanten';
  Translation[trHeadlineFunctionsAndProcedures] := 'Alle functies en procedures';
  Translation[trHeadlineIdentifiers] := 'Alle identifiers';
  Translation[trHeadlineTypes] := 'Alle typen';
  Translation[trHeadlineUnits] := 'Alle units';
  Translation[trHeadlineVariables] := 'Alle variabelen';

  Translation[trSummaryCio] := 'Overzicht van classes, interfaces & objecten';
end;

{ ---------- }

procedure SetLanguageFrench;
begin
  Translation[trAuthor] := 'Auteur';
  Translation[trAuthors] := 'Auteurs';
  Translation[trCio] := 'Classes, interfaces and objects';
  Translation[trClass] := 'Classe';
  Translation[trClasses] := 'Classes';
  Translation[trConstants] := 'Constantes';
  Translation[trCreated] := 'Cre';
  Translation[trDeclaration] := 'Dclaration';
  Translation[trDescription] := 'Description';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Champs';
  Translation[trFunctionsAndProcedures] := 'Fonctions et procdures';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Hierarchy';
  Translation[trIdentifiers] := 'Identificateurs';
  Translation[trInterface] := 'Interface';
  Translation[trLastModified] := 'Dernire modification';
  Translation[trLegend] := 'Legend';
  Translation[trMethods] := 'Mthodes';
  Translation[trName] := 'Nom';
  Translation[trNone] := 'Aucun(e)(s)';
  Translation[trObject] := 'Objet';
  Translation[trObjects] := 'Objets';
  Translation[trOverview] := 'Aperu';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Proprits';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Type';
  Translation[trTypes] := 'Types';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variables';
  Translation[trWarningOverwrite] := 'Attention, ne pas dtier - ce fichier est cr automatiquement et va tre cras';

  Translation[trHeadlineCio] := 'Toutes les classes, interfaces et objets';
  Translation[trHeadlineConstants] := 'Toutes les constants';
  Translation[trHeadlineFunctionsAndProcedures] := 'Toutes les fonctions et procdures';
  Translation[trHeadlineIdentifiers] := 'Tous les identificateurs';
  Translation[trHeadlineTypes] := 'Tous les types';
  Translation[trHeadlineUnits] := 'Toutes les units';
  Translation[trHeadlineVariables] := 'Toutes les variables';

  Translation[trSummaryCio] := 'Classes, interfaces & objets';
end;

{ ---------- }

procedure SetLanguageGerman;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autoren';
  Translation[trCio] := 'Klassen, Schnittstellen und Objekte';
  Translation[trClass] := 'Klasse';
  Translation[trClasses] := 'Klassen';
  Translation[trConstants] := 'Konstanten';
  Translation[trCreated] := 'Erstellt';
  Translation[trDeclaration] := 'Deklaration';
  Translation[trDescription] := 'Beschreibung';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Felder';
  Translation[trFunctionsAndProcedures] := 'Funktionen und Prozeduren';
  Translation[trHelp] := 'Hilfe';
  Translation[trHierarchy] := 'Hierarchie';
  Translation[trIdentifiers] := 'Bezeichner';
  Translation[trInterface] := 'Schnittstelle';
  Translation[trLastModified] := 'Letzte nderung';
  Translation[trLegend] := 'Legende';
  Translation[trMethods] := 'Methoden';
  Translation[trName] := 'Name';
  Translation[trNone] := 'Keine';
  Translation[trObject] := 'Objekt';
  Translation[trObjects] := 'Objekte';
  Translation[trOverview] := 'bersicht';
  Translation[trPrivate] := 'Privat';
  Translation[trProperties] := 'Eigenschaften';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trTypes] := 'Typen';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variablen';
  Translation[trType] := 'Typ';
  Translation[trTypes] := 'Typen';

  Translation[trHeadlineCio] := 'Alle Klassen, Schnittstellen und Objekte';
  Translation[trHeadlineConstants] := 'Alle Konstanten';
  Translation[trHeadlineFunctionsAndProcedures] := 'Alle Funktionen und Prozeduren';
  Translation[trHeadlineIdentifiers] := 'Alle Bezeichner';
  Translation[trHeadlineTypes] := 'Alle Typen';
  Translation[trHeadlineUnits] := 'Alle Units';
  Translation[trHeadlineVariables] := 'Alle Variablen';

  Translation[trWarningOverwrite] := 'Achtung: Nicht ndern - diese Datei wurde automatisch erstellt und wird mglicherweise berschrieben';
end;

{ ---------- }

procedure SetLanguageItalian;
begin
  Translation[trAuthor] := 'Autore';
  Translation[trAuthors] := 'Autori';
  Translation[trCio] := 'Classi, Interfacce ed Oggetti';
  Translation[trClass] := 'Classe';
  Translation[trClasses] := 'Classi';
  Translation[trConstants] := 'Costanti';
  Translation[trCreated] := 'Creato';
  Translation[trDeclaration] := 'Dichiarazione';
  Translation[trDescription] := 'Descrizione';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Campi';
  Translation[trFunctionsAndProcedures] := 'Funzioni e Procedure';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Gerarchia';
  Translation[trIdentifiers] := 'Identificatori';
  Translation[trInterface] := 'Interfacce';
  Translation[trLegend] := 'Legenda';
  Translation[trMethods] := 'Metodi';
  Translation[trLastModified] := 'Ultima Variazione';
  Translation[trName] := 'Nome';
  Translation[trNone] := 'Nessuno';
  Translation[trObject] := 'Oggetto';
  Translation[trObjects] := 'Oggetti';
  Translation[trOverview] := 'Sommario';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Propriet';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Tipo';
  Translation[trTypes] := 'Tipi';
  Translation[trUnit] := 'Unit';
  Translation[trUnits] := 'Units';
  Translation[trVariables] := 'Variabili';

  Translation[trHeadlineCio] := 'Tutte le Classi, Interfacce ed Oggetti';
  Translation[trHeadlineConstants] := 'Tutte le Costanti';
  Translation[trHeadlineFunctionsAndProcedures] := 'Tutte le Funzioni e Procedure';
  Translation[trHeadlineIdentifiers] := 'Tutti gli Identificatori';
  Translation[trHeadlineTypes] := 'Tutti i Tipi';
  Translation[trHeadlineUnits] := 'Tutte le Units';
  Translation[trHeadlineVariables] := 'Tutte le Variabili';

  Translation[trSummaryCio] := 'Sommario di Classi, Interfacce ed Oggetti';

  Translation[trWarningOverwrite] := 'Attenzione: Non modificare - questo file  stato generato automaticamente e verr probabilmente sovrascritto';
end;

{ ---------- }

procedure SetLanguagePolish;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autorzy';
  Translation[trCio] := 'Klasy, Interfejsy i Obiekty';
  Translation[trClass] := 'Klasa';
  Translation[trClasses] := 'Klasy';
  Translation[trConstants] := 'Stae';
  Translation[trCreated] := 'Utworzony';
  Translation[trDeclaration] := 'Deklaracja';
  Translation[trDescription] := 'Opis';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Pola';
  Translation[trFunctionsAndProcedures] := 'Funkcje i Procedury';
  Translation[trHelp] := 'Pomoc';
  Translation[trHierarchy] := 'Hierarchia';
  Translation[trIdentifiers] := 'Identyfikatory';
  Translation[trInterface] := 'Interfejs';
  Translation[trLegend] := 'Legenda';
  Translation[trMethods] := 'Metody';
  Translation[trLastModified] := 'Ostatnia modyfikacja';
  Translation[trName] := 'Nazwa';
  Translation[trNone] := 'Brak';
  Translation[trObject] := 'Obiekt';
  Translation[trObjects] := 'Obiekty';
  Translation[trOverview] := 'Przegld';
  Translation[trPrivate] := 'Prywatne';
  Translation[trProperties] := 'Waciwoci';
  Translation[trProtected] := 'Chronione';
  Translation[trPublic] := 'Publiczne';
  Translation[trPublished] := 'Publikowane';
  Translation[trType] := 'Typ';
  Translation[trTypes] := 'Typy';
  Translation[trUnit] := 'Modu';
  Translation[trUnits] := 'Moduy';
  Translation[trVariables] := 'Zmienne';

  Translation[trHeadlineCio] := 'Wszystkie Klasy, Interfejsy i Obiekty';
  Translation[trHeadlineConstants] := 'Wszystkie Stae';
  Translation[trHeadlineFunctionsAndProcedures] := 'Wszystkie Funkcje i Procedury';
  Translation[trHeadlineIdentifiers] := 'Wszystkie Identyfikatory';
  Translation[trHeadlineTypes] := 'Wszystkie typy';
  Translation[trHeadlineUnits] := 'Wszystkie moduy';
  Translation[trHeadlineVariables] := 'Wszystkie zmienne';

  Translation[trSummaryCio] := 'Strzeszczenie Klas, Interfejsw i Obiektw';

  Translation[trWarningOverwrite] := 'Uwaga, nie edytuj - ten plik zosta wygenerowany przez automat i moe zosta nadpisany';
end;

{ ---------- }

procedure SetLanguageRussian_1251;
begin
  Translation[trAuthor] := '';
  Translation[trAuthors] := '';
  Translation[trCio] := ',   ';
  Translation[trClass] := '';
  Translation[trClasses] := '';
  Translation[trConstants] := '';
  Translation[trCreated] := '';
  Translation[trDeclaration] := '';
  Translation[trDescription] := '';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := '';
  Translation[trFunctionsAndProcedures] := '  ';
  Translation[trHelp] := 'Help'; // Untranslated to avoid Russian file name for css
  Translation[trHierarchy] := '';
  Translation[trIdentifiers] := '';
  Translation[trInterface] := '';
  Translation[trLegend] := '';
  Translation[trLastModified] := ' ';
  Translation[trMethods] := '';
  Translation[trName] := '';
  Translation[trNone] := '';
  Translation[trObject] := '';
  Translation[trObjects] := '';
  Translation[trOverview] := '';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := '';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := '';
  Translation[trTypes] := '';
  Translation[trUnit] := '';
  Translation[trUnits] := '';
  Translation[trVariables] := '';
  Translation[trWarningOverwrite] := ':   -          ';

  Translation[trHeadlineCio] := ' ,   ';
  Translation[trHeadlineConstants] := ' ';
  Translation[trHeadlineFunctionsAndProcedures] := '   ';
  Translation[trHeadlineIdentifiers] := ' ';
  Translation[trHeadlineTypes] := ' ';
  Translation[trHeadlineUnits] := ' ';
  Translation[trHeadlineVariables] := ' ';

  Translation[trSummaryCio] := ' ,   ';

end;

{ ---------- }

procedure SetLanguageRussian_866;
begin
  Translation[trAuthor] := '';
  Translation[trAuthors] := '';
  Translation[trCio] := ', 䥩  ꥪ';
  Translation[trClass] := '';
  Translation[trClasses] := '';
  Translation[trConstants] := '⠭';
  Translation[trCreated] := '';
  Translation[trDeclaration] := '';
  Translation[trDescription] := 'ᠭ';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := '';
  Translation[trFunctionsAndProcedures] := '楤  㭪樨';
  Translation[trHelp] := 'Help'; // Untranslated to avoid Russian file name for css
  Translation[trHierarchy] := '';
  Translation[trIdentifiers] := '䨪';
  Translation[trInterface] := '䥩';
  Translation[trLegend] := '祭';
  Translation[trLastModified] := '᫥ ';
  Translation[trMethods] := '⮤';
  Translation[trName] := '';
  Translation[trNone] := '';
  Translation[trObject] := 'ꥪ';
  Translation[trObjects] := 'ꥪ';
  Translation[trOverview] := '';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := '⢠';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := '';
  Translation[trTypes] := '';
  Translation[trUnit] := '';
  Translation[trUnits] := '㫨';
  Translation[trVariables] := '६';
  Translation[trWarningOverwrite] := '।०:  ।஢ -  䠩 ᮧ ⮬᪨      ।०';

  Translation[trHeadlineCio] := ' , 䥩  ꥪ';
  Translation[trHeadlineConstants] := ' ⠭';
  Translation[trHeadlineFunctionsAndProcedures] := ' 楤  㭪樨';
  Translation[trHeadlineIdentifiers] := ' 䨪';
  Translation[trHeadlineTypes] := ' ⨯';
  Translation[trHeadlineUnits] := ' 㫨';
  Translation[trHeadlineVariables] := ' ६';

  Translation[trSummaryCio] := '᮪ ᮢ, 䥩ᮢ  ꥪ⮢';
end;

{ ---------- }

procedure SetLanguageRussian_koi8;
begin
  Translation[trAuthor] := '';
  Translation[trAuthors] := '';
  Translation[trCio] := ',   ';
  Translation[trClass] := '';
  Translation[trClasses] := '';
  Translation[trConstants] := '';
  Translation[trCreated] := '';
  Translation[trDeclaration] := '';
  Translation[trDescription] := '';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := '';
  Translation[trFunctionsAndProcedures] := '  ';
  Translation[trHelp] := 'Help'; // Untranslated to avoid Russian file name for css
  Translation[trHierarchy] := '';
  Translation[trIdentifiers] := '';
  Translation[trInterface] := '';
  Translation[trLegend] := '';
  Translation[trLastModified] := ' ';
  Translation[trMethods] := '';
  Translation[trName] := '';
  Translation[trNone] := '';
  Translation[trObject] := '';
  Translation[trObjects] := '';
  Translation[trOverview] := '';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := '';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := '';
  Translation[trTypes] := '';
  Translation[trUnit] := '';
  Translation[trUnits] := '';
  Translation[trVariables] := '';
  Translation[trWarningOverwrite] := ':   -        Σ  ';

  Translation[trHeadlineCio] := ' ,   ';
  Translation[trHeadlineConstants] := ' ';
  Translation[trHeadlineFunctionsAndProcedures] := '   ';
  Translation[trHeadlineIdentifiers] := ' ';
  Translation[trHeadlineTypes] := ' ';
  Translation[trHeadlineUnits] := ' ';
  Translation[trHeadlineVariables] := ' ';

  Translation[trSummaryCio] := ' ,   ';
end;

{ ---------- }

procedure SetLanguageSlovak;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autori';
  Translation[trCio] := 'Triedy, interfejsy a objekty';
  Translation[trClass] := 'Trieda';
  Translation[trClasses] := 'Triedy';
  Translation[trConstants] := 'Kontanty';
  Translation[trCreated] := 'Vytvoren';
  Translation[trDeclaration] := 'Deklarcie';
  Translation[trDescription] := 'Popis';
  Translation[trFields] := 'Poloky';
  Translation[trFunctionsAndProcedures] := 'Funkcie a procedry';
  Translation[trHierarchy] := 'Hierarchia';
  Translation[trIdentifiers] := 'Identifiktory';
  Translation[trInterface] := 'Interfejs';
  Translation[trLastModified] := 'Posledn zmena';
  Translation[trMethods] := 'Metdy';
  Translation[trName] := 'Meno';
  Translation[trNone] := 'Ni';
  Translation[trObject] := 'Objekt';
  Translation[trObjects] := 'Objekty';
  Translation[trOverview] := 'Overview';
  Translation[trProperties] := 'Monosti';
  Translation[trType] := 'Typ';
  Translation[trTypes] := 'Typy';
  Translation[trUnit] := 'Jednotka';
  Translation[trUnits] := 'Jednotky';
  Translation[trVariables] := 'Premenn';
  Translation[trWarningOverwrite] := 'Upozornenie: Needitujte - tento sbor bol vytvoren automaticky a je pravdepodobn, e bude prepsan';

  Translation[trHeadlineCio] := 'Vetky triedy, interfejsy a objekty';
  Translation[trHeadlineConstants] := 'Vetky kontanty';
  Translation[trHeadlineFunctionsAndProcedures] := 'Vetky funkcie a procedry';
  Translation[trHeadlineIdentifiers] := 'Vetky identifiktory';
  Translation[trHeadlineTypes] := 'Vetky typy';
  Translation[trHeadlineUnits] := 'Vetky jednotky';
  Translation[trHeadlineVariables] := 'Vetky premenn';

  Translation[trSummaryCio] := 'Zoznam tried, interfejsov a objektov';
end;

{ ---------- }

procedure SetLanguageSpanish;
begin
  Translation[trAuthor] := 'Autor';
  Translation[trAuthors] := 'Autores';
  Translation[trCio] := 'Clases, interfaces y objetos';
  Translation[trClass] := 'Clase';
  Translation[trClasses] := 'Clases';
  Translation[trConstants] := 'Constantes';
  Translation[trCreated] := 'Creado';
  Translation[trDeclaration] := 'Declaracin';
  Translation[trDescription] := 'Descripcion';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Campos';
  Translation[trFunctionsAndProcedures] := 'Funciones y procedimientos';
  Translation[trHelp] := 'Help';
  Translation[trHierarchy] := 'Hierarchy';
  Translation[trIdentifiers] := 'Identificadores';
  Translation[trInterface] := 'Interface';
  Translation[trLegend] := 'Legend';
  Translation[trLastModified] := 'ltima modificacin';
  Translation[trMethods] := 'Mtodos';
  Translation[trName] := 'Nombre';
  Translation[trNone] := 'Ninguno';
  Translation[trObject] := 'Objeto';
  Translation[trObjects] := 'Objetos';
  Translation[trOverview] := 'Resumen';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Propiedades';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trUnit] := 'Unidad';
  Translation[trUnits] := 'Unidades';
  Translation[trType] := 'Tipo';
  Translation[trTypes] := 'Tipos';
  Translation[trVariables] := 'Variables';
  Translation[trWarningOverwrite] := 'Atencin, no editar - este fichero ha sido creado automaticamente y sersobrescrito';

  Translation[trHeadlineCio] := 'Todas las clases, interfaces y objetos';
  Translation[trHeadlineConstants] := 'Todas las constantes';
  Translation[trHeadlineFunctionsAndProcedures] := 'Todos las funciones y procedimientos';
  Translation[trHeadlineIdentifiers] := 'Todos los indentificadores';
  Translation[trHeadlineTypes] := 'Todos los tipos';
  Translation[trHeadlineUnits] := 'Todas las unidades';
  Translation[trHeadlineVariables] := 'Todas las variables';

  Translation[trSummaryCio] := 'Lista de clases, interfaces y objetos';
end;

{ ---------- }

procedure SetLanguageSwedish;
begin
  Translation[trAuthor] := 'Frfattare';
  Translation[trAuthors] := 'Frfattare';
  Translation[trCio] := 'Klasser, interface och objekt';
  Translation[trClass] := 'Klass';
  Translation[trClasses] := 'Klasser';
  Translation[trConstants] := 'Constants';
  Translation[trCreated] := 'Skapad';
  Translation[trDeclaration] := 'Deklarationer';
  Translation[trDescription] := 'Beskrivning';
  Translation[trDispInterface] := 'DispInterface';
  Translation[trFields] := 'Flt';
  Translation[trFunctionsAndProcedures] := 'Functions and Procedures';
  Translation[trHelp] := 'Help'; // Untranslated to avoid Swedish file name for css
  Translation[trHierarchy] := 'Hierarki';
  Translation[trIdentifiers] := 'Identifiers';
  Translation[trInterface] := 'Interface';
  Translation[trLegend] := 'Frklaring';
  Translation[trMethods] := 'Metoder';
  Translation[trLastModified] := 'Senast ndrad';
  Translation[trName] := 'Namn';
  Translation[trNone] := 'Ingen/inget.';
  Translation[trObject] := 'Objekt';
  Translation[trObjects] := 'Objekt';
  Translation[trOverview] := 'versikt';
  Translation[trPrivate] := 'Private';
  Translation[trProperties] := 'Properties';
  Translation[trProtected] := 'Protected';
  Translation[trPublic] := 'Public';
  Translation[trPublished] := 'Published';
  Translation[trType] := 'Typer';
  Translation[trTypes] := 'Typer';
  Translation[trUnit] := 'Enhet';
  Translation[trUnits] := 'Enheter';
  Translation[trVariables] := 'Variabler';

  Translation[trHeadlineCio] := 'Alla klasser, interface och objekt';
  Translation[trHeadlineConstants] := 'All Constants';
  Translation[trHeadlineFunctionsAndProcedures] := 'Alla funktioner och procedurer';
  Translation[trHeadlineIdentifiers] := 'Alla identifierare';
  Translation[trHeadlineTypes] := 'Alla typer';
  Translation[trHeadlineUnits] := 'Alla enheter';
  Translation[trHeadlineVariables] := 'Alla variabler';

  Translation[trSummaryCio] := 'Sammanfattning av Klasser, Interface, Objekt';

  Translation[trWarningOverwrite] := 'Varning: ndra inte denna fil manuellt - filen har skapats automatiskt och kommer troligen att skrivas ver vid ett senare tilflle';
end;



end.

