{
pasdoc

- generates documentation from comments in Pascal unit source code files
- command line program
- written in Delphi Pascal
- compiles with Delphi and Kylix
- output formats Html and HtmlHelp
- try pasdoc on its own source code
- get a list of available switches: DIPasDoc /?
- read the manual

- distributed under the GNU General Public License (GPL)

- copyright (C) 1998-2000 by Marco Schmidt
- copyright (C) 2001-2002 by Ralf Junker <delphi@zeitungsjunge.de>

- visit the DIPasDoc homepage at http://www.zeitungsjunge.de/delphi/
- feedback to Ralf Junker <delphi@zeitungsjunge.de>
}

program DIPasDoc;

{$APPTYPE console}

{ Hint:

  Whenever you use pasdoc for documentation purposes, make sure the program file
  - like this one - contains no code except for a call to a main routine in
  another unit or the instantiation of an object / class that does all the work
  (usually TApplication).

  Pasdoc is restricted to work on unit files only, that's why the program file
  should contain no actual program-specific code, it would not become part of
  the documentation. }

uses
  Main,
  Languages in 'Languages.pas',
  Html in 'Html.pas',
  GenDoc in 'GenDoc.pas',
  Arrays in 'Arrays.pas',
  FileStre in 'FileStre.pas';

{$R BinData.res}

var
  p: Main.PPasDoc;
begin
  try
    p := New(PPasDoc, Init);
    if (not Assigned(p)) then
      begin
        WriteLn('Error: Could not initialize program.');
        Halt(1);
      end;
    p^.Run;
    Dispose(p, Done);
  except
    raise
  end;
  // ReadLn;
end.

