{
@abstract(defines some constants for the pasdoc application, including
version, date and platform names)
@lastmod(20 Apr 2000)
@author(Ralf Junker (delphi@zeitungsjunge.de))
@author(Marco Schmidt (marcoschmidt@geocities.com))

This unit specifies a number of constants with information on the pasdoc
application, the compiler used to create the version, date of compilation,
version number and homepage of the pasdoc project.
}
unit AppInfo;

{$I platform.inc}

interface

uses
  CompVer;

const
  { date of last modification }
  APP_DATE = '7. June 2002';
  { name and version of the program to be written to output }
  APP_NAME = 'DIPasDoc';
  APP_VERSION = '0.8.0';
  APP_NAME_AND_VERSION = APP_NAME + ' ' + APP_VERSION;
  { first line to be written to standard output by application,
    made up of name, version, date, operating system etc. }
  APP_FIRST_LINE = APP_NAME_AND_VERSION + ' (' + APP_DATE + ') [' +
    CompilerName + '|' + CompilerOS + '|' + CompilerBits + ']';
  { homepage of the program to get the latest version }
  APP_HOMEPAGE = 'http://www.zeitungsjunge.de/delphi/';

implementation

begin
end.

